/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.util;

import java.nio.CharBuffer;
import java.util.function.Function;

public final class StringUtil {
    public static String capitalize(String text) {
        if (StringUtil.isNullOrEmpty(text)) {
            return text;
        }
        char[] chars = text.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String decapitalize(String text) {
        if (StringUtil.isNullOrEmpty(text)) {
            return text;
        }
        char[] chars = text.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String fromSnakeCaseToCamelCase(String text) {
        if (StringUtil.isNullOrEmpty(text)) {
            return text;
        }
        String[] array = text.split("_");
        if (array.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(array[0].toLowerCase());
        for (int i = 1; i < array.length; ++i) {
            String s = StringUtil.capitalize(array[i].toLowerCase());
            result.append(s);
        }
        return result.toString();
    }

    public static String fromCamelCaseToSnakeCase(String text) {
        return StringUtil.fromCamelCaseToSnakeCaseInternal(text, false);
    }

    public static String fromCamelCaseToSnakeCaseWithLenient(String text) {
        return StringUtil.fromCamelCaseToSnakeCaseInternal(text, true);
    }

    private static String fromCamelCaseToSnakeCaseInternal(String text, boolean lenient) {
        if (StringUtil.isNullOrEmpty(text)) {
            return text;
        }
        Function<Character, Boolean> isNotUpperCase = lenient ? Character::isLowerCase : c -> Character.isLowerCase(c.charValue()) || Character.isDigit(c.charValue());
        StringBuilder result = new StringBuilder();
        CharBuffer buf = CharBuffer.wrap(text);
        while (buf.hasRemaining()) {
            char c2 = buf.get();
            result.append(Character.toLowerCase(c2));
            buf.mark();
            if (!buf.hasRemaining()) continue;
            char c22 = buf.get();
            if (isNotUpperCase.apply(Character.valueOf(c2)).booleanValue() && Character.isUpperCase(c22)) {
                result.append("_");
            }
            buf.reset();
        }
        return result.toString();
    }

    public static boolean isWhitespace(String text) {
        if (StringUtil.isNullOrEmpty(text)) {
            return false;
        }
        for (char ch : text.toCharArray()) {
            if (Character.isWhitespace(ch)) continue;
            return false;
        }
        return true;
    }

    public static String trimWhitespace(String text) {
        int start;
        if (StringUtil.isNullOrEmpty(text)) {
            return text;
        }
        char[] chars = text.toCharArray();
        int end = chars.length;
        for (start = 0; start < end && Character.isWhitespace(chars[start]); ++start) {
        }
        while (start < end && Character.isWhitespace(chars[end - 1])) {
            --end;
        }
        if (start < end) {
            return start > 0 || end < chars.length ? new String(chars, start, end - start) : text;
        }
        return "";
    }

    private static boolean isNullOrEmpty(String text) {
        return text == null || text.isEmpty();
    }
}

