/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.util.AssertionUtil;

public final class ClassUtil {
    public static <T> T newInstance(Class<T> clazz) throws WrapException {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new WrapException(e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) throws WrapException {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new WrapException(e);
        }
    }

    public static <T> Method getMethod(Class<T> clazz, String name, Class<?> ... parameterTypes) throws WrapException {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new WrapException(e);
        }
    }

    public static <T> Method getDeclaredMethod(Class<T> clazz, String name, Class<?> ... parameterTypes) throws WrapException {
        AssertionUtil.assertNotNull(clazz, (Object)name, parameterTypes);
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new WrapException(e);
        }
    }

    public static <T> Field getDeclaredField(Class<T> clazz, String name) throws WrapException {
        AssertionUtil.assertNotNull(clazz, (Object)name);
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new WrapException(e);
        }
    }

    public static String getPackageName(String binaryName) {
        AssertionUtil.assertNotNull(binaryName);
        int pos = binaryName.lastIndexOf(46);
        if (pos < 0) {
            return "";
        }
        return binaryName.substring(0, pos);
    }

    public static List<String> getEnclosingNames(String binaryName) {
        AssertionUtil.assertNotNull(binaryName);
        String packageExcludedName = ClassUtil.getLastPart(binaryName, '.');
        List<String> names = Arrays.asList(packageExcludedName.split("\\$"));
        if (names.size() <= 1) {
            return Collections.emptyList();
        }
        return names.subList(0, names.size() - 1);
    }

    public static String getSimpleName(String binaryName) {
        AssertionUtil.assertNotNull(binaryName);
        String packageExcludedName = ClassUtil.getLastPart(binaryName, '.');
        return ClassUtil.getLastPart(packageExcludedName, '$');
    }

    private static String getLastPart(String text, char ch) {
        int pos = text.lastIndexOf(ch);
        if (pos < 0) {
            return text;
        }
        return text.substring(pos + 1);
    }

    public static Class<?> toBoxedPrimitiveTypeIfPossible(Class<?> clazz) {
        AssertionUtil.assertNotNull(clazz);
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        return clazz;
    }

    public static <R> R traverse(Class<?> clazz, Function<Class<?>, R> f) {
        AssertionUtil.assertNotNull(clazz);
        R r = f.apply(clazz);
        if (r != null) {
            return r;
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            R result2 = ClassUtil.traverse(clazz2, f);
            if (result2 == null) continue;
            return result2;
        }
        Class<?> clazz3 = clazz.getSuperclass();
        if (clazz3 == null) {
            return null;
        }
        return ClassUtil.traverse(clazz3, f);
    }
}

