/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcMappingFunction;
import org.seasar.doma.jdbc.type.JdbcType;
import org.seasar.doma.wrapper.Wrapper;

public class JdbcValueGetter
implements JdbcMappingFunction {
    protected final ResultSet resultSet;
    protected final int index;

    public JdbcValueGetter(ResultSet resultSet, int index) {
        AssertionUtil.assertNotNull(resultSet);
        AssertionUtil.assertTrue(index > 0, index);
        this.resultSet = resultSet;
        this.index = index;
    }

    @Override
    public <R, V> R apply(Wrapper<V> wrapper, JdbcType<V> jdbcType) throws SQLException {
        if (wrapper == null) {
            throw new DomaNullPointerException("wrapper");
        }
        if (jdbcType == null) {
            throw new DomaNullPointerException("jdbcType");
        }
        V value = jdbcType.getValue(this.resultSet, this.index);
        wrapper.set(value);
        return null;
    }
}

