/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.modeljs.util;

import java.util.ArrayList;
import java.util.Arrays;
import javax.vecmath.Vector3d;
import jp.kitec.modeljs.GeometryData;
import jp.kitec.modeljs.util.CGeometry;
import jp.kitec.modeljs.util.Face;

public class GeomUtil {
    public static CGeometry toCGeom(GeometryData gd) {
        CGeometry cg = new CGeometry();
        float[] array = gd.attributes.position.array;
        int vsize = array.length / 3;
        int i = 0;
        while (i < vsize) {
            Vector3d v = new Vector3d((double)array[i * 3 + 0], (double)array[i * 3 + 1], (double)array[i * 3 + 2]);
            cg.vertices.add(v);
            ++i;
        }
        int offset = 0;
        int zLength = gd.index.array.length;
        while (offset < zLength) {
            Face f = new Face();
            f.vertices.add(cg.vertices.get(gd.index.array[offset]));
            f.vertices.add(cg.vertices.get(gd.index.array[offset + 1]));
            f.vertices.add(cg.vertices.get(gd.index.array[offset + 2]));
            cg.faces.add(f);
            offset += 3;
        }
        return cg;
    }

    public static GeometryData toData(CGeometry cg) {
        GeometryData data = new GeometryData();
        ArrayList<Integer> faces = new ArrayList<Integer>();
        for (Face face : cg.faces) {
            for (Vector3d v : face.vertices) {
                faces.add(cg.vertices.indexOf(v));
            }
        }
        data.index.array = new int[faces.size()];
        int i = 0;
        while (i < faces.size()) {
            data.index.array[i] = (Integer)faces.get(i);
            ++i;
        }
        float[] array = data.attributes.position.array = new float[cg.vertices.size() * 3];
        int i2 = 0;
        while (i2 < cg.vertices.size()) {
            Vector3d v;
            v = cg.vertices.get(i2);
            array[i2 * 3 + 0] = (float)v.x;
            array[i2 * 3 + 1] = (float)v.y;
            array[i2 * 3 + 2] = (float)v.z;
            ++i2;
        }
        return data;
    }

    public static GeometryData copy(GeometryData gd) {
        GeometryData cp = new GeometryData();
        cp.attributes.position = GeomUtil.copyFloatAttribute(gd.attributes.position);
        cp.attributes.normal = GeomUtil.copyFloatAttribute(gd.attributes.normal);
        cp.attributes.uv = GeomUtil.copyFloatAttribute(gd.attributes.uv);
        cp.index = GeomUtil.copyIntAttribute(gd.index);
        return cp;
    }

    private static GeometryData.BufferIntAttribute copyIntAttribute(GeometryData.BufferIntAttribute org) {
        if (org == null) {
            return null;
        }
        GeometryData.BufferIntAttribute cp = new GeometryData.BufferIntAttribute(org.itemSize, org.type);
        cp.array = Arrays.copyOf(org.array, org.array.length);
        return cp;
    }

    private static GeometryData.BufferFloatAttribute copyFloatAttribute(GeometryData.BufferFloatAttribute org) {
        if (org == null) {
            return null;
        }
        GeometryData.BufferFloatAttribute cp = new GeometryData.BufferFloatAttribute(org.itemSize, org.type);
        cp.array = Arrays.copyOf(org.array, org.array.length);
        return cp;
    }
}

