/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.modeljs.processor;

import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import jp.kitec.modeljs.processor.Processor2;
import jp.kitec.modeljs.processor.Stretch2;
import jp.kitec.modeljs.v2.ShapeA;

public class Stretch2ProcessorV2
extends Processor2<Stretch2> {
    @Override
    public ShapeA process(ShapeA shape, ShapeA cp, Stretch2 deform) {
        Vector3d v3 = new Vector3d();
        Vector3d w3 = new Vector3d();
        if (deform.axis.epsilonEquals((Tuple3d)deform.n, 1.0E-6)) {
            for (Integer key : shape.vertices.keySet()) {
                Vector3d p = shape.vertices.get(key);
                Vector3d p2 = cp.vertices.get(key);
                double dot = p.dot(deform.axis);
                if (dot < 0.0) continue;
                v3.set((Tuple3d)p);
                w3.set((Tuple3d)deform.axis);
                w3.scale(deform.max - dot);
                v3.add((Tuple3d)w3);
                p2.set((Tuple3d)v3);
            }
        } else {
            Vector4d v = new Vector4d();
            Vector3d i = new Vector3d();
            Vector3d j = new Vector3d();
            v3.set((Tuple3d)deform.axis);
            w3.set((Tuple3d)deform.n);
            i.cross(deform.axis, deform.n);
            j.cross(deform.n, i);
            Matrix4d m1 = new Matrix4d();
            m1.set(new double[]{deform.axis.x, i.x, j.x, 0.0, deform.axis.y, i.y, j.y, 0.0, deform.axis.z, i.z, j.z, 0.0, 0.0, 0.0, 0.0, 1.0});
            m1.invert();
            for (Integer key : shape.vertices.keySet()) {
                Vector3d p = shape.vertices.get(key);
                Vector3d p2 = cp.vertices.get(key);
                v.set(p.x, p.y, p.z, 1.0);
                m1.transform((Tuple4d)v);
                if (v.x <= 0.0) continue;
                v3.set((Tuple3d)deform.axis);
                v3.scale(v.x - deform.max);
                w3.set((Tuple3d)p);
                w3.sub((Tuple3d)v3);
                p2.set((Tuple3d)w3);
            }
        }
        return cp;
    }
}

