/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.modeljs.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.kitec.modeljs.processor.Clipping;
import jp.kitec.modeljs.processor.Processor2;
import jp.kitec.modeljs.v2.ShapeA;
import jp.kitec.modeljs.v2.temp.FaceB;
import jp.kitec.modeljs.v2.temp.LineB;
import jp.kitec.modeljs.v2.temp.ShapeB;
import jp.kitec.modeljs.v2.temp.ShapeUtil;

public class ClipProcessor2
extends Processor2<Clipping> {
    @Override
    public ShapeA process(ShapeA shape, ShapeA cp, Clipping deform) {
        boolean outFlag;
        boolean or;
        boolean and;
        ArrayList<Boolean> outFlagList;
        ArrayList<Double> paramList;
        ShapeB cg = ShapeUtil.convert(cp);
        HashMap<Vector3d, Double> paramMap = new HashMap<Vector3d, Double>();
        for (Vector3d v : cg.vertices) {
            double dot = deform.n.dot(v);
            paramMap.put(v, dot);
        }
        ArrayList<FaceB> deleteList = new ArrayList<FaceB>();
        ArrayList<FaceB> addedFaceList = new ArrayList<FaceB>();
        ArrayList<LineB> deleteLineList = new ArrayList<LineB>();
        ArrayList addedLineList = new ArrayList();
        ArrayList<Vector3d> addedVerticesList = new ArrayList<Vector3d>();
        ArrayList<Vector3d> addedSectionVerticesList = new ArrayList<Vector3d>();
        for (LineB l : cg.lines) {
            paramList = new ArrayList<Double>();
            outFlagList = new ArrayList<Boolean>();
            and = true;
            or = false;
            int vi = 0;
            while (vi < 2) {
                Vector3d v = vi == 0 ? l.v1 : l.v2;
                double param = (Double)paramMap.get(v);
                outFlag = deform.max < param;
                or |= outFlag;
                and &= outFlag;
                paramList.add(param);
                outFlagList.add(outFlag);
                ++vi;
            }
            if (and) {
                deleteLineList.add(l);
                continue;
            }
            if (!or) continue;
            deleteLineList.add(l);
        }
        for (FaceB f : cg.faces) {
            paramList = new ArrayList();
            outFlagList = new ArrayList();
            and = true;
            or = false;
            for (Vector3d v : f.vertices) {
                double param = (Double)paramMap.get(v);
                outFlag = deform.max < param;
                or |= outFlag;
                and &= outFlag;
                paramList.add(param);
                outFlagList.add(outFlag);
            }
            if (and) {
                deleteList.add(f);
                continue;
            }
            if (!or) continue;
            deleteList.add(f);
            ArrayList<Vector3d> vlist = new ArrayList<Vector3d>();
            int i = 0;
            while (i < f.vertices.size()) {
                Vector3d v = f.vertices.get(i);
                double param = (Double)paramList.get(i);
                int nextIndex = i == f.vertices.size() - 1 ? 0 : i + 1;
                int prevIndex = i == 0 ? f.vertices.size() - 1 : i - 1;
                boolean outFlag2 = (Boolean)outFlagList.get(i);
                if (!outFlag2) {
                    vlist.add(v);
                } else {
                    Vector3d newPoint;
                    Vector3d t;
                    Vector3d diff;
                    double ratio;
                    Vector3d vb;
                    Vector3d va;
                    if (!((Boolean)outFlagList.get(prevIndex)).booleanValue()) {
                        double paramPrev = (Double)paramList.get(prevIndex);
                        va = f.vertices.get(prevIndex);
                        vb = v;
                        ratio = (deform.max - paramPrev) / (param - paramPrev);
                        diff = new Vector3d();
                        diff.sub((Tuple3d)vb, (Tuple3d)va);
                        diff.scale(ratio);
                        t = new Vector3d();
                        t.add((Tuple3d)va, (Tuple3d)diff);
                        newPoint = this.addPoint(addedVerticesList, t);
                        vlist.add(newPoint);
                        this.addPoint(addedSectionVerticesList, newPoint);
                    }
                    if (!((Boolean)outFlagList.get(nextIndex)).booleanValue()) {
                        double paramNext = (Double)paramList.get(nextIndex);
                        va = f.vertices.get(nextIndex);
                        vb = v;
                        ratio = (deform.max - paramNext) / (param - paramNext);
                        diff = new Vector3d();
                        diff.sub((Tuple3d)vb, (Tuple3d)va);
                        diff.scale(ratio);
                        t = new Vector3d();
                        t.add((Tuple3d)va, (Tuple3d)diff);
                        newPoint = this.addPoint(addedVerticesList, t);
                        vlist.add(newPoint);
                        this.addPoint(addedSectionVerticesList, newPoint);
                    }
                }
                ++i;
            }
            int vsize = vlist.size();
            if (vsize == 3) {
                FaceB newFace = new FaceB();
                newFace.vertices.addAll(vlist);
                addedFaceList.add(newFace);
                continue;
            }
            if (vsize <= 3) continue;
            int i2 = 0;
            while (i2 < vsize - 2) {
                FaceB newFace = new FaceB();
                newFace.vertices.add((Vector3d)vlist.get(0));
                newFace.vertices.add((Vector3d)vlist.get(i2 + 1));
                newFace.vertices.add((Vector3d)vlist.get(i2 + 2));
                addedFaceList.add(newFace);
                ++i2;
            }
        }
        cg.lines.removeAll(deleteLineList);
        cg.faces.removeAll(deleteList);
        for (Vector3d v : paramMap.keySet()) {
            if (!((Double)paramMap.get(v) > deform.max)) continue;
            cg.vertices.remove(v);
        }
        cg.faces.addAll(addedFaceList);
        cg.lines.addAll(addedLineList);
        cg.vertices.addAll(addedVerticesList);
        ShapeA d = ShapeUtil.toA(cg);
        return d;
    }

    private Vector3d addPoint(List<Vector3d> list, Vector3d v) {
        for (Vector3d o : list) {
            if (!o.epsilonEquals((Tuple3d)v, 1.0E-6)) continue;
            return o;
        }
        list.add(v);
        return v;
    }
}

