/*
 * Decompiled with CFR 0.152.
 */
package com.kt.db;

import d.d;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class ConnectionObject {
    private String mConnectionTag;
    private String mUrl;
    private String mUser;
    private String mPasswd;
    private String mDriver;
    private String mCheckSQL;
    private ObjectPool mObjectPool = null;
    private String mDefEnc;
    private boolean mUsePool = true;

    public ConnectionObject(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        this.mConnectionTag = string;
        this.mUrl = string2;
        this.mUser = string3;
        this.mPasswd = string4;
        this.mDriver = string5;
        this.mCheckSQL = string6;
        this.loadDriver();
        if (this.mUsePool) {
            this.createConnectionPool();
        }
    }

    public void setDefEncode(String string) {
        this.mDefEnc = string;
    }

    public Connection getConnection() throws Exception {
        Connection connection = null;
        if (this.mUsePool) {
            connection = (Connection)this.mObjectPool.borrowObject();
            if (d.d) {
                int n = 0;
                int n2 = 0;
                if (this.mObjectPool != null) {
                    n = ((GenericObjectPool)this.mObjectPool).getNumActive();
                    n2 = ((GenericObjectPool)this.mObjectPool).getNumIdle();
                }
                if (d.d) {
                    System.out.println("active:" + n);
                    System.out.println("Idle  :" + n2);
                }
            }
        } else {
            connection = DriverManager.getConnection(this.mUrl, this.mUser, this.mPasswd);
        }
        return connection;
    }

    protected void createConnectionPool() {
        try {
            this.mObjectPool = new GenericObjectPool(null);
            ((GenericObjectPool)this.mObjectPool).setMaxIdle(30);
            ((GenericObjectPool)this.mObjectPool).setMaxActive(30);
            DriverManagerConnectionFactory driverManagerConnectionFactory = new DriverManagerConnectionFactory(this.mUrl, this.mUser, this.mPasswd);
            new PoolableConnectionFactory((ConnectionFactory)driverManagerConnectionFactory, this.mObjectPool, null, this.mCheckSQL, false, true);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public String getTag() {
        return this.mConnectionTag;
    }

    public boolean isMutchTag(String string) {
        return string != null && string.equalsIgnoreCase(this.mConnectionTag);
    }

    private void loadDriver() {
        try {
            Class.forName(this.mDriver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }
}

