/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.object;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.io.PdfStream;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.ImageXObject;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.object.PdfXObject;
import option.io.pdfcommon.util.PdfMetrices;

public class ImageXObjectJpeg
extends ImageXObject
implements DefinedName,
PdfXObject {
    private PdfDictionary dict = new PdfDictionary();
    private PdfStream stream;
    private PdfName aR;
    private int width = 1;
    private int height = 1;
    private PdfMetrices cz = new PdfMetrices(2);

    public ImageXObjectJpeg() {
        this.dict.put(TYPE, XOBJECT);
        this.dict.put(SUBTYPE, IMAGE);
    }

    public ImageXObjectJpeg(byte[] byArray, int n, int n2) {
        this();
        this.setImage(byArray, n, n2);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.stream != null) {
                this.stream.flush();
                this.stream.close();
                this.stream = null;
            }
        }
        catch (Exception exception) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
            }
            exception.printStackTrace();
        }
        super.finalize();
    }

    public void setWidth(int n) {
        this.width = n;
        this.dict.put(WIDTH, new Integer(n));
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
        this.dict.put(HEIGHT, new Integer(n));
    }

    public int getHeight() {
        return this.height;
    }

    public void setName(PdfName pdfName) {
        this.aR = pdfName;
    }

    public void setName(String string) {
        this.setName(new PdfName(string));
    }

    public PdfName getName() {
        return this.aR;
    }

    public PdfMetrices getMTransMatrices() {
        return this.cz;
    }

    public void setMTransMatrices(PdfMetrices pdfMetrices) {
        this.cz = pdfMetrices;
    }

    public void setImage(Image object) throws IllegalStateException {
        Serializable serializable = new MediaTracker(new Canvas());
        serializable.addImage((Image)object, 0);
        try {
            serializable.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            serializable = interruptedException;
            interruptedException.printStackTrace();
            return;
        }
        int n = ((Image)object).getWidth(null);
        int n2 = ((Image)object).getHeight(null);
        if (n < 0 || n2 < 0) {
            throw new IllegalStateException("width or height value is not accepted.");
        }
        int[] nArray = new int[n * n2];
        try {
            object = new PixelGrabber((Image)object, 0, 0, n, n2, nArray, 0, n);
            ((PixelGrabber)object).grabPixels();
        }
        catch (InterruptedException interruptedException) {
            object = interruptedException;
            interruptedException.printStackTrace();
            return;
        }
        this.setImage(nArray, n, n2);
    }

    /*
     * Loose catch block
     */
    protected void setImage(byte[] object, int n, int n2) {
        this.setEntries();
        this.setWidth(n);
        this.setHeight(n2);
        this.stream = new PdfStream();
        this.stream.write((byte[])object);
        this.stream.flush();
        try {
            this.stream.close();
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            try {
                object = iOException;
                iOException.printStackTrace();
            }
            catch (Throwable throwable) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException2) {
                    IOException iOException3 = iOException2;
                    iOException2.printStackTrace();
                }
                throw throwable;
            }
            try {
                this.stream.close();
                return;
            }
            catch (IOException iOException4) {
                object = iOException4;
                iOException4.printStackTrace();
                return;
            }
        }
    }

    protected void setEntries() {
        this.dict.put(FILTER, DCTDECODE);
        this.dict.put(COLORSPACE, DEVICERGB);
        this.dict.put(BITSPERCOMPONENT, new Integer(8));
        this.dict.put(INTERPOLATE, new Boolean(true));
    }

    public void write(PdfOutFile pdfOutFile) {
        try {
            this.dict.put(LENGTH, new Integer(this.stream.size()));
            PrintStream printStream = pdfOutFile.getPrintStream();
            this.startObject(pdfOutFile);
            printStream.println(this.dict);
            printStream.println("stream");
            this.stream.writeTo(pdfOutFile.getByteStream());
            printStream.println("endstream");
            this.endObject(pdfOutFile);
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.getName().equals(((ImageXObject)object).getName());
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }
}

