/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui.table;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jp.kitec.richui.table.Cell;
import jp.kitec.richui.table.CellGroup;
import jp.kitec.richui.table.CellType;
import jp.kitec.richui.table.Table;

public class MiddleColumnHeaderTable
extends Table {
    protected CellGroup mMiddleColumnHeaders;
    protected int[] mMiddleColumnHeadersLink;

    public MiddleColumnHeaderTable() {
    }

    public MiddleColumnHeaderTable(int[][] nArray) {
        super(nArray);
    }

    public MiddleColumnHeaderTable(boolean bl) {
        super(bl);
    }

    public void init() {
        if (this.mMiddleColumnHeaders != null) {
            this.mMiddleColumnHeaders.removeAllCells();
        }
        this.mMiddleColumnHeadersLink = null;
        this.mColumnHeaders.removeAllCells();
        this.mCells.clear();
        this.mRowHeaders.removeAllCells();
        this.mTableWidth = 0;
        this.mTableHeight = 0;
        this.mRowHeaderWidth = 0;
        this.mRowHeight = 0;
        this.mFirstRow = 0;
        this.mTotalColumnWidth = 0;
        this.mHScrollValue = 0;
        this.mVScrollValue = 0;
        this.mColumnWidths = null;
        this.mColumnCount = 0;
        this.mRowCount = 0;
        this.mHScrollbarWidth = 0;
        this.mVScrollbarHeight = 0;
        this.mDraggedX = 0;
        this.mDraggedColumn = 0;
        this.mEditorX = 0;
        this.mEditorY = 0;
        this.mEditorWidth = 0;
        this.mSelectedRow = -1;
        this.mSelectedColumn = -1;
        this.mAutoResizeColumnWidth = true;
        this.mIsResized = true;
        this.mColumnAlignments = null;
        this.mIsColumnEditables = null;
        if (this.mSrlHorizontal != null) {
            this.mSrlHorizontal.setValue(0);
        }
        if (this.mSrlVertical != null) {
            this.mSrlVertical.setValue(0);
        }
    }

    public void dispose() {
        this.disposeOffImage();
        if (this.mMiddleColumnHeaders != null) {
            this.mMiddleColumnHeaders.removeAllCells();
        }
        this.mMiddleColumnHeadersLink = null;
        this.mColumnHeaders.removeAllCells();
        this.mColumnHeaders = null;
        this.mCells.clear();
        this.mCells = null;
        this.mRowHeaders.removeAllCells();
        this.mRowHeaders = null;
        this.mColumnWidths = null;
        this.mFontMetrics = null;
        this.mColumnAlignments = null;
        this.mIsColumnEditables = null;
    }

    public void setMiddleColumnHeader(String[] stringArray) {
        this.mMiddleColumnHeaders = new CellGroup(stringArray);
        this.mMiddleColumnHeadersLink = new int[stringArray.length];
        this.mMiddleColumnHeadersLink[0] = 0;
        for (int i = 1; i < stringArray.length; ++i) {
            this.mMiddleColumnHeadersLink[i] = stringArray[i - 1] != null && stringArray[i] != null && stringArray[i - 1].equals(stringArray[i]) ? this.mMiddleColumnHeadersLink[i - 1] : i;
        }
    }

    public String getMiddleColumnHeader(int n) {
        if (this.mMiddleColumnHeaders == null) {
            return null;
        }
        return this.mMiddleColumnHeaders.getCell(n).getValue();
    }

    public void removeColumn(int n) {
        int n2;
        int n3;
        int n4 = this.mSelectedRow;
        if (this.mSelectedRow >= 0) {
            this.clearSelection();
        }
        for (n3 = 0; n3 < this.mColumnCount; ++n3) {
            CellGroup cellGroup = this.getRow(n3);
            cellGroup.removeCell(n);
        }
        this.mColumnHeaders.removeCell(n);
        n3 = 0;
        for (n2 = 0; n2 < this.mColumnCount; ++n2) {
            if (this.mMiddleColumnHeadersLink[n2] != n) continue;
            ++n3;
        }
        if (n3 == 1) {
            int[] nArray = new int[this.mMiddleColumnHeadersLink.length - 1];
            int n5 = 0;
            for (int i = 0; i < this.mColumnCount; ++i) {
                if (this.mMiddleColumnHeadersLink[i] == n) {
                    this.mMiddleColumnHeaders.removeCell(i);
                    continue;
                }
                nArray[n5++] = this.mMiddleColumnHeadersLink[i];
            }
            this.mMiddleColumnHeadersLink = nArray;
        }
        n2 = this.mColumnCount - 1;
        boolean[] blArray = new boolean[n2];
        int[] nArray = new int[n2];
        this.mColumnWidths = new int[n2];
        int n6 = 0;
        for (int i = 0; i < this.mColumnCount; ++i) {
            if (i == n) continue;
            blArray[n6] = this.mIsColumnEditables[i];
            nArray[n6] = this.mColumnAlignments[i];
            this.mColumnWidths[n6] = 100;
            ++n6;
        }
        this.mIsColumnEditables = blArray;
        this.mColumnAlignments = this.mColumnWidths;
        --this.mColumnCount;
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.selectRow(n4);
    }

    protected boolean drawMiddleColumnHeader(Graphics graphics) {
        if (this.mMiddleColumnHeadersLink == null) {
            return false;
        }
        int n = this.mRowHeaderWidth - this.mHScrollValue;
        for (int i = 0; i < this.mColumnCount; ++i) {
            int n2 = this.mColumnWidths[i];
            for (int j = i + 1; j < this.mColumnCount && this.mMiddleColumnHeadersLink[i] == this.mMiddleColumnHeadersLink[j]; ++j) {
                n2 += this.mColumnWidths[j];
                ++i;
            }
            graphics.setColor(COLOR_HEADER_BACKGROUND);
            graphics.fillRect(n + 1, 0, n2 - 2, this.mRowHeight);
            graphics.setColor(COLOR_HEADER_TEXT);
            String string = this.mMiddleColumnHeaders.getCell(i).getValue();
            int n3 = n + n2 / 2 - this.mFontMetrics.stringWidth(string) / 2;
            if (n3 < n + 3) {
                n3 = n + 3;
            }
            if (string != null && !string.equals("")) {
                graphics.drawString(string, n3, this.mRowHeight - 4 + 1);
                graphics.setColor(COLOR_TABLE_BORDER);
                graphics.drawLine(n + n2 - 1, 0, n + n2 - 1, this.mRowHeight - 1);
                graphics.setColor(COLOR_HEADER_LTBACKGROUND);
                graphics.drawLine(n + n2, 0, n + n2, this.mRowHeight - 1);
                graphics.drawLine(n, 2, n + n2 - 2, 2);
            }
            n += n2;
        }
        graphics.setColor(COLOR_HEADER_BACKGROUND);
        graphics.fillRect(0, 0, this.mRowHeaderWidth + 1, this.mRowHeight);
        graphics.fillRect(n + 1, 0, this.mTableWidth - n, this.mRowHeight);
        graphics.drawLine(0, 0, 0, this.mRowHeight - 1);
        return true;
    }

    protected void calculateEditotPosition() {
        if (this.mSelectedColumn == -1) {
            return;
        }
        int n = -this.mHScrollValue;
        for (int i = 0; i < this.mSelectedColumn; ++i) {
            int n2 = this.mColumnWidths[i];
            n += n2;
        }
        this.mEditorX = n + this.mRowHeaderWidth;
        this.mEditorY = (this.mSelectedRow - this.mFirstRow + 1 + (this.mMiddleColumnHeadersLink != null ? 1 : 0)) * this.mRowHeight;
        this.mEditorWidth = 0;
        if (this.mColumnWidths != null) {
            this.mEditorWidth = this.mColumnWidths[this.mSelectedColumn];
        }
    }

    protected void drawColumnHeader(Graphics graphics) {
        int n = this.mRowHeaderWidth - this.mHScrollValue;
        int n2 = 0;
        if (this.drawMiddleColumnHeader(graphics)) {
            n2 = this.mRowHeight + 1;
        }
        for (int i = 0; i < this.mColumnCount; ++i) {
            int n3 = this.mColumnWidths[i];
            graphics.setColor(COLOR_HEADER_BACKGROUND);
            graphics.fillRect(n + 1, n2, n3 - 2, this.mRowHeight);
            graphics.setColor(COLOR_HEADER_TEXT);
            String string = this.mColumnHeaders.getCell(i).getValue();
            int n4 = n + n3 / 2 - this.mFontMetrics.stringWidth(string) / 2;
            if (n4 < n + 3) {
                n4 = n + 3;
            }
            graphics.drawString(string, n4, n2 + this.mRowHeight - 4 + 1);
            graphics.setColor(COLOR_TABLE_BORDER);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + this.mRowHeight - 1);
            graphics.setColor(COLOR_HEADER_LTBACKGROUND);
            graphics.drawLine(n + n3, n2, n + n3, n2 + this.mRowHeight - 1);
            graphics.drawLine(n, n2 + 2, n + n3 - 2, n2 + 2);
            n += n3;
        }
        graphics.setColor(COLOR_HEADER_BACKGROUND);
        graphics.fillRect(0, n2, this.mRowHeaderWidth + 1, this.mRowHeight);
        graphics.fillRect(n + 1, n2, this.mTableWidth - n, this.mRowHeight);
        graphics.drawLine(0, n2, 0, n2 + this.mRowHeight - 1);
    }

    protected void drawRows(Graphics graphics) {
        int n;
        int n2 = 0;
        for (n = this.mRowHeight + 1 - this.mVScrollValue; n < this.mRowHeight + 1; n += this.mRowHeight) {
            ++n2;
        }
        this.mFirstRow = n2;
        if (this.mMiddleColumnHeadersLink != null) {
            n += this.mRowHeight + 1;
        }
        while (n < this.mTableHeight && n2 < this.mRowCount) {
            int n3 = this.mRowHeaderWidth - this.mHScrollValue;
            for (int i = 0; i < this.mColumnCount; ++i) {
                int n4;
                Cell cell = this.getCell(n2, i);
                Color color = this.mSelectedRow == n2 ? COLOR_SELECTED_ROW : this.getTableBackgoundColor(cell.getType());
                graphics.setColor(color);
                int n5 = this.mColumnWidths[i];
                graphics.fillRect(n3, n, n5 - 1, this.mRowHeight - 1);
                graphics.setColor(COLOR_CELL_TEXT);
                String string = this.getValueAt(n2, i);
                int n6 = this.mFontMetrics.stringWidth(string);
                if (n6 + 6 < n5) {
                    switch (this.getAlignment(n2, i)) {
                        case 1: {
                            n4 = n3 + (n5 - n6) / 2;
                            break;
                        }
                        case 2: {
                            n4 = n3 + n5 - n6 - 3;
                            break;
                        }
                        default: {
                            n4 = n3 + 3;
                            break;
                        }
                    }
                } else {
                    n4 = n3 + 3;
                }
                graphics.drawString(string, n4, n + this.mRowHeight - 4);
                graphics.setColor(COLOR_CELL_BORDER);
                graphics.drawLine(n3 + n5 - 1, n, n3 + n5 - 1, n + this.mRowHeight - 1);
                graphics.drawLine(n3, n + this.mRowHeight - 1, n3 + n5 - 1, n + this.mRowHeight - 1);
                n3 += n5;
            }
            this.drawRowHeader(graphics, this.mRowHeaders.getCell(n2).getValue(), n3, n);
            ++n2;
            n += this.mRowHeight;
        }
    }

    protected class MouseClickListener
    extends MouseAdapter {
        protected int clickCount = 2;

        protected MouseClickListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            if (MiddleColumnHeaderTable.this.mRowHeight == 0 || n2 > MiddleColumnHeaderTable.this.mTableWidth || n3 > MiddleColumnHeaderTable.this.mTableHeight) {
                MiddleColumnHeaderTable.this.mSelectedRow = -1;
                MiddleColumnHeaderTable.this.clearSelection();
                return;
            }
            n2 += MiddleColumnHeaderTable.this.mHScrollValue - MiddleColumnHeaderTable.this.mRowHeaderWidth;
            int n4 = -1;
            for (n = 0; n < MiddleColumnHeaderTable.this.mColumnCount; ++n) {
                int n5 = MiddleColumnHeaderTable.this.mColumnWidths[n];
                if (n2 >= 0 && n2 <= n5) {
                    n4 = n;
                    break;
                }
                n2 -= n5;
            }
            if (MiddleColumnHeaderTable.this.mEditor.isEnabled()) {
                MiddleColumnHeaderTable.this.select(-1, -1);
            }
            if (n3 < MiddleColumnHeaderTable.this.mRowHeight) {
                return;
            }
            n = n3 / MiddleColumnHeaderTable.this.mRowHeight - 1 + MiddleColumnHeaderTable.this.mFirstRow + (MiddleColumnHeaderTable.this.mMiddleColumnHeadersLink != null ? -1 : 0);
            if (mouseEvent.getX() < MiddleColumnHeaderTable.this.mRowHeaderWidth && n3 < MiddleColumnHeaderTable.this.mRowHeight * (MiddleColumnHeaderTable.this.mRowCount + 1)) {
                MiddleColumnHeaderTable.this.selectRow(n);
            } else if (n >= 0 && n < MiddleColumnHeaderTable.this.mRowCount) {
                if (n4 >= 0 && n4 < MiddleColumnHeaderTable.this.mColumnCount) {
                    Cell cell = MiddleColumnHeaderTable.this.getCell(n, n4);
                    if (cell.getType() == CellType.BUTTON) {
                        MiddleColumnHeaderTable.this.select(n, n4);
                        cell.getClickAction().doAction();
                    } else if (mouseEvent.getClickCount() >= this.clickCount) {
                        MiddleColumnHeaderTable.this.select(n, n4);
                    } else {
                        MiddleColumnHeaderTable.this.selectRow(n);
                    }
                } else {
                    MiddleColumnHeaderTable.this.select(n, -1);
                }
            } else {
                MiddleColumnHeaderTable.this.mSelectedRow = -1;
                MiddleColumnHeaderTable.this.clearSelection();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getX() > MiddleColumnHeaderTable.this.mTableWidth) {
                MiddleColumnHeaderTable.this.setCursor(new Cursor(0));
            }
        }

        public void setClickCount(int n) {
            this.clickCount = n;
        }
    }
}

