/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.kwt;

import com.kt.geom.KLocalAxis;
import com.kt.util.KCollection;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import jp.kitec.kwt.AbstractRichGraphics;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.IRichGraphics2;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KGradientFill;
import jp.kitec.kwt.KLineType;
import jp.kitec.kwt.KLinearGradientFill;
import jp.kitec.kwt.KRadialGradientFill;
import jp.kitec.kwt.RichGraphicsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KRichGraphics
extends AbstractRichGraphics
implements IRichGraphics,
IRichGraphics2 {
    private Graphics mGC;
    private RenderingHints qualityHints;
    private boolean mNullStrokeMode = true;
    private AffineTransform mWorkTransform = new AffineTransform();
    private GeneralPath _path = new GeneralPath();
    private boolean mQuality;

    public void setQuality(boolean bl) {
        this.mQuality = bl;
        if (this.mQuality) {
            this.qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        } else {
            this.qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public boolean getQuality() {
        return this.mQuality;
    }

    public void setNullStrokeEnd(boolean bl) {
        this.mNullStrokeMode = bl;
    }

    private void updateDrawQuality(Graphics2D graphics2D) {
        graphics2D.setRenderingHints(this.qualityHints);
    }

    public void setGC(Graphics graphics) {
        this.mGC = graphics;
    }

    public Object getGC() {
        return this.mGC;
    }

    public void releaseGC() {
        this.mGC = null;
    }

    public KRichGraphics() {
        this.setQuality(false);
        this.setNullStrokeEnd(true);
    }

    public void setTextDrawer(Object object) {
    }

    @Override
    public void setClipArea(float f, float f2, float f3, float f4) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics graphics = this.mGC;
            int n = this.realToDevX(Math.min(f, f3));
            int n2 = this.realToDevY(Math.max(f2, f4));
            int n3 = this.realToDevX(Math.max(f, f3));
            int n4 = this.realToDevY(Math.min(f2, f4));
            graphics.setClip(n, n2, n3 - n, n4 - n2);
        }
    }

    @Override
    public void releaseClipArea() {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics graphics = this.mGC;
            Dimension dimension = this.mDimension;
            graphics.setClip(0, 0, dimension.width, dimension.height);
        }
    }

    public void drawBufferImage(Image image) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            this.mGC.drawImage(image, 0, 0, null);
        }
    }

    @Override
    public void setColor(Color color) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            graphics2D.setColor(color);
        }
    }

    @Override
    public void setColor(KGradientFill kGradientFill) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            double[] dArray = kGradientFill.getFractions();
            Color[] colorArray = kGradientFill.getColor();
            float[] fArray = new float[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                fArray[i] = (float)dArray[i];
            }
            if (kGradientFill instanceof KLinearGradientFill) {
                KLinearGradientFill kLinearGradientFill = (KLinearGradientFill)kGradientFill;
                float f = this.realToDevX(kLinearGradientFill.getStartX());
                float f2 = this.realToDevY(kLinearGradientFill.getStartY());
                float f3 = this.realToDevX(kLinearGradientFill.getEndX());
                float f4 = this.realToDevY(kLinearGradientFill.getEndY());
                Paint paint = this.createLinearGradientPaint(f, f2, f3, f4, fArray, colorArray);
                graphics2D.setPaint(paint);
            } else if (kGradientFill instanceof KRadialGradientFill) {
                KRadialGradientFill kRadialGradientFill = (KRadialGradientFill)kGradientFill;
                float f = this.realToDevX(kRadialGradientFill.getCenterX());
                float f5 = this.realToDevY(kRadialGradientFill.getCenterY());
                float f6 = this.realToDevX(kRadialGradientFill.getFocusX());
                float f7 = this.realToDevY(kRadialGradientFill.getFocusY());
                float f8 = (float)(kRadialGradientFill.getRadius() * (double)this.mDotPerLen);
                Paint paint = this.createRadialGradientPaint(f, f5, f8, f6, f7, fArray, colorArray);
                graphics2D.setPaint(paint);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    protected Paint createLinearGradientPaint(float f, float f2, float f3, float f4, float[] fArray, Color[] colorArray) {
        try {
            Class<?> clazz = Class.forName("java.awt.LinearGradientPaint");
            Constructor<?> constructor = clazz.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, float[].class, Color[].class);
            return (Paint)constructor.newInstance(Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), fArray, colorArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    protected Paint createRadialGradientPaint(float f, float f2, float f3, float f4, float f5, float[] fArray, Color[] colorArray) {
        try {
            Class<?> clazz = Class.forName("java.awt.RadialGradientPaint");
            Class<?> clazz2 = Class.forName("java.awt.MultipleGradientPaint.CycleMethod");
            Field field = clazz2.getField("NO_CYCLE");
            Object object = field.get(null);
            Constructor<?> constructor = clazz.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, float[].class, Color[].class, clazz2);
            return (Paint)constructor.newInstance(Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), fArray, colorArray, object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void drawLine(float f, float f2, float f3, float f4, KLineType kLineType) {
        if (this.mGC == null) {
            return;
        }
        double d2 = this.realToDevXd(f);
        double d3 = this.realToDevYd(f2);
        double d4 = this.realToDevXd(f3);
        double d5 = this.realToDevYd(f4);
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            graphics2D.draw(new Line2D.Double(d2, d3, d4, d5));
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    @Override
    public void drawCircle(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        double d2 = this.realToDevXd(f);
        double d3 = this.realToDevYd(f2);
        double d4 = f3 * this.mDotPerLen;
        if (d2 + d4 < 0.0 || d2 - d4 > (double)this.mDimension.width) {
            return;
        }
        if (d3 + d4 < 0.0 || d3 - d4 > (double)this.mDimension.height) {
            return;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            if (f4 == f5) {
                graphics2D.draw(new Arc2D.Double(d2 - d4, d3 - d4, d4 * 2.0, d4 * 2.0, 0.0, 360.0, 0));
            } else {
                graphics2D.draw(new Arc2D.Double(d2 - d4, d3 - d4, d4 * 2.0, d4 * 2.0, f4, f5 - f4, 0));
            }
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    @Override
    public void drawFillCircle(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        double d2 = this.realToDevXd(f);
        double d3 = this.realToDevYd(f2);
        double d4 = f3 * this.mDotPerLen;
        if (d2 + d4 < 0.0 || d2 - d4 > (double)this.mDimension.width) {
            return;
        }
        if (d3 + d4 < 0.0 || d3 - d4 > (double)this.mDimension.height) {
            return;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            if (f4 == f5) {
                graphics2D.fill(new Arc2D.Double(d2 - d4 - 0.0, d3 - d4, d4 * 2.0, d4 * 2.0, 0.0, 360.0, 0));
            } else {
                graphics2D.fill(new Arc2D.Double(d2 - d4 - 0.0, d3 - d4, d4 * 2.0, d4 * 2.0, f4, f5, 0));
            }
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    @Override
    public void drawEllipse(float f, float f2, float f3, float f4, float f5, float f6, KLineType kLineType) {
        double d2 = this.realToDevXd(f);
        double d3 = this.realToDevYd(f2);
        double d4 = f3 * this.mDotPerLen;
        double d5 = f4 * this.mDotPerLen;
        if (d2 + d5 < 0.0 || d2 - d5 > (double)this.mDimension.width) {
            return;
        }
        if (d3 + d4 < 0.0 || d3 - d4 > (double)this.mDimension.height) {
            return;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            if (f5 == f6) {
                graphics2D.draw(new Arc2D.Double(d2 - d5, d3 - d4, d5 * 2.0, d4 * 2.0, 0.0, 360.0, 0));
            } else {
                graphics2D.draw(new Arc2D.Double(d2 - d5, d3 - d4, d5 * 2.0, d4 * 2.0, f5, f6 - f5, 0));
            }
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    @Override
    public void drawFillEllipse(float f, float f2, float f3, float f4, float f5, float f6, KLineType kLineType) {
        double d2 = this.realToDevXd(f);
        double d3 = this.realToDevYd(f2);
        double d4 = f3 * this.mDotPerLen;
        double d5 = f4 * this.mDotPerLen;
        if (d2 + d5 < 0.0 || d2 - d5 > (double)this.mDimension.width) {
            return;
        }
        if (d3 + d4 < 0.0 || d3 - d4 > (double)this.mDimension.height) {
            return;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            if (f5 == f6) {
                graphics2D.fill(new Arc2D.Double(d2 - d5, d3 - d4, d5 * 2.0, d4 * 2.0, 0.0, 360.0, 0));
            } else {
                graphics2D.fill(new Arc2D.Double(d2 - d5, d3 - d4, d5 * 2.0, d4 * 2.0, f5, f6 - f5, 2));
            }
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    @Override
    public void drawRect(float f, float f2, float f3, float f4, KLineType kLineType) {
        double d2;
        double d3 = this.realToDevXd(f);
        double d4 = this.realToDevYd(f2);
        double d5 = this.realToDevXd(f3);
        double d6 = this.realToDevYd(f4);
        if (d3 > d5) {
            d2 = d3;
            d3 = d5;
            d5 = d2;
        }
        if (d4 < d6) {
            d2 = d4;
            d4 = d6;
            d6 = d2;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            graphics2D.draw(new Rectangle2D.Double(d3, d6, d5 - d3 + 1.0, d4 - d6 + 1.0));
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    @Override
    public void drawFillRect(float f, float f2, float f3, float f4, KLineType kLineType) {
        double d2;
        double d3 = this.realToDevXd(f);
        double d4 = this.realToDevYd(f2);
        double d5 = this.realToDevXd(f3);
        double d6 = this.realToDevYd(f4);
        if (d3 > d5) {
            d2 = d3;
            d3 = d5;
            d5 = d2;
        }
        if (d4 < d6) {
            d2 = d4;
            d4 = d6;
            d6 = d2;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            graphics2D.setStroke(new BasicStroke(3.0f * this.mDotPerLen));
            graphics2D.fill(new Rectangle2D.Double(d3, d6, d5 - d3 + 1.0, d4 - d6 + 1.0));
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    @Override
    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        double d2;
        double d3 = this.realToDevXd(f);
        double d4 = this.realToDevYd(f2);
        double d5 = this.realToDevXd(f3);
        double d6 = this.realToDevYd(f4);
        int n = (int)(f5 * this.mDotPerLen);
        if (d3 > d5) {
            d2 = d3;
            d3 = d5;
            d5 = d2;
        }
        if (d4 < d6) {
            d2 = d4;
            d4 = d6;
            d6 = d2;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            graphics2D.draw(new RoundRectangle2D.Double(d3, d6, d5 - d3 + 1.0, d4 - d6 + 1.0, n, n));
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    @Override
    public void drawFillRoundRect(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        double d2;
        double d3 = this.realToDevXd(f);
        double d4 = this.realToDevYd(f2);
        double d5 = this.realToDevXd(f3);
        double d6 = this.realToDevYd(f4);
        int n = (int)(f5 * this.mDotPerLen);
        if (d3 > d5) {
            d2 = d3;
            d3 = d5;
            d5 = d2;
        }
        if (d4 < d6) {
            d2 = d4;
            d4 = d6;
            d6 = d2;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            graphics2D.fill(new RoundRectangle2D.Double(d3, d6, d5 - d3 + 1.0, d4 - d6 + 1.0, n, n));
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    public void drawImage(Image image, float f, float f2) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            int n = this.realToDevX(f);
            int n2 = this.realToDevY(f2);
            graphics2D.drawImage(image, n, n2, null);
        }
    }

    @Override
    public void drawImage(Image image, String string, float f, float f2, float f3, float f4) {
        this.drawImage(image, f, f2, f3, f4);
    }

    @Override
    public void drawImage(Image image, String string, String string2, float f, float f2, float f3, float f4) {
        this.drawImage(image, f, f2, f3, f4);
    }

    @Override
    public void drawImage(Image image, float f, float f2, float f3, float f4) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            int n;
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            int n2 = this.realToDevX(f);
            int n3 = this.realToDevY(f2);
            int n4 = this.realToDevX(f3);
            int n5 = this.realToDevY(f4);
            if (n2 > n4) {
                n = n2;
                n2 = n4;
                n4 = n;
            }
            if (n3 < n5) {
                n = n3;
                n3 = n5;
                n5 = n;
            }
            graphics2D.drawImage(image, n2, n5, n4 - n2, n3 - n5, null);
        }
    }

    @Override
    public void drawText(String string, float f, float f2, String string2, int n, float f3, float f4) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            int n2 = this.realToDevX(f);
            int n3 = this.realToDevY(f2);
            while (f4 < 0.0f) {
                f4 += 360.0f;
            }
            if (this.mDimension == null || this.mDimension.width == 0 && this.mDimension.height == 0) {
                return;
            }
            if ((float)n3 - this.mDotPerLen * f3 > (float)this.mDimension.height || n3 < 0) {
                return;
            }
            if (n2 > this.mDimension.width) {
                return;
            }
            float f5 = (float)Math.floor(this.mDotPerLen * f3);
            KFont kFont = KFont.getFont(string2, n, f5);
            if ((float)n2 + kFont.stringWidthf(string) < 0.0f) {
                return;
            }
            graphics2D.setFont(kFont.getFontObject());
            if (f4 == 0.0f) {
                if (string.length() > 1) {
                    KFont kFont2 = KFont.getFont(string2, n, f3);
                    float f6 = kFont2.stringWidthf(string);
                    KFont kFont3 = kFont;
                    int n4 = 0;
                    for (int i = 0; i < string.length(); ++i) {
                        String string3 = string.substring(i, i + 1);
                        n4 = (int)((float)n4 + kFont3.stringWidthf(string3));
                    }
                    float f7 = f6 / (float)n4;
                    float f8 = f;
                    for (int i = 0; i < string.length(); ++i) {
                        String string4 = string.substring(i, i + 1);
                        int n5 = this.realToDevX(f8);
                        if (string4.length() > 0) {
                            graphics2D.drawString(string4, n5, n3);
                        }
                        f8 += kFont3.stringWidthf(string4) * f7;
                    }
                } else if (string.length() > 0) {
                    graphics2D.drawString(string, n2, n3);
                }
            } else {
                this.mWorkTransform.setToIdentity();
                this.mWorkTransform.rotate((double)(-f4) * Math.PI / 180.0, n2, n3);
                graphics2D.setTransform(this.mWorkTransform);
                graphics2D.drawString(string, n2, n3);
                this.mWorkTransform.setToIdentity();
                graphics2D.setTransform(this.mWorkTransform);
            }
        }
    }

    public void drawShadePolygon(Vector<KCollection<float[]>> vector, float f, float f2, float f3, float f4, Color color, Color color2) {
        this.pathInit(0);
        for (int i = 0; i < vector.size(); ++i) {
            float[] fArray;
            KCollection<float[]> kCollection = vector.elementAt(i);
            for (int j = 0; j < kCollection.size(); ++j) {
                fArray = kCollection.elementAt(j);
                if (j == 0) {
                    this.pathMoveTo(fArray[0], fArray[1], null);
                    continue;
                }
                this.pathLineTo(fArray[0], fArray[1], null);
            }
            fArray = kCollection.elementAt(0);
            this.pathLineTo(fArray[0], fArray[1], null);
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            f = (float)this.realToDevXd(f);
            f3 = (float)this.realToDevXd(f3);
            graphics2D.setPaint(new GradientPaint(f, f2, color, f3, f2, color2));
            this.fillPath(null);
            this.pathClear();
            graphics2D.setPaint(null);
        }
    }

    public void drawTextCenter(float f, float f2, KFont kFont, String string, Color color) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            int n = this.realToDevX(f);
            int n2 = this.realToDevY(f2);
            graphics2D.setFont(kFont.getFontObject());
            this.setColor(color);
            int n3 = kFont.stringWidth(string) / 2;
            int n4 = kFont.getHeight() / 2;
            if (string.length() > 0) {
                graphics2D.drawString(string, n - n3, n2 + n4);
            }
        }
    }

    public void drawMark(float f, float f2, int n, int n2) {
        int n3 = this.realToDevX(f);
        int n4 = this.realToDevY(f2);
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            switch (n2) {
                case 0: {
                    graphics2D.drawArc(n3 - n, n4 - n, n * 2, n * 2, 0, 360);
                    break;
                }
                case 1: {
                    graphics2D.fillArc(n3 - n, n4 - n, n * 2, n * 2, 0, 360);
                    break;
                }
                case 2: {
                    graphics2D.drawRect(n3 - n, n4 - n, n * 2, n * 2);
                    break;
                }
                case 3: {
                    graphics2D.fillRect(n3 - n, n4 - n, n * 2, n * 2);
                    break;
                }
                case 4: {
                    graphics2D.drawLine(n3 - n, n4, n3 + n, n4);
                    graphics2D.drawLine(n3, n4 - n, n3, n4 + n);
                }
            }
        }
    }

    private void setStroke(Graphics2D graphics2D, KLineType kLineType) {
        if (kLineType != null) {
            float f = kLineType.mWidth;
            if (kLineType.mWidthType == 0) {
                f *= this.mDotPerLen;
            }
            if (kLineType.mStroke != null) {
                float[] fArray = kLineType.mStroke;
                if (kLineType.mWidthType == 0) {
                    float[] fArray2 = new float[fArray.length];
                    for (int i = 0; i < fArray.length; ++i) {
                        fArray2[i] = fArray[i] * this.mDotPerLen;
                    }
                    fArray = fArray2;
                }
                graphics2D.setStroke(new BasicStroke(f, 0, 0, 1.0f, fArray, 0.0f));
            } else if (this.mNullStrokeMode) {
                graphics2D.setStroke(new BasicStroke(f, 0, 0));
            } else {
                graphics2D.setStroke(new BasicStroke(f));
            }
        } else {
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    @Override
    public void pathInit(int n) {
        this.pathClear();
        this._path.setWindingRule(n);
    }

    @Override
    public void pathClear() {
        this._path.reset();
    }

    @Override
    public void pathMoveTo(double d2, double d3, KLocalAxis kLocalAxis) {
        Point2D point2D = this._path.getCurrentPoint();
        float f = this.getx(d2, d3, kLocalAxis);
        float f2 = this.gety(d2, d3, kLocalAxis);
        if (point2D != null && RichGraphicsUtil.isSame2D(f, f2, point2D.getX(), point2D.getY())) {
            return;
        }
        this._path.moveTo(f, f2);
    }

    @Override
    public void pathLineTo(double d2, double d3, KLocalAxis kLocalAxis) {
        this._path.lineTo(this.getx(d2, d3, kLocalAxis), this.gety(d2, d3, kLocalAxis));
    }

    @Override
    public void pathQuadTo(float f, float f2, float f3, float f4, KLocalAxis kLocalAxis) {
        this._path.quadTo(this.getx(f, f2, kLocalAxis), this.gety(f, f2, kLocalAxis), this.getx(f3, f4, kLocalAxis), this.gety(f3, f4, kLocalAxis));
    }

    @Override
    public void pathCurveTo(float f, float f2, float f3, float f4, float f5, float f6, KLocalAxis kLocalAxis) {
        this._path.curveTo(this.getx(f, f2, kLocalAxis), this.gety(f, f2, kLocalAxis), this.getx(f3, f4, kLocalAxis), this.gety(f3, f4, kLocalAxis), this.getx(f5, f6, kLocalAxis), this.gety(f5, f6, kLocalAxis));
    }

    @Override
    public void pathClose() {
        this._path.closePath();
    }

    @Override
    public void fillPath(KLineType kLineType) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            graphics2D.fill(this._path);
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    @Override
    public void drawPath(KLineType kLineType) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            graphics2D.draw(this._path);
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }

    @Override
    public void shadePath(KLineType kLineType, float f, float f2, float f3, float f4, Color color, Color color2, boolean bl) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)this.mGC;
            this.updateDrawQuality(graphics2D);
            this.setStroke(graphics2D, kLineType);
            f = (float)this.realToDevXd(f);
            f3 = (float)this.realToDevXd(f3);
            f2 = (float)this.realToDevYd(f2);
            f4 = (float)this.realToDevYd(f4);
            if (!bl) {
                graphics2D.setPaint(new GradientPaint(f, f2, color, f3, f4, color2));
            } else {
                f3 = f + (f3 - f) / 2.0f;
                f4 = f2 + (f4 - f2) / 2.0f;
                graphics2D.setPaint(new GradientPaint(f, f2, color, f3, f4, color2, bl));
            }
            graphics2D.fill(this._path);
            graphics2D.setStroke(LINETYPE_DEF);
        }
    }
}

