/*
 * Decompiled with CFR 0.152.
 */
package com.kt.util.xml;

import com.kt.io.AbstFile;
import com.kt.io.Base64Decoder;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class XMLReader {
    private static final String[][] COMMENT = new String[][]{{"<?", "?>"}, {"<!--", "-->"}};
    protected AbstFile mInput;
    protected boolean mCanRead;
    protected boolean mEOF;
    private String mRemain = "";

    public XMLReader(String string) {
        try {
            this.mCanRead = this.setFile(new FileInputStream(string), string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public XMLReader(InputStream inputStream) {
        this.mCanRead = this.setFile(inputStream, "");
    }

    public XMLReader(AbstFile abstFile) {
        if (abstFile != null) {
            this.mInput = abstFile;
            this.mCanRead = true;
        }
    }

    protected boolean setFile(InputStream inputStream, String string) {
        if (inputStream == null) {
            return false;
        }
        this.mInput = new AbstFile();
        this.mInput.inputStreamToBuffer(inputStream, string);
        return true;
    }

    public ObjectFolder read(String string) {
        if (string == null) {
            return this.read();
        }
        if (!this.open(string)) {
            return null;
        }
        ObjectFolder objectFolder = this.parseXML(string);
        this.close();
        if (objectFolder == null || objectFolder.getChildlen().size() < 1) {
            return null;
        }
        return objectFolder;
    }

    public ObjectFolder read() {
        if (!this.open()) {
            return null;
        }
        ObjectFolder objectFolder = this.parseXML();
        this.close();
        if (objectFolder == null || objectFolder.getChildlen().size() < 1) {
            return null;
        }
        return objectFolder;
    }

    protected boolean open(String string) {
        if (string == null) {
            return this.open();
        }
        if (this.mCanRead) {
            this.mInput.openReadFileFromBuffer(string);
            this.mEOF = false;
            return true;
        }
        return false;
    }

    protected boolean open() {
        if (this.mCanRead) {
            this.mInput.openReadFileFromBuffer();
            this.mEOF = false;
            return true;
        }
        return false;
    }

    protected boolean close() {
        this.mInput.closeReadFileFromBuffer();
        return true;
    }

    protected ObjectFolder parseXML() {
        return this.parseXML(null);
    }

    protected ObjectFolder parseXML(String string) {
        String string2;
        ObjectFolder objectFolder;
        ObjectFolder objectFolder2 = objectFolder = new ObjectFolder("");
        while ((string2 = this.readXML()) != null) {
            for (int i = 0; i < string2.length() - 1; ++i) {
                int n = this.indexOfDelimiter(string2, i);
                objectFolder = this.parseElement(string2.substring(i, n).trim(), objectFolder, string);
                i = n - 1;
            }
        }
        return objectFolder2;
    }

    protected int indexOfDelimiter(String string, int n) {
        int n2;
        boolean bl = false;
        int n3 = 0;
        for (n2 = n + 1; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (n3 == 0 && c == '=') {
                bl = true;
                continue;
            }
            if (bl && c == '\"') {
                n3 = (short)(n3 + 1);
                continue;
            }
            if (c == ' ' && n3 != 1) break;
        }
        return n2;
    }

    protected ObjectFolder parseElement(String string, ObjectFolder objectFolder, String string2) {
        String string3 = null;
        String string4 = null;
        if (string != null && string.length() > 0) {
            int n = string.indexOf(61);
            if (n >= 0) {
                string3 = string.substring(0, n);
                string4 = string.substring(n + 1, string.length());
                int n2 = string4.indexOf(34);
                int n3 = string4.lastIndexOf(34);
                if (n2 >= 0 && n3 >= 0 && n3 > n2) {
                    string4 = string4.substring(n2 + 1, n3);
                }
                if (string4 != null) {
                    string4 = this.getValue(string4, string2);
                }
            } else {
                string3 = string;
            }
        }
        if (string3 != null && string3.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "<> ");
            string3 = (String)stringTokenizer.nextElement();
            if (string4 == null) {
                if (string3.charAt(0) == '/' || string3.equalsIgnoreCase("/")) {
                    objectFolder = objectFolder.getParent();
                } else {
                    ObjectFolder objectFolder2 = new ObjectFolder(string3);
                    objectFolder.addChild(objectFolder2, true);
                    objectFolder = objectFolder2;
                }
            } else {
                try {
                    objectFolder.addChild(new ObjectNode(string3, string4), true);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        }
        return objectFolder;
    }

    protected String getValue(String string, String string2) {
        int n = string.indexOf("__BEGIN_BASE64ENCODED__");
        int n2 = string.indexOf("__END_BASE64ENCODED__");
        if (n == 0 && n2 > 0) {
            String string3 = string.substring("__BEGIN_BASE64ENCODED__".length(), n2);
            byte[] byArray = Base64Decoder.decode(string3);
            if (string2 == null) {
                string = new String(byArray);
            } else {
                try {
                    string = new String(byArray, string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    protected String readXML() {
        if (this.mEOF) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(this.mRemain);
        this.mRemain = "";
        String string = this.readLineWithoutComment();
        if (string == null) {
            return null;
        }
        while (string != null) {
            int n = string.lastIndexOf("/>");
            int n2 = string.length();
            if (n < 0) {
                n = string.lastIndexOf(">");
                if (n < 0) {
                    stringBuffer.append(string + "\n");
                    string = this.readLineWithoutComment();
                    continue;
                }
                stringBuffer.append(string.substring(0, n).trim());
                stringBuffer.append(">");
                if (n + 1 == n2) break;
                this.mRemain = string.substring(n + 1, n2);
                break;
            }
            if (n + 2 != n2) {
                this.mRemain = string.substring(n + 2, n2);
            }
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append(" />");
            break;
        }
        if (string == null) {
            this.mEOF = true;
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    protected String readLineWithoutComment() {
        String string = this.readLine();
        while (string != null) {
            if (string.length() == 0) {
                string = "";
            }
            boolean bl = false;
            for (int i = 0; i < COMMENT.length; ++i) {
                if (!string.contains(COMMENT[i][0])) continue;
                string = this.trimComment(string, COMMENT[i][0], COMMENT[i][1]);
                bl = true;
            }
            if (bl) continue;
            break;
        }
        return string;
    }

    protected String trimComment(String string, String string2, String string3) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(string2);
        if (n2 < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(string.substring(0, n2).trim());
        int n3 = string3.length();
        while ((n = string.indexOf(string3)) < 0) {
            string = this.readLine();
            if (string != null) continue;
            return null;
        }
        int n4 = string.length();
        if (n + n3 != n4) {
            string = string.substring(n + n3, n4).trim();
            stringBuffer.append(string);
        } else if (n2 == 0) {
            string = this.readLine();
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    protected String readLine() {
        String string = this.mInput.readLineFromBuffer();
        if (string != null) {
            return string.trim();
        }
        return null;
    }
}

