/*
 * Decompiled with CFR 0.152.
 */
package com.kt.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;

public class UtilString {
    private static final char[] ZENKAKU_TABLE = new char[]{'\uff10', '\uff11', '\uff12', '\uff13', '\uff14', '\uff15', '\uff16', '\uff17', '\uff18', '\uff19'};

    public static String tab2space(String string) {
        if (string == null) {
            return string;
        }
        while (string.indexOf(9) >= 0) {
            int n;
            int n2;
            int n3 = string.indexOf(9);
            int n4 = string.length();
            String string2 = string.substring(0, n3);
            String string3 = n3 + 1 >= n4 ? "" : string.substring(n3 + 1);
            int n5 = 0;
            n5 = string2.length();
            for (n2 = 0; n2 < string2.length(); ++n2) {
                n = string2.charAt(n2);
                if (UtilString.isHankaku((char)n)) continue;
                ++n5;
            }
            n2 = 8 - n5 % 8;
            string = string2;
            for (n = 0; n < n2; ++n) {
                string = string + " ";
            }
            string = string + string3;
        }
        return string;
    }

    public static String getMd5(String string) {
        String string2 = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = string.getBytes();
            messageDigest.update(byArray, 0, byArray.length);
            byte[] byArray2 = messageDigest.digest();
            for (int i = 0; i < byArray2.length; ++i) {
                int n;
                int n2 = n = byArray2[i] >= 0 ? byArray2[i] : 256 + byArray2[i];
                if (n < 16) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toHexString(n));
            }
            string2 = stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static String getZenkakuNumberExPeriod(String string) {
        char[] cArray = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            cArray[i] = c >= '0' && c <= '9' ? ZENKAKU_TABLE[c - 48] : c;
        }
        return new String(cArray);
    }

    public static boolean isHankaku(char c) {
        boolean bl = false;
        if (UtilString.isHankakuKana(c)) {
            bl = true;
        } else if (c < '\u007f') {
            bl = true;
        }
        return bl;
    }

    public static boolean isHankakuKana(char c) {
        return c > '\uff60' && c <= '\uff9f';
    }

    public static boolean isZenkakuKana(char c) {
        return c > '\u30a0' && c <= '\u30f4';
    }

    public static boolean isFullHiraKana(char c) {
        return c > '\u3040' && c <= '\u3094';
    }

    public static boolean isHankakuSuuji(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isZenkakuSuuji(char c) {
        return c >= '\uff10' && c <= '\uff19';
    }

    public static boolean isEnableEncChar(char c, String string) {
        return UtilString.isEnableEncChar(Character.toString(c), string);
    }

    public static boolean isEnableEncChar(String string, String string2) {
        try {
            String string3 = new String(string.getBytes(string2), string2);
            return string.equalsIgnoreCase(string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return false;
        }
    }

    public static boolean isDiff(String string, String string2) {
        return UtilString.isDiff(string, string2, false);
    }

    public static boolean isDiff(String string, String string2, boolean bl) {
        if (string == null != (string2 == null)) {
            return true;
        }
        if (string == null) {
            return false;
        }
        if (bl) {
            return !string.equals(string2);
        }
        return !string.equalsIgnoreCase(string2);
    }

    public static boolean isDiff(String[] stringArray, String[] stringArray2) {
        return UtilString.isDiff(stringArray, stringArray2, false);
    }

    public static boolean isDiff(String[] stringArray, String[] stringArray2, boolean bl) {
        if (stringArray == null != (stringArray2 == null)) {
            return true;
        }
        if (stringArray == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!UtilString.isDiff(stringArray[i], stringArray2[i], bl)) continue;
            return true;
        }
        return false;
    }

    public static int bin2dec(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(string.length() - i - 1);
            if (c != '1') continue;
            n |= 1 << i;
        }
        return n;
    }
}

