/*
 * Decompiled with CFR 0.152.
 */
package com.kt.util;

import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CharChecker {
    public static final int[][] ASCII_CONTROL = new int[][]{{0, 31}, {127, 127}};
    public static final int[][] ASCII_NUMBER = new int[][]{{48, 57}};
    public static final int[][] ASCII_DECIMAL = new int[][]{{48, 57}, {46, 46}};
    public static final int[][] ASCII_CAPITAL_ALPHABET = new int[][]{{65, 90}};
    public static final int[][] ASCII_SMALL_ALPHABET = new int[][]{{97, 122}};
    public static final int[][] ASCII_SIGN = new int[][]{{32, 47}, {58, 64}, {91, 96}, {123, 126}};
    public static final int[][][] ASCII_ALPHABET = new int[][][]{ASCII_CAPITAL_ALPHABET, ASCII_SMALL_ALPHABET};
    public static final int[][][] ASCII = new int[][][]{ASCII_NUMBER, ASCII_CAPITAL_ALPHABET, ASCII_SMALL_ALPHABET, ASCII_SIGN};
    public static final int[][] SJIS_HAN_KATAKANA = new int[][]{{161, 223}};
    public static final int[][][] SJIS_1BYTE = new int[][][]{ASCII_CONTROL, ASCII_NUMBER, ASCII_CAPITAL_ALPHABET, ASCII_SMALL_ALPHABET, ASCII_SIGN, SJIS_HAN_KATAKANA};
    public static final int[][] SJIS_ZEN_UPPER = new int[][]{{129, 159}, {224, 239}};
    public static final int[][] SJIS_ZEN_LOWER = new int[][]{{64, 126}, {128, 252}};
    public static final int[][] SJIS_ZEN_NUMBER = new int[][]{{33359, 33368}};
    public static final int[][] SJIS_ZEN_DECIMAL = new int[][]{{33359, 33368}, {33092, 33092}};
    public static final int[][] SJIS_ZEN_CAPITAL_ALPHABET = new int[][]{{33376, 33401}};
    public static final int[][] SJIS_ZEN_SMALL_ALPHABET = new int[][]{{33409, 33434}};
    public static final int[][] SJIS_ZEN_HIRAGANA = new int[][]{{33439, 33521}};
    public static final int[][] SJIS_ZEN_KATAKANA = new int[][]{{33600, 33686}};
    public static final int[][] SJIS_ZEN_BOU = new int[][]{{33115, 33115}};
    public static final int[][] SJIS_ZEN_SIGN = new int[][]{{33088, 33196}, {33208, 33215}, {33224, 33230}, {33242, 33256}, {33264, 33271}, {33276, 33276}, {33695, 33718}, {33727, 33750}, {33856, 33888}, {33904, 33937}, {33951, 33982}};
    public static final int[][] SJIS_ZEN_KANJI1 = new int[][]{{34975, 39026}};
    public static final int[][] SJIS_ZEN_KANJI2 = new int[][]{{39071, 40956}, {57408, 60068}};
    public static final int[][][] SJIS_ZEN_KANJI = new int[][][]{SJIS_ZEN_KANJI1, SJIS_ZEN_KANJI2};
    public static final int[][][] SJIS_2BYTE = new int[][][]{SJIS_ZEN_NUMBER, SJIS_ZEN_CAPITAL_ALPHABET, SJIS_ZEN_SMALL_ALPHABET, SJIS_ZEN_HIRAGANA, SJIS_ZEN_KATAKANA, SJIS_ZEN_SIGN, SJIS_ZEN_KANJI1, SJIS_ZEN_KANJI2};
    public static final int[][][] SJIS_ALL = new int[][][]{ASCII_CONTROL, ASCII_NUMBER, ASCII_CAPITAL_ALPHABET, ASCII_SMALL_ALPHABET, ASCII_SIGN, SJIS_HAN_KATAKANA, SJIS_ZEN_NUMBER, SJIS_ZEN_CAPITAL_ALPHABET, SJIS_ZEN_SMALL_ALPHABET, SJIS_ZEN_HIRAGANA, SJIS_ZEN_KATAKANA, SJIS_ZEN_SIGN, SJIS_ZEN_KANJI1, SJIS_ZEN_KANJI2};
    public static final int[][][] MAIL_ADDRESS_SET = new int[][][]{ASCII_NUMBER, ASCII_CAPITAL_ALPHABET, ASCII_SMALL_ALPHABET, new int[][]{{33, 33}, {35, 35}, {36, 36}, {37, 37}, {38, 38}, {39, 39}, {42, 42}, {43, 43}, {45, 45}, {47, 47}, {61, 61}, {63, 63}, {94, 94}, {95, 95}, {96, 96}, {123, 123}, {124, 124}, {125, 125}, {126, 126}}};
    public static final int[][] WIN_FILE_NAME_EXCLUDE = new int[][]{{39, 39}, {33, 33}, {34, 34}, {124, 124}, {42, 42}, {60, 60}, {62, 62}, {63, 63}, {92, 92}, {59, 59}, {58, 58}, {44, 44}, {47, 47}};
    private static final Log log = LogFactory.getLog(CharChecker.class);

    protected CharChecker() {
    }

    public static boolean hasCharacter(String string, int[][][] nArray) {
        boolean bl = true;
        if (string == null || string.compareTo("") == 0) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (CharChecker.hasCharacter(string.charAt(i), nArray)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean hasCharacter(char c, int[][][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int[][] nArray2 = nArray[i];
            if (!CharChecker.hasCharacter(c, nArray2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCharacter(String string, int[][] nArray) {
        for (int i = 0; i < string.length(); ++i) {
            if (CharChecker.hasCharacter(string.charAt(i), nArray)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasCharacter(char c, int[][] nArray) {
        int n;
        String string = Character.toString(c);
        byte[] byArray = null;
        try {
            byArray = string.getBytes("SJIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.info((Object)"", (Throwable)unsupportedEncodingException);
            return false;
        }
        int n2 = 0;
        int n3 = byArray[0] & 0xFF;
        if (CharChecker.isSJIS_1byte(n3)) {
            n2 = n3;
        } else {
            n = byArray[1] & 0xFF;
            if (!CharChecker.isSJIS_2byte(n3, n)) {
                return false;
            }
            n2 = n3 << 8 & 0xFF00 | n;
        }
        n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            if (nArray2[0] > n2 || n2 > nArray2[1]) continue;
            n = 1;
        }
        return n != 0;
    }

    public static boolean hasNotCharacter(String string, int[][][] nArray) {
        boolean bl = true;
        if (string == null || string.compareTo("") == 0) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (CharChecker.hasNotCharacter(string.charAt(i), nArray)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean hasNotCharacter(char c, int[][][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int[][] nArray2 = nArray[i];
            if (CharChecker.hasNotCharacter(c, nArray2)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasNotCharacter(String string, int[][] nArray) {
        for (int i = 0; i < string.length(); ++i) {
            if (!CharChecker.hasNotCharacter(string.charAt(i), nArray)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNotCharacter(char c, int[][] nArray) {
        int n;
        String string = Character.toString(c);
        byte[] byArray = null;
        try {
            byArray = string.getBytes("SJIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.info((Object)"", (Throwable)unsupportedEncodingException);
            return true;
        }
        int n2 = 0;
        int n3 = byArray[0] & 0xFF;
        if (CharChecker.isSJIS_1byte(n3)) {
            n2 = n3;
        } else {
            n = byArray[1] & 0xFF;
            if (!CharChecker.isSJIS_2byte(n3, n)) {
                return true;
            }
            n2 = n3 << 8 & 0xFF00 | n;
        }
        for (n = 0; n < nArray.length; ++n) {
            int[] nArray2 = nArray[n];
            if (nArray2[0] > n2 || n2 > nArray2[1]) continue;
            return false;
        }
        return true;
    }

    private static boolean isSJIS_1byte(int n) {
        for (int i = 0; i < SJIS_1BYTE.length; ++i) {
            int[][] nArray = SJIS_1BYTE[i];
            for (int j = 0; j < nArray.length; ++j) {
                int[] nArray2 = nArray[j];
                if (nArray2[0] > n || n > nArray2[1]) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSJIS_2byte(int n, int n2) {
        int[] nArray;
        int n3;
        boolean bl = false;
        for (n3 = 0; n3 < SJIS_ZEN_UPPER.length; ++n3) {
            nArray = SJIS_ZEN_UPPER[n3];
            if (nArray[0] > n || n > nArray[1]) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        for (n3 = 0; n3 < SJIS_ZEN_LOWER.length; ++n3) {
            nArray = SJIS_ZEN_LOWER[n3];
            if (nArray[0] > n2 || n2 > nArray[1]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isHanKata(String string) {
        return CharChecker.hasCharacter(string, SJIS_HAN_KATAKANA);
    }

    public static boolean isHanKata(char c) {
        return CharChecker.hasCharacter(c, SJIS_HAN_KATAKANA);
    }

    public static boolean isZenKata(String string) {
        return CharChecker.hasCharacter(string, (int[][][])new int[][][]{SJIS_ZEN_KATAKANA, SJIS_ZEN_BOU});
    }

    public static boolean isZenKata(char c) {
        return CharChecker.hasCharacter(c, (int[][][])new int[][][]{SJIS_ZEN_KATAKANA, SJIS_ZEN_BOU});
    }

    public static boolean isHanNum(String string) {
        return CharChecker.hasCharacter(string, ASCII_NUMBER);
    }

    public static boolean isHanNum(char c) {
        return CharChecker.hasCharacter(c, ASCII_NUMBER);
    }

    public static boolean isZenNum(String string) {
        return CharChecker.hasCharacter(string, SJIS_ZEN_NUMBER);
    }

    public static boolean isZenNum(char c) {
        return CharChecker.hasCharacter(c, SJIS_ZEN_NUMBER);
    }

    public static boolean isHankaku(String string) {
        return CharChecker.hasCharacter(string, SJIS_1BYTE);
    }

    public static boolean isHankaku(char c) {
        return CharChecker.hasCharacter(c, SJIS_1BYTE);
    }

    public static boolean isZenkaku(String string) {
        return !CharChecker.isHankaku(string);
    }

    public static boolean isZenkaku(char c) {
        return !CharChecker.isHankaku(c);
    }

    public static boolean isAscii(String string) {
        return CharChecker.hasCharacter(string, ASCII);
    }

    public static boolean isAscii(char c) {
        return CharChecker.hasCharacter(c, ASCII);
    }

    public static boolean isNotHanKata(String string) {
        return CharChecker.hasNotCharacter(string, SJIS_HAN_KATAKANA);
    }

    public static boolean isNotHanKata(char c) {
        return CharChecker.hasNotCharacter(c, SJIS_HAN_KATAKANA);
    }

    public static boolean isNotZenKata(String string) {
        return CharChecker.hasNotCharacter(string, SJIS_ZEN_KATAKANA);
    }

    public static boolean isNotZenKata(char c) {
        return CharChecker.hasNotCharacter(c, SJIS_ZEN_KATAKANA);
    }

    public static boolean isNotHanNum(String string) {
        return CharChecker.hasNotCharacter(string, ASCII_NUMBER);
    }

    public static boolean isNotHanNum(char c) {
        return CharChecker.hasNotCharacter(c, ASCII_NUMBER);
    }

    public static boolean isNotZenNum(String string) {
        return CharChecker.hasNotCharacter(string, SJIS_ZEN_NUMBER);
    }

    public static boolean isNotZenNum(char c) {
        return CharChecker.hasNotCharacter(c, SJIS_ZEN_NUMBER);
    }

    public static boolean isNotHankaku(String string) {
        return CharChecker.hasNotCharacter(string, SJIS_1BYTE);
    }

    public static boolean isNotHankaku(char c) {
        return CharChecker.hasNotCharacter(c, SJIS_1BYTE);
    }

    public static boolean isHanDec(String string) {
        return CharChecker.isHanDec(string, -1, -1);
    }

    public static boolean isHanDec(String string, int n, int n2) {
        if (!CharChecker.hasCharacter(string, ASCII_DECIMAL)) {
            return false;
        }
        int n3 = 0;
        int n4 = 0;
        while ((n3 = string.indexOf(".", n3)) != -1) {
            ++n3;
            ++n4;
        }
        if (n4 >= 2) {
            return false;
        }
        if (n4 == 1 && string.indexOf(".") + 1 == string.length()) {
            return false;
        }
        if (n4 == 0) {
            if (n != -1 && string.length() > n) {
                return false;
            }
        } else {
            n3 = string.indexOf(".");
            if (n != -1 && string.substring(0, n3).length() > n) {
                return false;
            }
            if (n2 != -1 && string.substring(n3 + 1).length() > n2) {
                return false;
            }
        }
        return true;
    }

    public static boolean isZenDec(String string) {
        return CharChecker.hasCharacter(string, SJIS_ZEN_DECIMAL);
    }

    public static boolean isNotPlatformDependent(String string) {
        return !CharChecker.isUnsupportedCharacter(string) && !CharChecker.hasNotCharacter(string, SJIS_ALL);
    }

    public static boolean isNotPlatformDependent(char c) {
        return !CharChecker.isUnsupportedCharacter(c) && !CharChecker.hasNotCharacter(c, SJIS_ALL);
    }

    public static boolean isUnsupportedCharacter(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!CharChecker.isUnsupportedCharacter(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnsupportedCharacter(char c) {
        String string = Character.toString(c);
        byte[] byArray = null;
        try {
            byArray = string.getBytes("SJIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.info((Object)"", (Throwable)unsupportedEncodingException);
            return true;
        }
        int n = 0;
        int n2 = byArray[0] & 0xFF;
        if (CharChecker.isSJIS_1byte(n2)) {
            n = n2;
        } else {
            int n3 = byArray[1] & 0xFF;
            if (!CharChecker.isSJIS_2byte(n2, n3)) {
                return true;
            }
            n = n2 << 8 & 0xFF00 | n3;
        }
        return c != '?' && n == 63;
    }

    public static boolean isWinFileName(String string) {
        return CharChecker.hasNotCharacter(string, WIN_FILE_NAME_EXCLUDE);
    }
}

