/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import option.gui.RoundLinePanel;

public class TitledRoundLinePanel
extends RoundLinePanel {
    protected FontMetrics mFm;
    protected Color mFontColor;
    protected String mTitle;
    protected Font mFont;
    protected int mTitleX;
    protected int mTitleY;
    protected Insets mOffsets;

    public TitledRoundLinePanel(String string) {
        this(string, 12);
    }

    public TitledRoundLinePanel(String string, int n) {
        this.mTitle = string;
        this.setFont(new Font("\uff2d\uff33\u3000\uff30\u30b4\u30b7\u30c3\u30af", 0, n));
        this.setTitlePosition(1, 0);
        this.setInsets(21, 12, 6, 12);
        this.setOffsets(15, 0, 0, 0);
        this.setFontColor(Color.black);
        this.setLineColor(Color.black);
    }

    public void setOffsets(int n, int n2, int n3, int n4) {
        this.mOffsets = new Insets(n, n2, n3, n4);
    }

    public void setFontColor(Color color) {
        this.mFontColor = color;
    }

    public void setTitlePosition(int n, int n2) {
        this.mTitleX = n;
        this.mTitleY = n2;
    }

    public void setFont(Font font) {
        this.mFont = font;
        this.mFm = null;
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        Color color = graphics2D.getColor();
        Font font = graphics2D.getFont();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.getBackground());
        if (this.isOpaque()) {
            int n = dimension.width - this.mOffsets.left - this.mOffsets.right;
            int n2 = dimension.height - this.mOffsets.top - this.mOffsets.bottom;
            if (this.mFillPanel) {
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRoundRect(this.mLineWidth - 1 + this.mOffsets.left, this.mOffsets.top + this.mLineWidth - 1, n - this.mLineWidth * 2 + 2, n2 - this.mLineWidth * 2 + 2, this.mRadius - this.mLineWidth, this.mRadius - this.mLineWidth);
            }
            if (this.mDrawLine) {
                graphics2D.setColor(this.mLineColor);
                graphics2D.setStroke(new BasicStroke(this.mLineWidth));
                graphics2D.drawRoundRect(this.mLineWidth / 2 + this.mOffsets.left, this.mOffsets.top + this.mLineWidth / 2, n - this.mLineWidth, n2 - this.mLineWidth, this.mRadius, this.mRadius);
            }
        }
        if (this.mFm == null) {
            this.mFm = graphics.getFontMetrics(this.mFont);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setFont(this.mFont);
        graphics2D.setColor(this.mFontColor);
        graphics2D.drawString(this.mTitle, this.mTitleX, this.mTitleY + this.mFm.getHeight() - 3);
        graphics2D.setTransform(affineTransform);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setClip(shape);
        graphics2D.setStroke(stroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

