/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.border.Border;

public class RibbonBorder
implements Border {
    private Insets mInsets;
    private Insets cg;
    private FontMetrics mFm;
    private Color mFillcolor;
    private Color mFontColor;
    private Color bP;
    private Color bQ;
    private Color ch;
    private String mTitle;
    private Font mFont;
    private int bS;

    public RibbonBorder(String string) {
        this(string, 14);
    }

    public RibbonBorder(String string, int n) {
        this.mTitle = string;
        Font font = new Font("\uff2d\uff33\u3000\uff30\u30b4\u30b7\u30c3\u30af", 1, n);
        this.setFont(font);
        this.bS = 29;
        this.setInsets(0, 0, 0, 0);
        this.setTitleInsets(8, 8, 0, 8);
        this.setFontColor(new Color(43, 42, 37));
        this.setTitleColor(new Color(99, 99, 99), new Color(239, 119, 0), new Color(199, 197, 192));
        this.setFillColor(Color.LIGHT_GRAY);
    }

    public void setFont(Font font) {
        this.mFont = font;
        this.mFm = null;
    }

    public void setFontColor(Color color) {
        this.mFontColor = color;
    }

    public void setFillColor(Color color) {
        this.mFillcolor = color;
    }

    public Color getFillColor() {
        return this.mFillcolor;
    }

    public void setTitleColor(Color color, Color color2, Color color3) {
        this.bP = color;
        this.bQ = color2;
        this.ch = color3;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.mInsets = new Insets(n, n2, n3, n4);
    }

    public void setTitleInsets(int n, int n2, int n3, int n4) {
        this.cg = new Insets(n, n2, n3, n4);
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(this.mInsets.top + this.bS + this.cg.top + this.cg.bottom, this.mInsets.left + this.cg.left, this.mInsets.bottom, this.mInsets.right + this.cg.right);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Dimension dimension = new Dimension(n3, n4);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        Color color = graphics2D.getColor();
        Font font = graphics2D.getFont();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Stroke stroke = graphics2D.getStroke();
        if (this.mFm == null) {
            this.mFm = graphics.getFontMetrics(this.mFont);
        }
        int n5 = 12;
        int n6 = 2;
        int n7 = dimension.width - this.cg.left - this.cg.right - n5 - n6;
        int n8 = this.cg.left;
        int n9 = n8 + n5;
        int n10 = n9 + n6;
        int n11 = this.cg.top;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n8, n11);
        generalPath.lineTo(n8, (float)n11 + (float)this.bS * 0.3f);
        generalPath.lineTo((float)n8 + (float)n5 * 0.5f, (float)n11 + (float)this.bS * 0.5f);
        generalPath.lineTo(n8, (float)n11 + (float)this.bS * 0.7f);
        generalPath.lineTo(n8, n11 + this.bS);
        generalPath.lineTo(n9, n11 + this.bS);
        generalPath.lineTo(n9, n11);
        generalPath.closePath();
        graphics2D.setColor(this.bP);
        graphics2D.fill(generalPath);
        graphics2D.setColor(this.bQ);
        graphics2D.fillRect(n9, n11, n6, this.bS);
        graphics2D.setColor(this.ch);
        graphics2D.fillRect(n10, n11, n7, this.bS);
        graphics2D.setFont(this.mFont);
        graphics2D.setColor(this.mFontColor);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawString(this.mTitle, (float)this.mFont.getSize() * 0.9f + (float)n10, (float)n11 + (float)this.bS * 0.5f + (float)this.mFont.getSize() * 0.3f);
        graphics2D.setTransform(affineTransform);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setClip(shape);
        graphics2D.setStroke(stroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

