/*
 * Decompiled with CFR 0.152.
 */
package gui.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;

public class LabelComponent
extends Component {
    public static final Insets DEF_INSETS = new Insets(0, 0, 0, 0);
    public static final Font DEF_FONT = new Font("Dialog", 0, 12);
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private static final Color D = new Color(192, 192, 192);
    private String E;
    private Font f;
    private Insets F;
    private int G;
    private Color H;
    private Color I;
    private int J;

    public LabelComponent() {
        this(null, 1);
    }

    public LabelComponent(String string) {
        this(string, 1);
    }

    public LabelComponent(String string, int n) {
        this.E = string;
        switch (n) {
            case 0: 
            case 2: {
                this.G = n;
            }
        }
        this.G = 1;
        this.f = DEF_FONT;
        this.F = DEF_INSETS;
        this.H = Color.black;
    }

    public LabelComponent(int n, int n2) {
        this(null, n2);
        this.J = n;
    }

    public String getText() {
        if (this.E == null) {
            return null;
        }
        return new String(this.E);
    }

    public Font getFont() {
        return new Font(this.f.getFontName(), this.f.getStyle(), this.f.getSize());
    }

    public Insets getInsets() {
        return new Insets(this.F.top, this.F.left, this.F.bottom, this.F.right);
    }

    public int getAlignment() {
        return this.G;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.f == null) {
            return dimension;
        }
        if (this.E == null && this.J <= 0) {
            return dimension;
        }
        int n = 0;
        int n2 = 0;
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return dimension;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.f);
        if (this.E != null) {
            n = fontMetrics.stringWidth(this.E);
            n2 = fontMetrics.getHeight();
        }
        if (this.J > 0) {
            int n3 = this.J * fontMetrics.stringWidth("\u3042");
            n2 = fontMetrics.getHeight();
            if (n3 > n) {
                n = n3;
            }
        }
        graphics.dispose();
        if (this.F != null) {
            n2 = n2 + this.F.top + this.F.bottom;
            n = n + this.F.left + this.F.right;
        }
        if (dimension.width < n) {
            dimension.width = n;
        }
        if (dimension.height < n2) {
            dimension.height = n2;
        }
        return dimension;
    }

    public void setText(String string) {
        if (this.E != null && this.E.compareTo(string) == 0) {
            return;
        }
        this.E = string;
        this.repaint();
    }

    public void setFont(Font font) {
        this.f = font;
        this.repaint();
    }

    public void setColor(Color color) {
        this.H = color;
        this.repaint();
    }

    public void setInsets(Insets insets) {
        this.F = insets;
        this.repaint();
    }

    public void setAlignment(int n) {
        switch (n) {
            case 0: 
            case 2: {
                this.G = n;
            }
        }
        this.G = 1;
        this.repaint();
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        if (bl) {
            if (this.I != null) {
                this.H = this.I;
            }
        } else {
            this.I = this.H;
            this.H = D;
        }
        super.setEnabled(bl);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        int n;
        if (this.E == null || this.f == null || this.H == null) {
            return;
        }
        Serializable serializable = graphics.getFontMetrics(this.f);
        switch (this.G) {
            case 0: {
                Dimension dimension = this.getPreferredSize();
                n = (dimension.width - serializable.stringWidth(this.E)) / 2;
                break;
            }
            case 2: {
                Dimension dimension = this.getPreferredSize();
                n = dimension.width - this.F.right;
                break;
            }
            default: {
                n = 0 + this.F.left;
            }
        }
        int n2 = serializable.getHeight();
        if (this.F != null) {
            n2 += this.F.top;
        }
        serializable = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setFont(this.f);
        graphics.setColor(this.H);
        graphics.drawString(this.E, n, n2);
        graphics.setFont((Font)serializable);
        graphics.setColor(color);
    }
}

