/*
 * Decompiled with CFR 0.152.
 */
package gui.basic;

import gui.basic.DissolveFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;

public class ImageIcon
extends Component {
    private Image r;
    private Image s;
    private boolean t = true;

    public ImageIcon(Image image) {
        this.setImage(image);
    }

    public static Image getImageChangedAlpha(Image image, int n, Component component) {
        if (image == null) {
            return null;
        }
        image = component.createImage(new FilteredImageSource(image.getSource(), new DissolveFilter(n)));
        ImageIcon.waitForImage(component, image);
        return image;
    }

    public static void waitForImage(Component serializable, Image image) {
        serializable = new MediaTracker((Component)serializable);
        try {
            ((MediaTracker)serializable).addImage(image, 0);
            ((MediaTracker)serializable).waitForID(0);
            return;
        }
        catch (InterruptedException interruptedException) {
            serializable = interruptedException;
            interruptedException.printStackTrace();
            return;
        }
    }

    public Image getImage() {
        return this.r;
    }

    public Dimension getPreferredSize() {
        if (this.r != null) {
            return new Dimension(this.r.getWidth(null), this.r.getHeight(null));
        }
        return super.getPreferredSize();
    }

    public synchronized boolean isEnabled() {
        return this.t;
    }

    public void setImage(Image image) {
        if (this.r == image || image == null) {
            return;
        }
        this.r = image;
        ImageIcon.waitForImage(this, this.r);
        this.repaint();
    }

    public synchronized void setEnabled(boolean bl) {
        if (this.t == bl) {
            return;
        }
        this.t = bl;
        if (this.r == null) {
            return;
        }
        if (!bl && this.s == null) {
            this.s = ImageIcon.getImageChangedAlpha(this.r, 128, this);
        }
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.paintIcon(graphics, 0, 0);
    }

    public void paintIcon(Graphics graphics, int n, int n2) {
        if (this.isEnabled()) {
            if (this.r != null) {
                graphics.drawImage(this.r, n, n2, this);
                return;
            }
        } else if (this.s != null) {
            graphics.drawImage(this.s, n, n2, this);
        }
    }

    public void paintIcon(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.isEnabled()) {
            if (this.r != null) {
                graphics.drawImage(this.r, n, n2, n3, n4, this);
                return;
            }
        } else if (this.s != null) {
            graphics.drawImage(this.s, n, n2, n3, n4, this);
        }
    }
}

