/*
 * Decompiled with CFR 0.152.
 */
package option.threed.ui.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import option.threed.IScreen3D;
import option.threed.ui.IPanel3D;

public class Panel3D
extends Panel
implements IPanel3D {
    private BufferedImage cf;
    private int[] rgb;
    private IScreen3D cg = null;
    private Dimension minimumSize = null;

    public Panel3D() {
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.addComponentListener(new ComponentListener(){

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                Panel3D.this.b();
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    public Panel3D(int n, int n2) {
        this();
        this.minimumSize = new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        return super.getPreferredSize();
    }

    public Component getComponent() {
        return this;
    }

    public void add3DUI(IScreen3D iScreen3D) {
        this.cg = iScreen3D;
        if (this.cg != null) {
            this.initImage();
            this.cg.updateBuffer(this.rgb, this.cf.getWidth(), this.cf.getHeight());
        }
    }

    public int getScreenHeight() {
        if (this.cf != null) {
            return this.cf.getHeight();
        }
        return 100;
    }

    public int getScreenWidth() {
        if (this.cf != null) {
            return this.cf.getWidth();
        }
        return 100;
    }

    public void remove3DUI(IScreen3D iScreen3D) {
        this.cg = null;
    }

    private void b() {
        if (!this.isShowing()) {
            return;
        }
        this.repaintTemporary();
    }

    public void paint(Graphics graphics) {
        if (this.cg == null) {
            return;
        }
        if (this.updateImage()) {
            this.cg.updateBuffer(this.rgb, this.cf.getWidth(), this.cf.getHeight());
        }
        graphics.drawImage(this.cf, 0, 0, null);
        if (!this.isEnabled()) {
            Dimension dimension = this.getSize();
            graphics.setColor(new Color(240, 240, 240, 220));
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public boolean updateImage() {
        Dimension dimension = this.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return false;
        }
        boolean bl = false;
        if (this.cf == null) {
            bl = true;
        } else {
            int n = this.cf.getWidth();
            int n2 = this.cf.getHeight();
            if (n != dimension.width || n2 != dimension.height) {
                bl = true;
            }
        }
        if (bl) {
            this.cf = new BufferedImage(dimension.width, dimension.height, 1);
            this.rgb = ((DataBufferInt)this.cf.getRaster().getDataBuffer()).getData();
        }
        return bl;
    }

    public void repaintTemporary() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (this.cf != null) {
            graphics.drawImage(this.cf, 0, 0, null);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.cg != null) {
            this.cg.mouseDragged(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.cg != null) {
            this.cg.mouseMoved(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.cg != null) {
            this.cg.mouseEntered(mouseEvent.getX(), mouseEvent.getY());
        }
        this.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.cg != null) {
            this.cg.mouseExited(mouseEvent.getX(), mouseEvent.getY());
        }
        this.transferFocus();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.cg != null) {
            this.cg.mouseReleased(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.cg != null) {
            this.cg.keyPressed(keyEvent.getKeyCode(), keyEvent.getModifiers());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.cg != null) {
            this.cg.keyReleased(keyEvent.getKeyCode());
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.cg != null) {
            int n = mouseWheelEvent.getWheelRotation();
            this.cg.mouseWheelMoved(n);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.requestFocus();
        } else {
            this.transferFocus();
        }
    }

    public void initImage() {
        if (this.rgb == null) {
            this.updateImage();
        }
    }
}

