/*
 * Decompiled with CFR 0.152.
 */
package model2d;

import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import geom.util.HatchUtil;
import java.util.Vector;
import kinoki3exchange.KxModuleUtil;
import kinoki3exchange.StringUtil;
import model.shape.primitive.SVector3d;
import model2d.AbstractGeom2D;
import model2d.Primitive2DType;
import proto.graphics2d.GeomNodeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPolygon2D
extends AbstractGeom2D {
    public SVector3d[] points;
    public boolean drawAllEdge = true;
    public boolean[] drawEdge = null;
    public SVector3d normal = new SVector3d();

    @Override
    public Vector<AbstractGeom2D> getHatchObjects() {
        if (this.hatchPattern2d == 0) {
            return null;
        }
        if (this.hatchObjects == null) {
            Vector<double[]> vector = new Vector<double[]>();
            int n = 0;
            while (n < this.points.length) {
                SVector3d sVector3d = this.points[n];
                vector.addElement(new double[]{sVector3d.x, sVector3d.y});
                ++n;
            }
            this.hatchObjects = HatchUtil.createHatchGeom2D(vector, this.hatchPattern2d);
        }
        return this.hatchObjects;
    }

    @Override
    public void load(ObjectFolder objectFolder) {
        ObjectFolder objectFolder2;
        Vector vector;
        KxModuleUtil.getInt(objectFolder, GeomNodeName.size);
        this.loadCommonInfo(objectFolder);
        this.drawAllEdge = KxModuleUtil.getBool(objectFolder, GeomNodeName.drawAllEdge, this.drawAllEdge);
        ObjectNode objectNode = KxModuleUtil.getNode(objectFolder, GeomNodeName.drawEdge);
        if (objectNode != null) {
            this.drawEdge = StringUtil.parseBoolArray(KxModuleUtil.getString(objectFolder, GeomNodeName.drawEdge), ",");
        }
        if ((objectNode = KxModuleUtil.getNode(objectFolder, GeomNodeName.points)) != null && objectNode instanceof ObjectFolder && (vector = (objectFolder2 = (ObjectFolder)objectNode).getNamedElement(GeomNodeName.point.name())) != null && vector.size() > 0) {
            this.points = new SVector3d[vector.size()];
            int n = 0;
            while (n < this.points.length) {
                SVector3d sVector3d = new SVector3d();
                ObjectFolder objectFolder3 = (ObjectFolder)vector.elementAt(n);
                sVector3d.parseVector(KxModuleUtil.getString(objectFolder3, GeomNodeName.value));
                this.points[n] = sVector3d;
                ++n;
            }
        }
    }

    @Override
    public void save(ObjectFolder objectFolder) {
        KxModuleUtil.addString(objectFolder, GeomNodeName.type, Primitive2DType.POLYGON.name());
        KxModuleUtil.addInt(objectFolder, GeomNodeName.size, this.points.length);
        this.saveCommonInfo(objectFolder);
        KxModuleUtil.addBool(objectFolder, GeomNodeName.drawAllEdge, this.drawAllEdge);
        if (this.drawEdge != null) {
            KxModuleUtil.addString(objectFolder, GeomNodeName.drawEdge, StringUtil.toString(this.drawEdge, ","));
        }
        ObjectFolder objectFolder2 = KxModuleUtil.createNode(GeomNodeName.points);
        objectFolder.addChild((ObjectNode)objectFolder2, true);
        SVector3d[] sVector3dArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            SVector3d sVector3d = sVector3dArray[n2];
            ObjectFolder objectFolder3 = KxModuleUtil.createNode(GeomNodeName.point);
            objectFolder2.addChild((ObjectNode)objectFolder3, true);
            KxModuleUtil.addString(objectFolder3, GeomNodeName.value, sVector3d.toString());
            ++n2;
        }
    }
}

