/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLFeatureNotSupportedException;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SQLServerResultSetMetaData
implements ResultSetMetaData {
    private SQLServerConnection con;
    private final SQLServerResultSet rs;
    public int nBeforeExecuteCols;
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerResultSetMetaData");
    private static int baseID = 0;
    private final String traceID = " SQLServerResultSetMetaData:" + SQLServerResultSetMetaData.nextInstanceID();

    private static synchronized int nextInstanceID() {
        return ++baseID;
    }

    public final String toString() {
        return this.traceID;
    }

    SQLServerResultSetMetaData(SQLServerConnection sQLServerConnection, SQLServerResultSet sQLServerResultSet) {
        this.con = sQLServerConnection;
        this.rs = sQLServerResultSet;
        assert (sQLServerResultSet != null);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (" + sQLServerResultSet.toString() + ")");
        }
    }

    private void checkClosed() throws SQLServerException {
        this.rs.checkClosed();
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public String getCatalogName(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTableName().getDatabaseName();
    }

    @Override
    public int getColumnCount() throws SQLServerException {
        this.checkClosed();
        if (this.rs == null) {
            return 0;
        }
        return this.rs.getColumnCount();
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTypeInfo().getDisplaySize();
    }

    @Override
    public String getColumnLabel(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getColumnName();
    }

    @Override
    public String getColumnName(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getColumnName();
    }

    @Override
    public int getColumnType(int n) throws SQLServerException {
        this.checkClosed();
        TypeInfo typeInfo = this.rs.getColumn(n).getTypeInfo();
        JDBCType jDBCType = typeInfo.getSSType().getJDBCType();
        int n2 = jDBCType.asJavaSqlType();
        if (this.con.isKatmaiOrLater()) {
            SSType sSType = typeInfo.getSSType();
            switch (sSType) {
                case VARCHARMAX: {
                    n2 = SSType.VARCHAR.getJDBCType().asJavaSqlType();
                    break;
                }
                case NVARCHARMAX: {
                    n2 = SSType.NVARCHAR.getJDBCType().asJavaSqlType();
                    break;
                }
                case VARBINARYMAX: {
                    n2 = SSType.VARBINARY.getJDBCType().asJavaSqlType();
                }
            }
        }
        return n2;
    }

    @Override
    public String getColumnTypeName(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTypeInfo().getSSTypeName();
    }

    @Override
    public int getPrecision(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTypeInfo().getPrecision();
    }

    @Override
    public int getScale(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTypeInfo().getScale();
    }

    @Override
    public String getSchemaName(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTableName().getSchemaName();
    }

    @Override
    public String getTableName(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTableName().getObjectName();
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTypeInfo().isIdentity();
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTypeInfo().isCaseSensitive();
    }

    @Override
    public boolean isCurrency(int n) throws SQLServerException {
        this.checkClosed();
        SSType sSType = this.rs.getColumn(n).getTypeInfo().getSSType();
        return SSType.MONEY == sSType || SSType.SMALLMONEY == sSType;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLServerException {
        this.checkClosed();
        return TypeInfo.UPDATABLE_READ_WRITE == this.rs.getColumn(n).getTypeInfo().getUpdatability();
    }

    @Override
    public int isNullable(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTypeInfo().isNullable() ? 1 : 0;
    }

    @Override
    public boolean isReadOnly(int n) throws SQLServerException {
        this.checkClosed();
        return TypeInfo.UPDATABLE_READ_ONLY == this.rs.getColumn(n).getTypeInfo().getUpdatability();
    }

    @Override
    public boolean isSearchable(int n) throws SQLServerException {
        this.checkClosed();
        switch (this.rs.getColumn(n).getTypeInfo().getSSType()) {
            case IMAGE: 
            case TEXT: 
            case NTEXT: 
            case UDT: 
            case XML: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSigned(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTypeInfo().getSSType().getJDBCType().isSigned();
    }

    @Override
    public boolean isWritable(int n) throws SQLServerException {
        this.checkClosed();
        int n2 = this.rs.getColumn(n).getTypeInfo().getUpdatability();
        return TypeInfo.UPDATABLE_READ_WRITE == n2 || TypeInfo.UPDATABLE_UNKNOWN == n2;
    }

    @Override
    public String getColumnClassName(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTypeInfo().getSSType().getJDBCType().className();
    }
}

