/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.inject;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInstanceFactory;
import option.gad.core.util.ReflectUtil;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdInjector {
    private static GdInjector g;
    private Set<Object> h = new HashSet<Object>();

    static {
        LogFactory.getLog(GdInjector.class);
        g = new GdInjector();
    }

    protected GdInjector() {
    }

    public static GdInjector getInstance() {
        return g;
    }

    public void inject(Object object) {
        if (this.h.contains(object)) {
            return;
        }
        this.h.add(object);
        this.injectMethods(object, ReflectUtil.getMethods(object));
        this.injectFields(object, ReflectUtil.getFields(object));
    }

    public void injectMethods(Object object, Collection<Method> object2) {
        Iterator<Method> iterator = object2.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            this.injectMethod(object, (Method)object2);
        }
    }

    public boolean injectMethod(Object object, Method method) {
        if (method.getAnnotation(GdInject.class) == null) {
            return false;
        }
        if (method.getParameterTypes() == null) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        Class<?> clazz = method.getParameterTypes()[0];
        clazz = GdInstanceFactory.getInstance().getInstance(clazz, new Object[0]);
        if (clazz == null) {
            return false;
        }
        ReflectUtil.invokeMethod(object, method, clazz);
        return true;
    }

    public void injectFields(Object object, Collection<Field> object2) {
        Iterator<Field> iterator = object2.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (!this.injectField(object, (Field)object2)) continue;
            this.inject(GdInstanceFactory.getInstance().getInstance(((Field)object2).getType(), new Object[0]));
        }
    }

    public boolean injectField(Object object, Field field) {
        if (field.getAnnotation(GdInject.class) == null) {
            return false;
        }
        if (ReflectUtil.getFieldValue(object, field) != null) {
            return false;
        }
        Class<?> clazz = field.getType();
        clazz = GdInstanceFactory.getInstance().getInstance(clazz, new Object[0]);
        if (clazz == null) {
            return false;
        }
        ReflectUtil.setFieldValue(object, field, clazz);
        return true;
    }

    public void clear() {
        this.h.clear();
    }
}

