/*
 * Decompiled with CFR 0.152.
 */
package option.threed.render;

import option.threed.render.J3DNode;

public class J3DVector {
    public double x;
    public double y;
    public double z;
    public double w;

    public J3DVector() {
    }

    public J3DVector(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public J3DVector(J3DVector j3DVector) {
        this.x = j3DVector.x;
        this.y = j3DVector.y;
        this.z = j3DVector.z;
    }

    public J3DVector(J3DNode j3DNode) {
        this.x = j3DNode.x;
        this.y = j3DNode.y;
        this.z = j3DNode.z;
    }

    public void set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void initialize(J3DVector j3DVector) {
        this.x = j3DVector.x;
        this.y = j3DVector.y;
        this.z = j3DVector.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void normalize() {
        double d = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public double dotProduct(J3DVector j3DVector) {
        return this.x * j3DVector.x + this.y * j3DVector.y + this.z * j3DVector.z;
    }

    public void crossProduct(J3DVector j3DVector, J3DVector j3DVector2) {
        double d = j3DVector.y * j3DVector2.z - j3DVector.z * j3DVector2.y;
        double d2 = j3DVector.z * j3DVector2.x - j3DVector.x * j3DVector2.z;
        double d3 = j3DVector.x * j3DVector2.y - j3DVector.y * j3DVector2.x;
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void invert() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public void quaternion(J3DVector j3DVector, double d) {
        j3DVector.normalize();
        this.w = Math.cos(d /= 2.0);
        this.x = j3DVector.x * Math.sin(d);
        this.y = j3DVector.y * Math.sin(d);
        this.z = j3DVector.z * Math.sin(d);
    }

    public double angle(J3DVector j3DVector) {
        double d = this.dotProduct(j3DVector);
        double d2 = this.length();
        double d3 = j3DVector.length();
        return Math.acos(d / d2 / d3);
    }

    public boolean compare(J3DVector j3DVector) {
        return this.x == j3DVector.x && this.y == j3DVector.y && this.z == j3DVector.z;
    }

    public int axis() {
        double d;
        double d2 = Math.abs(this.x);
        if (d < Math.abs(this.y)) {
            double d3;
            d2 = Math.abs(this.y);
            if (d3 < Math.abs(this.z)) {
                return 2;
            }
            return 1;
        }
        if (d2 < Math.abs(this.z)) {
            return 2;
        }
        return 0;
    }
}

