/*
 * Decompiled with CFR 0.152.
 */
package kinoki3exchange.shape;

import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import kinoki3exchange.KxBaseModule;
import kinoki3exchange.KxNodeName;
import kinoki3exchange.KxNodeName2;
import kinoki3exchange.shape.KxConstraintsType;
import kinoki3exchange.shape.KxDirectionType;

public abstract class KxEdgeConstraints
extends KxBaseModule {
    protected KxConstraintsType type = KxConstraintsType.LENGTH;

    public void save(ObjectFolder objectFolder) {
        ObjectFolder.addNodeString((ObjectFolder)objectFolder, (String)KxNodeName2.TYPE.name(), (String)this.type.name());
    }

    public void load(ObjectFolder objectFolder) {
        ObjectNode objectNode = objectFolder.getNode(KxNodeName2.TYPE.name());
        if (objectNode != null) {
            String string = ObjectFolder.getNodeString((ObjectNode)objectNode);
            this.type = KxConstraintsType.valueOf(string);
        }
    }

    public abstract boolean available(double var1, double var3, double var5, double var7);

    public static KxNodeName getType(ObjectFolder objectFolder) {
        ObjectNode objectNode = objectFolder.getNode(KxNodeName2.TYPE.name());
        if (objectNode == null) {
            return KxNodeName.NONE;
        }
        String string = ObjectFolder.getNodeString((ObjectNode)objectNode);
        return KxNodeName.valueOf(string);
    }

    public static class Direction
    extends KxEdgeConstraints {
        private float aG;
        private float aH;

        public Direction() {
            this.type = KxConstraintsType.DIRECTION;
        }

        public float getDx() {
            return this.aG;
        }

        public float getDy() {
            return this.aH;
        }

        public void setDxy(float f, float f2) {
            this.aG = f;
            this.aH = f2;
            this.normalize();
        }

        private void normalize() {
            double d = this.aG * this.aG + this.aH * this.aH;
            if (d != 0.0) {
                this.aG = (float)((double)this.aG / d);
                this.aH = (float)((double)this.aH / d);
            }
        }

        public void save(ObjectFolder objectFolder) {
            super.save(objectFolder);
            ObjectFolder.addNodeFloat((ObjectFolder)objectFolder, (String)KxNodeName2.DX.name(), (float)this.aG);
            ObjectFolder.addNodeFloat((ObjectFolder)objectFolder, (String)KxNodeName2.DY.name(), (float)this.aH);
        }

        public void load(ObjectFolder objectFolder) {
            super.load(objectFolder);
            ObjectNode objectNode = null;
            objectNode = objectFolder.getNode(KxNodeName2.DX.name());
            if (objectNode != null) {
                this.aG = ObjectFolder.getNodeFloat((ObjectNode)objectNode);
            }
            if ((objectNode = objectFolder.getNode(KxNodeName2.DY.name())) != null) {
                this.aH = ObjectFolder.getNodeFloat((ObjectNode)objectNode);
            }
            this.normalize();
        }

        public boolean available(double d, double d2, double d3, double d4) {
            double d5;
            double d6;
            double d7 = d3 - d;
            double d8 = d4 - d2;
            return 0.99 <= (d6 = (double)this.aG * (d7 /= (d5 = Math.sqrt(d7 * d7 + d8 * d8))) + (double)this.aH * (d8 /= d5));
        }
    }

    public static class FixLength
    extends KxEdgeConstraints {
        private float aI;

        public FixLength() {
            this.type = KxConstraintsType.FIXLENGTH;
        }

        public float getLength() {
            return this.aI;
        }

        public void setLength(float f) {
            this.aI = f;
        }

        public void save(ObjectFolder objectFolder) {
            super.save(objectFolder);
            ObjectFolder.addNodeFloat((ObjectFolder)objectFolder, (String)KxNodeName2.LENGTH.name(), (float)this.aI);
        }

        public void load(ObjectFolder objectFolder) {
            super.load(objectFolder);
            ObjectNode objectNode = null;
            objectNode = objectFolder.getNode(KxNodeName2.LENGTH.name());
            if (objectNode != null) {
                this.aI = ObjectFolder.getNodeFloat((ObjectNode)objectNode);
            }
        }

        public boolean available(double d, double d2, double d3, double d4) {
            double d5 = d3 - d;
            double d6 = d4 - d2;
            double d7 = Math.sqrt(d5 * d5 + d6 * d6);
            return Math.abs((double)this.aI - d7) <= 0.001;
        }
    }

    public static class Length
    extends KxEdgeConstraints {
        private float aI;

        public Length() {
            this.type = KxConstraintsType.LENGTH;
        }

        public float getLength() {
            return this.aI;
        }

        public void setLength(float f) {
            this.aI = f;
        }

        public void save(ObjectFolder objectFolder) {
            super.save(objectFolder);
            ObjectFolder.addNodeFloat((ObjectFolder)objectFolder, (String)KxNodeName2.LENGTH.name(), (float)this.aI);
        }

        public void load(ObjectFolder objectFolder) {
            super.load(objectFolder);
            ObjectNode objectNode = null;
            objectNode = objectFolder.getNode(KxNodeName2.LENGTH.name());
            if (objectNode != null) {
                this.aI = ObjectFolder.getNodeFloat((ObjectNode)objectNode);
            }
        }

        public boolean available(double d, double d2, double d3, double d4) {
            double d5 = d3 - d;
            double d6 = d4 - d2;
            double d7 = Math.sqrt(d5 * d5 + d6 * d6);
            return (double)this.aI <= d7 + 0.001;
        }
    }

    public static class XDirection
    extends KxEdgeConstraints {
        private KxDirectionType aJ;

        public XDirection() {
            this.type = KxConstraintsType.XDIRECTION;
        }

        public KxDirectionType getDirection() {
            return this.aJ;
        }

        public void setDirection(KxDirectionType kxDirectionType) {
            this.aJ = kxDirectionType;
        }

        public void save(ObjectFolder objectFolder) {
            super.save(objectFolder);
            ObjectFolder.addNodeString((ObjectFolder)objectFolder, (String)KxNodeName2.DIRECTION.name(), (String)this.aJ.name());
        }

        public void load(ObjectFolder objectFolder) {
            super.load(objectFolder);
            ObjectNode objectNode = objectFolder.getNode(KxNodeName2.DIRECTION.name());
            if (objectNode != null) {
                String string = ObjectFolder.getNodeString((ObjectNode)objectNode);
                this.aJ = KxDirectionType.valueOf(string);
            }
        }

        public boolean available(double d, double d2, double d3, double d4) {
            return this.aJ.available(d3 - d);
        }
    }

    public static class YDirection
    extends KxEdgeConstraints {
        private KxDirectionType aJ;

        public YDirection() {
            this.type = KxConstraintsType.YDIRECTION;
        }

        public KxDirectionType getDirection() {
            return this.aJ;
        }

        public void setDirection(KxDirectionType kxDirectionType) {
            this.aJ = kxDirectionType;
        }

        public void save(ObjectFolder objectFolder) {
            super.save(objectFolder);
            ObjectFolder.addNodeString((ObjectFolder)objectFolder, (String)KxNodeName2.DIRECTION.name(), (String)this.aJ.name());
        }

        public void load(ObjectFolder objectFolder) {
            super.load(objectFolder);
            ObjectNode objectNode = objectFolder.getNode(KxNodeName2.DIRECTION.name());
            if (objectNode != null) {
                String string = ObjectFolder.getNodeString((ObjectNode)objectNode);
                this.aJ = KxDirectionType.valueOf(string);
            }
        }

        public boolean available(double d, double d2, double d3, double d4) {
            return this.aJ.available(d4 - d2);
        }
    }
}

