/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui;

import com.kt.gui.event.AccelKey;
import com.kt.util.Vector2;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import jp.kitec.kwt.util.ImageTool;
import jp.kitec.richui.TipsMessage;
import nethome.NethomeLookAndFeel;
import nethome.UserInfo;
import nethome.doc.CopyBuffer;
import nethome.doc.Document;
import nethome.doc.Project;
import nethome.lib.ObjectLibrary;
import nethome.ui.Canvas2D;
import nethome.ui.GuiCreator;
import nethome.ui.ICanvas2D;
import nethome.ui.MainApplication;
import nethome.ui.MaskCommand;
import nethome.ui.NoDefaultKeyListener;
import nethome.ui.ProjectList;
import nethome.ui.command.Command;
import nethome.ui.gui.NethomeDialog;
import nethome.ui.gui.NethomeDialogInnerComponent;
import nethome.ui.gui.WindowContainer;
import nethome.ui.gui.WindowSystemClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainComponent
extends JPanel
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private static MainComponent mMc = null;
    private MainApplication mManApp;
    private Vector2<Command> mCommandCollection;
    public TipsMessage mStatusBar;
    private WindowContainer mWindowContainer;
    private GuiCreator mGuiCreator;
    private ProjectList mProjectList;
    private Hashtable<String, ObjectLibrary> mLibrary;
    private Vector<AccelKey> mKeyCommnd;
    private UserInfo mUserInfo;
    private ImageTool mImageTool;
    private CopyBuffer mCopyBuffer;
    private Vector<MaskCommand> mMaskCommands;
    private CardLayout mCardLayout;

    public static MainComponent createInstance(MainApplication mainApplication) {
        mMc = new MainComponent(mainApplication);
        return mMc;
    }

    public static void clearInstance() {
        if (mMc != null) {
            mMc.removeAll();
        }
        mMc = null;
    }

    public static MainComponent getInstance() {
        return mMc;
    }

    private MainComponent(MainApplication mainApplication) {
        mMc = this;
        this.mManApp = mainApplication;
        this.mMaskCommands = new Vector();
        this.mUserInfo = new UserInfo();
        this.mKeyCommnd = new Vector();
        this.mCommandCollection = new Vector2();
        this.mLibrary = new Hashtable();
        this.mCopyBuffer = new CopyBuffer();
        MainComponent.mMc.mCardLayout = new CardLayout();
        this.setLayout(MainComponent.mMc.mCardLayout);
    }

    public void init(GuiCreator guiCreator, WindowContainer windowContainer, String string) {
        this.mImageTool = new ImageTool(this.mManApp.getImageObserver());
        this.mGuiCreator = guiCreator;
        this.mWindowContainer = windowContainer;
        this.mProjectList = new ProjectList(this.mWindowContainer);
        if (this.mGuiCreator == null) {
            return;
        }
        this.mGuiCreator.createInterface(this, this.mWindowContainer, this.mCommandCollection, string);
        this.appendKeyListener(this);
    }

    public void clearCurrentProject() {
        Canvas2D canvas2D = this.getActiveCanvas();
        if (canvas2D != null) {
            Project project = canvas2D.getProject();
            project.documentReflesh();
        }
    }

    public Document getActiveDocument() {
        Canvas2D canvas2D = this.getActiveCanvas();
        if (canvas2D == null) {
            return null;
        }
        return canvas2D.getDocument();
    }

    public Canvas2D getActiveCanvas() {
        WindowSystemClient windowSystemClient = this.mWindowContainer.getActiveClient();
        if (windowSystemClient != null) {
            return (Canvas2D)windowSystemClient.getCanvas();
        }
        return null;
    }

    public void setActiveCanvas(Canvas2D canvas2D) {
        WindowSystemClient windowSystemClient = null;
        windowSystemClient = this.mProjectList.setActiveProject((ICanvas2D)canvas2D);
        if (windowSystemClient != null) {
            this.mWindowContainer.update(windowSystemClient, false);
            this.updateUserInterface();
        }
    }

    public Project getActiveProject() {
        Canvas2D canvas2D = this.getActiveCanvas();
        if (canvas2D == null) {
            return null;
        }
        Project project = canvas2D.getProject();
        return project;
    }

    public void registLibrary(String string, ObjectLibrary objectLibrary) {
        if (string != null && objectLibrary != null) {
            this.mLibrary.put(string, objectLibrary);
        }
    }

    public ObjectLibrary getLibrary(String string) {
        ObjectLibrary objectLibrary = this.mLibrary.get(string);
        if (objectLibrary != null && objectLibrary instanceof ObjectLibrary) {
            return objectLibrary;
        }
        return null;
    }

    public ProjectList getProjectList() {
        return this.mProjectList;
    }

    public WindowContainer getWindowContainer() {
        return this.mWindowContainer;
    }

    public UserInfo getUserInfo() {
        return this.mUserInfo;
    }

    public GuiCreator getGuiCreator() {
        return this.mGuiCreator;
    }

    public void registAccel(AccelKey accelKey) {
        this.mKeyCommnd.addElement(accelKey);
    }

    public AccelKey getAccel(KeyEvent keyEvent) {
        for (int i = 0; i < this.mKeyCommnd.size(); ++i) {
            AccelKey accelKey = this.mKeyCommnd.elementAt(i);
            if (!accelKey.equal(keyEvent.getModifiers(), keyEvent.getKeyCode())) continue;
            return accelKey;
        }
        return null;
    }

    public void registMaskEvent(Command command, int n) {
        this.mMaskCommands.addElement(new MaskCommand(command, n));
    }

    public Command getMaskCommand(int n) {
        for (int i = 0; i < this.mMaskCommands.size(); ++i) {
            MaskCommand maskCommand = this.mMaskCommands.elementAt(i);
            if (!maskCommand.isMutchMask(n & 1 | n & 8 | n & 2)) continue;
            return maskCommand.getCommand();
        }
        return null;
    }

    public Vector2<Command> getCommandCollection() {
        return this.mCommandCollection;
    }

    public <T extends Command> T getCommand(Class<T> clazz) {
        for (int i = 0; i < this.mCommandCollection.size(); ++i) {
            Command command = (Command)this.mCommandCollection.elementAt(i);
            if (!command.getClass().equals(clazz)) continue;
            return (T)((Command)clazz.cast(command));
        }
        return null;
    }

    public void block() {
        this.setEnabled(false);
    }

    public void unblock() {
        this.setEnabled(true);
    }

    public Class<? extends MainApplication> getMainClass() {
        return this.mManApp.getClass();
    }

    public MainApplication getApplication() {
        return this.mManApp;
    }

    public void preFrameClose() {
        Vector2<Command> vector2 = this.getCommandCollection();
        for (int i = 0; i < vector2.size(); ++i) {
            Command command = (Command)vector2.elementAt(i);
            command.frameClosing();
        }
    }

    public boolean doModal(Frame frame, Object object, int n, boolean bl, String string, boolean bl2) {
        return this.doModal(frame, object, n, bl, string, null, bl2, -1, -1);
    }

    public boolean doModal(Frame frame, Object object, int n, boolean bl, String string, Component component, boolean bl2) {
        return this.doModal(frame, object, n, bl, string, null, bl2, -1, -1);
    }

    public boolean doModal(Frame frame, Object object, int n, boolean bl, String string, Component component, boolean bl2, int n2, int n3) {
        if (frame == null) {
            frame = this.getParentFrame();
        }
        NethomeDialog nethomeDialog = new NethomeDialog(frame, object, n, NethomeLookAndFeel.DIALOG_AROUND_COLOR);
        if (object instanceof NethomeDialogInnerComponent) {
            ((NethomeDialogInnerComponent)object).setParentDialog(nethomeDialog);
        }
        nethomeDialog.setInitFocus(component);
        nethomeDialog.setTitle(string);
        nethomeDialog.setResizable(bl);
        if (n2 > 0 && n3 > 0) {
            nethomeDialog.setSize(n2, n3);
        }
        this.block();
        if (bl2) {
            nethomeDialog.setVisible(true, true);
        } else {
            nethomeDialog.setVisible(true, true, this.getActiveCanvas());
        }
        this.unblock();
        boolean bl3 = nethomeDialog.getCloseState() == 0;
        nethomeDialog.dispose();
        return bl3;
    }

    public Dialog doModeless(Frame frame, Object object, int n, int n2, boolean bl, String string, Component component, boolean bl2, int n3, int n4) {
        NethomeDialog nethomeDialog = new NethomeDialog(frame, object, n, NethomeLookAndFeel.DIALOG_AROUND_COLOR);
        nethomeDialog.setModal(false);
        nethomeDialog.setInitFocus(component);
        nethomeDialog.setTitle(string);
        nethomeDialog.setResizable(bl);
        if (n3 > 0 && n4 > 0) {
            nethomeDialog.setSize(n3, n4);
        } else {
            nethomeDialog.pack();
        }
        if (n2 >= 0) {
            nethomeDialog.setVisible(true, frame, n2);
        } else if (bl2) {
            nethomeDialog.setVisible(true, true);
        } else {
            nethomeDialog.setVisible(true, true, this.getActiveCanvas());
        }
        return nethomeDialog;
    }

    public void appendKeyListener(Object object) {
        if (object.getClass().isAnnotationPresent(NoDefaultKeyListener.class)) {
            return;
        }
        if (object instanceof Container) {
            Component[] componentArray;
            Container container = (Container)object;
            container.addKeyListener(this);
            if (container.getComponentCount() != 0 && (componentArray = container.getComponents()) != null) {
                for (int i = 0; i < componentArray.length; ++i) {
                    this.appendKeyListener(componentArray[i]);
                }
            }
        } else if (object instanceof Component) {
            Component component = (Component)object;
            component.addKeyListener(this);
        }
    }

    public ImageTool getImageTool() {
        return this.mImageTool;
    }

    public static void updateLayout() {
        MainComponent mainComponent = MainComponent.getInstance();
        if (mainComponent != null) {
            MainComponent.updateLayout(mainComponent);
            ((Component)mainComponent).validate();
            ((Component)mainComponent).doLayout();
        }
    }

    public static void updateLayout(Object object) {
        if (object instanceof Container) {
            Component[] componentArray;
            Container container = (Container)object;
            container.invalidate();
            if (container.getComponentCount() != 0 && (componentArray = container.getComponents()) != null) {
                for (int i = 0; i < componentArray.length; ++i) {
                    MainComponent.updateLayout(componentArray[i]);
                }
            }
        } else if (object instanceof Component) {
            Component component = (Component)object;
            component.invalidate();
        }
    }

    public Frame getParentFrame() {
        return this.mManApp.getParentFrame();
    }

    public TipsMessage getTipsMessage() {
        return this.mStatusBar;
    }

    public void initUserInterface() {
        for (int i = 0; i < this.mCommandCollection.size(); ++i) {
            Command command = (Command)this.mCommandCollection.elementAt(i);
            command.initInterface();
        }
    }

    public void updateUserInterface() {
        for (int i = 0; i < this.mCommandCollection.size(); ++i) {
            Command command = (Command)this.mCommandCollection.elementAt(i);
            command.updateInterface();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Canvas2D canvas2D = this.getActiveCanvas();
        if (canvas2D != null) {
            canvas2D.keyPress(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        Canvas2D canvas2D = this.getActiveCanvas();
        if (canvas2D != null) {
            canvas2D.keyRelease(keyEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public CopyBuffer getCopyBuffer() {
        return this.mCopyBuffer;
    }

    public void addPage(String string, Component component) {
        this.add(component, string);
    }

    public void changePage(String string) {
        this.mCardLayout.show(this, string);
    }

    public Component getActivePage() {
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (!componentArray[i].isVisible()) continue;
                return componentArray[i];
            }
        }
        return null;
    }

    @Override
    public void setCursor(Cursor cursor) {
        Component[] componentArray;
        super.setCursor(cursor);
        if (this.getComponentCount() != 0 && (componentArray = this.getComponents()) != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                this.setCursor(cursor, componentArray[i]);
            }
        }
    }

    public void setCursor(Cursor cursor, Object object) {
        if (object instanceof Container) {
            Component[] componentArray;
            Container container = (Container)object;
            container.setCursor(cursor);
            if (container.getComponentCount() != 0 && (componentArray = container.getComponents()) != null) {
                for (int i = 0; i < componentArray.length; ++i) {
                    this.setCursor(cursor, componentArray[i]);
                }
            }
        } else if (object instanceof Component) {
            Component component = (Component)object;
            component.setCursor(cursor);
        }
    }
}

