/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom.primitive;

import com.kt.util.RefList;
import com.kt.util.Vector2;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.awt.Color;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.IRichGraphics;
import nethome.geom.LocalAxis2Df;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.Geometory;
import nethome.geom.primitive.IFillableGeometory;
import nethome.geom.primitive.Primitive;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolMathEx;
import nethome.geom.util.ToolPolygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GRect
extends Geometory
implements Primitive,
IFillableGeometory {
    private static final String GEOMNAME = "RECT";
    protected RefList<GPoint2Df> mPoints;
    public float mLineWidth;
    protected transient RefList<GPoint2Df> _pbuf;
    protected boolean mFill = false;
    protected Color mFillColor;

    public GRect() {
        this(0.0f, 0.0f, 0.0f, 0.0f, false);
    }

    public GRect(float f, float f2, float f3, float f4, boolean bl) {
        this(f, f2, f3, f2, f3, f4, f, f4, bl);
    }

    public GRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, boolean bl) {
        this.setGeomName(GEOMNAME);
        this.mGeomColor = Color.black;
        this.mFillColor = Color.black;
        this.mFill = bl;
        this.mLineWidth = 0.0f;
        this.mPoints = new RefList();
        this.mPoints.addElement((Object)new GPoint2Df(f, f2));
        this.mPoints.addElement((Object)new GPoint2Df(f3, f4));
        this.mPoints.addElement((Object)new GPoint2Df(f5, f6));
        this.mPoints.addElement((Object)new GPoint2Df(f7, f8));
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public GPoint2Df getP1() {
        return (GPoint2Df)this.mPoints.elementAt(0);
    }

    public GPoint2Df getP2() {
        return (GPoint2Df)this.mPoints.elementAt(2);
    }

    public void setRect(float f, float f2, float f3, float f4) {
        float f5 = f < f3 ? f : f3;
        float f6 = f2 < f4 ? f2 : f4;
        float f7 = f > f3 ? f : f3;
        float f8 = f2 > f4 ? f2 : f4;
        for (int i = 0; i < 4; ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            gPoint2Df.x = i == 0 || i == 3 ? f5 : f7;
            gPoint2Df.y = i == 0 || i == 1 ? f6 : f8;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public boolean getSnapNode(float f, float f2, float f3, float f4, float[] fArray, float[] fArray2, float f5, short s) {
        boolean bl = false;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            boolean bl2 = false;
            if (!bl2) continue;
            bl = bl2;
        }
        return bl;
    }

    @Override
    public void getSnapLoop(Vector2<? super GPoint2Df> vector2) {
        for (int i = 0; i <= this.mPoints.size(); ++i) {
            vector2.addElement(this.mPoints.elementAt(i));
        }
    }

    @Override
    public void getCenter(GPoint2Df gPoint2Df) {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(i);
            f += gPoint2Df2.x;
            f2 += gPoint2Df2.y;
        }
        gPoint2Df.x = f / (float)this.mPoints.size();
        gPoint2Df.y = f2 / (float)this.mPoints.size();
    }

    @Override
    public GPoint2Df getNearNode(GPoint2Df gPoint2Df, GPoint2Df gPoint2Df2, float f) {
        float f2 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df3 = null;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            float f3;
            GPoint2Df gPoint2Df4 = (GPoint2Df)this.mPoints.elementAt(i);
            float f4 = (float)ToolMath.getLengthLimitLineToPoint2D(gPoint2Df4.x, gPoint2Df4.y, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (!(f3 >= 0.0f) || !(f4 < f) || !(f4 < f2)) continue;
            f2 = f4;
            gPoint2Df3 = gPoint2Df4;
        }
        return gPoint2Df3;
    }

    @Override
    public boolean getNearLine(float f, float f2, float f3, GPoint2Df[] gPoint2DfArray) {
        boolean bl = false;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            float f4;
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(i + 1);
            float f5 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (!(f4 >= 0.0f) || !(f5 < f3)) continue;
            gPoint2DfArray[0] = gPoint2Df;
            gPoint2DfArray[1] = gPoint2Df2;
            bl = true;
        }
        return bl;
    }

    @Override
    public GPoint2Df getRotbasePoint() {
        return (GPoint2Df)this.mPoints.elementAt(0);
    }

    @Override
    public void updateMinMax(Area area) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            area.updateMinMax(gPoint2Df.x, gPoint2Df.y);
        }
    }

    @Override
    public Geometory getCopy() {
        return this.getCopy(new GRect());
    }

    @Override
    protected Geometory getCopy(Geometory geometory) {
        if (geometory == null || !(geometory instanceof GRect)) {
            return null;
        }
        GRect gRect = (GRect)geometory;
        super.getCopy(gRect);
        float f = ((GPoint2Df)this.mPoints.elementAt((int)0)).x;
        float f2 = ((GPoint2Df)this.mPoints.elementAt((int)0)).y;
        float f3 = ((GPoint2Df)this.mPoints.elementAt((int)2)).x;
        float f4 = ((GPoint2Df)this.mPoints.elementAt((int)2)).y;
        gRect.setRect(f, f2, f3, f4);
        gRect.area.maximize();
        gRect.setFillMode(this.mFill);
        gRect.setFillColor(this.mFillColor);
        gRect.updateMinMax(gRect.area);
        return gRect;
    }

    @Override
    public GPoint2Df getNearNode(float f, float f2) {
        float f3 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df = null;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            float f4;
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(i);
            float f5 = (float)ToolMath.getLength2D(f, f2, gPoint2Df2.x, gPoint2Df2.y);
            if (!(f4 < f3)) continue;
            gPoint2Df = gPoint2Df2;
            f3 = f5;
        }
        return gPoint2Df;
    }

    @Override
    public float getDistanceToPoint(float f, float f2) {
        float f3 = Float.MAX_VALUE;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(i + 1);
            float f4 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (!(f4 >= 0.0f) || !(f4 < f3)) continue;
            f3 = f4;
        }
        return f3;
    }

    @Override
    public void offset(float f, float f2) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            gPoint2Df.offset(f, f2);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void rotate(float f, float f2, float f3) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            gPoint2Df.rotate(f, f2, f3);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public boolean isInner(float f, float f2, float f3, float f4) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            if (gPoint2Df.x > f && gPoint2Df.x < f3 && gPoint2Df.y > f2 && gPoint2Df.y < f4) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInner(RefList<GPoint2Df> refList) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(i + 1);
            boolean bl = ToolPolygon.isInnerPolygon(refList, gPoint2Df.x, gPoint2Df.y);
            boolean bl2 = ToolPolygon.isInnerPolygon(refList, gPoint2Df2.x, gPoint2Df2.y);
            if (bl && bl2) continue;
            return false;
        }
        return true;
    }

    @Override
    public void save(ObjectFolder objectFolder) {
        if (objectFolder == null) {
            return;
        }
        super.save(objectFolder);
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            objectFolder.addChild(new ObjectNode("x" + (i + 1), (Object)Float.toString(gPoint2Df.x)));
            objectFolder.addChild(new ObjectNode("y" + (i + 1), (Object)Float.toString(gPoint2Df.y)));
        }
        objectFolder.addChild(new ObjectNode("fill", (Object)(this.mFill ? "1" : "0")));
        objectFolder.addChild(new ObjectNode("width", (Object)Float.toString(this.mLineWidth)));
    }

    @Override
    public void drawGeom(IRichGraphics iRichGraphics) {
        this.drawGeom(iRichGraphics, Color.black, null);
    }

    @Override
    public void drawGeom(IRichGraphics iRichGraphics, Color color, Color color2) {
        if (color2 == null) {
            color2 = this.mFillColor;
        }
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, null);
    }

    @Override
    public void drawAlias(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        this.drawAbstDevice(iRichGraphics, color, color2, localAxis2Df);
    }

    @Override
    public void drawAbstDevice(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        if (this.mFill) {
            if (localAxis2Df != null) {
                int n;
                if (this._pbuf == null) {
                    this._pbuf = new RefList();
                }
                if (this._pbuf.size() != this.mPoints.size()) {
                    this._pbuf.removeAllElements();
                    for (n = 0; n < this.mPoints.size(); ++n) {
                        this._pbuf.addElement((Object)new GPoint2Df());
                    }
                }
                for (n = 0; n < this.mPoints.size(); ++n) {
                    GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(n);
                    GPoint2Df gPoint2Df2 = (GPoint2Df)this._pbuf.elementAt(n);
                    gPoint2Df2.x = localAxis2Df.getGlobalX(gPoint2Df.x, gPoint2Df.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                    gPoint2Df2.y = localAxis2Df.getGlobalY(gPoint2Df.x, gPoint2Df.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                }
                iRichGraphics.setColor(color2);
                iRichGraphics.drawFillPolygon(this._pbuf, null);
            } else {
                iRichGraphics.setColor(color2);
                iRichGraphics.drawFillPolygon(this.mPoints, null);
            }
        }
        iRichGraphics.setColor(color);
        iRichGraphics.drawFillPolygon(this.mPoints, null);
    }

    @Override
    public void drawHighLight(IRichGraphics iRichGraphics, Color color, boolean bl) {
        if (bl) {
            iRichGraphics.setColor(color);
            iRichGraphics.drawPolygon(this.mPoints, IRichGraphics.LINE_DASH_1);
        }
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(i);
            gPoint2Df.drawHighLight(iRichGraphics, color, false);
        }
    }

    @Override
    public Object getNearControlPoint(float f, float f2) {
        float f3 = Float.POSITIVE_INFINITY;
        GPoint2Df gPoint2Df = null;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(i);
            float f4 = gPoint2Df2.getDistanceToPoint(f, f2);
            if (!(f4 < f3)) continue;
            f3 = f4;
            gPoint2Df = gPoint2Df2;
        }
        return gPoint2Df;
    }

    @Override
    public void moveControlPoint(Object object, float f, float f2) {
        GPoint2Df gPoint2Df;
        GPoint2Df gPoint2Df2 = (GPoint2Df)object;
        Object object2 = this.mPoints.itemAt((Object)gPoint2Df2).nextItem.getObject();
        GPoint2Df gPoint2Df3 = object2 != null && object2 instanceof GPoint2Df ? (GPoint2Df)object2 : null;
        object2 = this.mPoints.itemAt((Object)object2).nextItem.getObject();
        GPoint2Df gPoint2Df4 = object2 != null && object2 instanceof GPoint2Df ? (GPoint2Df)object2 : null;
        object2 = this.mPoints.itemAt((Object)object2).nextItem.getObject();
        GPoint2Df gPoint2Df5 = gPoint2Df = object2 != null && object2 instanceof GPoint2Df ? (GPoint2Df)object2 : null;
        if (!(gPoint2Df3 == null || gPoint2Df4 == null || gPoint2Df4 == null || ToolMathEx.isPointPickUporDown(f, f2, gPoint2Df3, gPoint2Df4) && ToolMathEx.isPointPickUporDown(f, f2, gPoint2Df4, gPoint2Df))) {
            return;
        }
        double d = ToolMathEx.getLengthLimitlessLineToPoint2D(f, f2, gPoint2Df3.x, gPoint2Df3.y, gPoint2Df4.x, gPoint2Df4.y);
        if (d >= 0.0 && d < (double)0.001f) {
            return;
        }
        d = ToolMathEx.getLengthLimitlessLineToPoint2D(f, f2, gPoint2Df4.x, gPoint2Df4.y, gPoint2Df.x, gPoint2Df.y);
        if (d >= 0.0 && d < (double)0.001f) {
            return;
        }
        float[] fArray = new float[2];
        for (int i = 0; i < this.mPoints.size(); ++i) {
            GPoint2Df gPoint2Df6 = (GPoint2Df)this.mPoints.elementAt(i);
            if (gPoint2Df6 != object) continue;
            GPoint2Df gPoint2Df7 = (GPoint2Df)this.mPoints.elementAt(i - 2);
            GPoint2Df gPoint2Df8 = (GPoint2Df)this.mPoints.elementAt(i - 1);
            GPoint2Df gPoint2Df9 = (GPoint2Df)this.mPoints.elementAt(i + 1);
            gPoint2Df6.x = f;
            gPoint2Df6.y = f2;
            ToolMath.isCrossPointVertLimitlessLineToPoint2D(f, f2, gPoint2Df7.x, gPoint2Df7.y, gPoint2Df8.x, gPoint2Df8.y, fArray);
            gPoint2Df8.x = fArray[0];
            gPoint2Df8.y = fArray[1];
            ToolMath.isCrossPointVertLimitlessLineToPoint2D(f, f2, gPoint2Df7.x, gPoint2Df7.y, gPoint2Df9.x, gPoint2Df9.y, fArray);
            gPoint2Df9.x = fArray[0];
            gPoint2Df9.y = fArray[1];
            break;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void flipx(float f, float f2) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            ((GPoint2Df)this.mPoints.elementAt(i)).flipx(f, f2);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void flipy(float f, float f2) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            ((GPoint2Df)this.mPoints.elementAt(i)).flipy(f, f2);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void rot(float f, float f2, float f3, float f4) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            ((GPoint2Df)this.mPoints.elementAt(i)).rot(f, f2, f3, f4);
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    protected void updateShape() {
        GPoint2Df gPoint2Df = (GPoint2Df)this.mPoints.elementAt(0);
        GPoint2Df gPoint2Df2 = (GPoint2Df)this.mPoints.elementAt(1);
        GPoint2Df gPoint2Df3 = (GPoint2Df)this.mPoints.elementAt(2);
        GPoint2Df gPoint2Df4 = (GPoint2Df)this.mPoints.elementAt(3);
        gPoint2Df2.x = gPoint2Df3.x;
        gPoint2Df2.y = gPoint2Df.y;
        gPoint2Df4.x = gPoint2Df.x;
        gPoint2Df4.y = gPoint2Df3.y;
    }

    @Override
    public void setFillMode(boolean bl) {
        this.mFill = bl;
    }

    @Override
    public boolean isFillMode() {
        return this.mFill;
    }

    @Override
    public Color getFillColor() {
        return this.mFillColor;
    }

    @Override
    public void setFillColor(Color color) {
        this.mFillColor = color;
    }
}

