/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.ObjectProvider;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.criteria.command.MappedResultStreamHandler;
import org.seasar.doma.jdbc.criteria.context.SetOperationContext;
import org.seasar.doma.jdbc.criteria.declaration.SelectFromDeclaration;
import org.seasar.doma.jdbc.criteria.statement.AbstractSetOperand;
import org.seasar.doma.jdbc.criteria.statement.NativeSqlSelectTerminal;
import org.seasar.doma.jdbc.query.SelectQuery;

public class NativeSqlSelectIntermediate<ELEMENT>
extends AbstractSetOperand<NativeSqlSelectIntermediate<ELEMENT>, ELEMENT> {
    private final SelectFromDeclaration declaration;

    public NativeSqlSelectIntermediate(Config config, SelectFromDeclaration declaration, Function<SelectQuery, ObjectProvider<ELEMENT>> objectProviderFactory) {
        super(Objects.requireNonNull(config), objectProviderFactory);
        this.declaration = Objects.requireNonNull(declaration);
    }

    @Override
    public SetOperationContext<ELEMENT> getContext() {
        return new SetOperationContext.Select(this.declaration.getContext());
    }

    @Override
    public <RESULT> RESULT mapStream(Function<Stream<ELEMENT>, RESULT> streamMapper) {
        Objects.requireNonNull(streamMapper);
        NativeSqlSelectTerminal<RESULT> terminal = this.createNativeSqlSelectTerminal(streamMapper);
        return terminal.execute();
    }

    @Override
    protected Command<List<ELEMENT>> createCommand() {
        NativeSqlSelectTerminal<List> terminal = this.createNativeSqlSelectTerminal(stream -> stream.collect(Collectors.toList()));
        return terminal.createCommand();
    }

    private <RESULT> NativeSqlSelectTerminal<RESULT> createNativeSqlSelectTerminal(Function<Stream<ELEMENT>, RESULT> streamMapper) {
        MappedResultStreamHandler<ELEMENT, RESULT> handler = new MappedResultStreamHandler<ELEMENT, RESULT>(streamMapper, this.objectProviderFactory);
        return new NativeSqlSelectTerminal(this.config, this.declaration, handler);
    }
}

