/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.util.Objects;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.command.InsertCommand;
import org.seasar.doma.jdbc.criteria.context.InsertContext;
import org.seasar.doma.jdbc.criteria.context.InsertSettings;
import org.seasar.doma.jdbc.criteria.declaration.InsertDeclaration;
import org.seasar.doma.jdbc.criteria.query.CriteriaQuery;
import org.seasar.doma.jdbc.criteria.query.InsertBuilder;
import org.seasar.doma.jdbc.criteria.statement.AbstractStatement;

public class NativeSqlInsertTerminal
extends AbstractStatement<NativeSqlInsertTerminal, Integer> {
    private final InsertDeclaration declaration;

    public NativeSqlInsertTerminal(Config config, InsertDeclaration declaration) {
        super(Objects.requireNonNull(config));
        Objects.requireNonNull(declaration);
        this.declaration = declaration;
    }

    @Override
    public Integer execute() {
        return (Integer)super.execute();
    }

    @Override
    protected Command<Integer> createCommand() {
        InsertContext context = this.declaration.getContext();
        InsertSettings settings = context.getSettings();
        InsertBuilder builder = new InsertBuilder(this.config, context, this.createCommenter(settings.getComment()), settings.getSqlLogType());
        PreparedSql sql = builder.build();
        CriteriaQuery query = new CriteriaQuery(this.config, sql, this.getClass().getName(), "execute");
        query.setQueryTimeout(settings.getQueryTimeout());
        return new InsertCommand(query);
    }
}

