/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.statement;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.seasar.doma.DomaException;
import org.seasar.doma.jdbc.CommentContext;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.command.Command;
import org.seasar.doma.jdbc.criteria.statement.Statement;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AbstractStatement<STMT extends AbstractStatement<STMT, RESULT>, RESULT>
implements Statement<RESULT> {
    protected static final String EXECUTE_METHOD_NAME = "execute";
    protected static final Method EXECUTE_METHOD;
    protected final Config config;

    protected AbstractStatement(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    @Override
    public RESULT execute() {
        Command<RESULT> command = this.createCommand();
        return command.execute();
    }

    @Override
    public Sql<?> asSql() {
        Command<RESULT> command = this.createCommand();
        return command.getQuery().getSql();
    }

    @Override
    public STMT peek(Consumer<Sql<?>> consumer) {
        return (STMT)((AbstractStatement)Statement.super.peek((Consumer)consumer));
    }

    protected Function<String, String> createCommenter(String comment) {
        return sql -> {
            CommentContext context = new CommentContext(this.getClass().getName(), EXECUTE_METHOD_NAME, this.config, EXECUTE_METHOD, comment);
            return this.config.getCommenter().comment((String)sql, context);
        };
    }

    protected abstract Command<RESULT> createCommand();

    static {
        try {
            EXECUTE_METHOD = Statement.class.getMethod(EXECUTE_METHOD_NAME, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new DomaException((MessageResource)Message.DOMA6005, (Throwable)e, EXECUTE_METHOD_NAME);
        }
    }
}

