/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.query;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.seasar.doma.DomaException;
import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.internal.jdbc.sql.BasicInParameter;
import org.seasar.doma.internal.jdbc.sql.ConvertToLogFormatFunction;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.InParameter;
import org.seasar.doma.jdbc.criteria.context.Criterion;
import org.seasar.doma.jdbc.criteria.context.Operand;
import org.seasar.doma.jdbc.criteria.context.SelectContext;
import org.seasar.doma.jdbc.criteria.expression.AggregateFunction;
import org.seasar.doma.jdbc.criteria.expression.ArithmeticExpression;
import org.seasar.doma.jdbc.criteria.expression.CaseExpression;
import org.seasar.doma.jdbc.criteria.expression.LiteralExpression;
import org.seasar.doma.jdbc.criteria.expression.SelectExpression;
import org.seasar.doma.jdbc.criteria.expression.StringExpression;
import org.seasar.doma.jdbc.criteria.metamodel.EntityMetamodel;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.criteria.option.LikeOption;
import org.seasar.doma.jdbc.criteria.query.AliasManager;
import org.seasar.doma.jdbc.criteria.query.CriteriaBuilder;
import org.seasar.doma.jdbc.criteria.query.SelectBuilder;
import org.seasar.doma.jdbc.criteria.tuple.Tuple2;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class BuilderSupport {
    private final Config config;
    private final Function<String, String> commenter;
    private final PreparedSqlBuilder buf;
    private final AliasManager aliasManager;
    private final Operand.Visitor<Void> operandVisitor;
    private final PropertyMetamodelVisitor propertyMetamodelVisitor;

    public BuilderSupport(Config config, Function<String, String> commenter, PreparedSqlBuilder buf, AliasManager aliasManager) {
        this.config = Objects.requireNonNull(config);
        this.commenter = Objects.requireNonNull(commenter);
        this.buf = Objects.requireNonNull(buf);
        this.aliasManager = Objects.requireNonNull(aliasManager);
        this.operandVisitor = new OperandVisitor();
        this.propertyMetamodelVisitor = new PropertyMetamodelVisitor();
    }

    public void table(EntityMetamodel<?> entityMetamodel) {
        EntityType<?> entityType = entityMetamodel.asType();
        this.buf.appendSql(entityType.getQualifiedTableName(this.config.getNaming()::apply, this.config.getDialect()::applyQuote));
        this.buf.appendSql(" ");
        String alias = this.getAlias(entityMetamodel);
        this.buf.appendSql(alias);
    }

    public void alias(EntityMetamodel<?> entityMetamodel) {
        String alias = this.getAlias(entityMetamodel);
        this.buf.appendSql(alias);
    }

    public String getAlias(EntityMetamodel<?> entityMetamodel) {
        EntityType<?> entityType = entityMetamodel.asType();
        String alias = this.aliasManager.getAlias(entityMetamodel);
        if (alias == null) {
            throw new DomaException((MessageResource)Message.DOMA6003, entityType.getName());
        }
        return alias;
    }

    public void operand(Operand operand) {
        operand.accept(this.operandVisitor);
    }

    public void column(Operand.Prop prop) {
        this.column(prop.value);
    }

    public void column(PropertyMetamodel<?> propertyMetamodel) {
        propertyMetamodel.accept(this.propertyMetamodelVisitor);
    }

    public void columnWithoutAlias(Operand.Prop prop) {
        this.columnWithoutAlias(prop.value);
    }

    public void columnWithoutAlias(PropertyMetamodel<?> propertyMetamodel) {
        propertyMetamodel.accept(new PropertyMetamodelVisitor(){

            @Override
            protected Optional<String> getAlias(PropertyMetamodel<?> propertyMetamodel) {
                return Optional.empty();
            }
        });
    }

    public void param(Operand.Param param) {
        InParameter<?> parameter = param.createInParameter(this.config);
        this.param(parameter);
    }

    private void param(InParameter<?> parameter) {
        this.buf.appendParameter(parameter);
    }

    public void visitCriterion(int index, Criterion criterion) {
        criterion.accept(new CriterionVisitor(index));
    }

    class PropertyMetamodelVisitor
    implements PropertyMetamodel.Visitor,
    ArithmeticExpression.Visitor,
    StringExpression.Visitor,
    LiteralExpression.Visitor,
    AggregateFunction.Visitor,
    CaseExpression.Visitor,
    SelectExpression.Visitor {
        PropertyMetamodelVisitor() {
        }

        @Override
        public void visit(PropertyMetamodel<?> propertyMetamodel) {
            Optional<String> alias = this.getAlias(propertyMetamodel);
            alias.ifPresent(it -> {
                BuilderSupport.this.buf.appendSql((String)it);
                BuilderSupport.this.buf.appendSql(".");
            });
            EntityPropertyType<?, ?> propertyType = propertyMetamodel.asType();
            BuilderSupport.this.buf.appendSql(propertyType.getColumnName(BuilderSupport.this.config.getNaming()::apply, BuilderSupport.this.config.getDialect()::applyQuote));
        }

        protected Optional<String> getAlias(PropertyMetamodel<?> propertyMetamodel) {
            String alias = BuilderSupport.this.aliasManager.getAlias(propertyMetamodel);
            if (alias == null) {
                throw new DomaException((MessageResource)Message.DOMA6004, propertyMetamodel.getName());
            }
            return Optional.of(alias);
        }

        @Override
        public void visit(ArithmeticExpression.Add<?> add) {
            this.binaryOperator(add.getName(), add.left, add.right);
        }

        @Override
        public void visit(ArithmeticExpression.Sub<?> sub) {
            this.binaryOperator(sub.getName(), sub.left, sub.right);
        }

        @Override
        public void visit(ArithmeticExpression.Mul<?> mul) {
            this.binaryOperator(mul.getName(), mul.left, mul.right);
        }

        @Override
        public void visit(ArithmeticExpression.Div<?> div) {
            this.binaryOperator(div.getName(), div.left, div.right);
        }

        @Override
        public void visit(ArithmeticExpression.Mod<?> mod) {
            if (BuilderSupport.this.config.getDialect().supportsModOperator()) {
                this.binaryOperator(mod.getName(), mod.left, mod.right);
            } else {
                BuilderSupport.this.buf.appendSql("mod(");
                mod.left.accept(BuilderSupport.this.operandVisitor);
                BuilderSupport.this.buf.appendSql(", ");
                mod.right.accept(BuilderSupport.this.operandVisitor);
                BuilderSupport.this.buf.appendSql(")");
            }
        }

        @Override
        public void visit(StringExpression.Concat<?> concat) {
            CriteriaBuilder criteriaBuilder = BuilderSupport.this.config.getDialect().getCriteriaBuilder();
            criteriaBuilder.concat(BuilderSupport.this.buf, () -> {
                Void cfr_ignored_0 = (Void)concat.first.accept(BuilderSupport.this.operandVisitor);
            }, () -> {
                Void cfr_ignored_0 = (Void)concat.second.accept(BuilderSupport.this.operandVisitor);
            });
        }

        @Override
        public void visit(StringExpression.Lower<?> lower) {
            this.oneArgumentFunction(lower.getName(), lower.argument);
        }

        @Override
        public void visit(StringExpression.Ltrim<?> ltrim) {
            this.oneArgumentFunction(ltrim.getName(), ltrim.argument);
        }

        @Override
        public void visit(StringExpression.Rtrim<?> rtrim) {
            this.oneArgumentFunction(rtrim.getName(), rtrim.argument);
        }

        @Override
        public void visit(StringExpression.Trim<?> trim) {
            this.oneArgumentFunction(trim.getName(), trim.argument);
        }

        @Override
        public void visit(StringExpression.Upper<?> upper) {
            this.oneArgumentFunction(upper.getName(), upper.argument);
        }

        @Override
        public void visit(LiteralExpression<?> expression) {
            Wrapper wrapper = expression.asType().createProperty().getWrapper();
            String text = wrapper.accept(BuilderSupport.this.config.getDialect().getSqlLogFormattingVisitor(), new ConvertToLogFormatFunction(), null);
            BuilderSupport.this.buf.appendSql(text);
        }

        @Override
        public void visit(AggregateFunction.Avg<?> avg) {
            this.oneArgumentFunction(avg.getName(), avg.argument());
        }

        @Override
        public void visit(AggregateFunction.AvgAsDouble avg) {
            this.oneArgumentFunction(avg.getName(), avg.argument());
        }

        @Override
        public void visit(AggregateFunction.Count count) {
            BuilderSupport.this.buf.appendSql(count.getName());
            BuilderSupport.this.buf.appendSql("(");
            if (count.distinct) {
                BuilderSupport.this.buf.appendSql("distinct ");
            }
            count.argument().accept(this);
            BuilderSupport.this.buf.appendSql(")");
        }

        @Override
        public void visit(AggregateFunction.Max<?> max) {
            this.oneArgumentFunction(max.getName(), max.argument());
        }

        @Override
        public void visit(AggregateFunction.Min<?> min) {
            this.oneArgumentFunction(min.getName(), min.argument());
        }

        @Override
        public void visit(AggregateFunction.Sum<?> sum) {
            this.oneArgumentFunction(sum.getName(), sum.argument());
        }

        @Override
        public void visit(AggregateFunction.Asterisk asterisk) {
            BuilderSupport.this.buf.appendSql(asterisk.getName());
        }

        @Override
        public void visit(CaseExpression<?> expression) {
            if (expression.criterionList.isEmpty()) {
                expression.otherwise.accept(this);
            } else {
                BuilderSupport.this.buf.appendSql("case");
                expression.criterionList.forEach(pair -> {
                    BuilderSupport.this.buf.appendSql(" when ");
                    Criterion criterion = (Criterion)pair.fst;
                    Operand operand = (Operand)pair.snd;
                    criterion.accept(new CriterionVisitor(0));
                    BuilderSupport.this.buf.appendSql(" then ");
                    operand.accept(BuilderSupport.this.operandVisitor);
                });
                BuilderSupport.this.buf.appendSql(" else ");
                expression.otherwise.accept(this);
                BuilderSupport.this.buf.appendSql(" end");
            }
        }

        @Override
        public void visit(SelectExpression<?> expression) {
            BuilderSupport.this.buf.appendSql("(");
            AliasManager child = new AliasManager(expression.context, BuilderSupport.this.aliasManager);
            SelectBuilder builder = new SelectBuilder(BuilderSupport.this.config, expression.context, BuilderSupport.this.commenter, BuilderSupport.this.buf, child);
            builder.interpret();
            BuilderSupport.this.buf.appendSql(")");
        }

        private void binaryOperator(String operator, Operand left, Operand right) {
            BuilderSupport.this.buf.appendSql("(");
            left.accept(BuilderSupport.this.operandVisitor);
            BuilderSupport.this.buf.appendSql(" " + operator + " ");
            right.accept(BuilderSupport.this.operandVisitor);
            BuilderSupport.this.buf.appendSql(")");
        }

        private void oneArgumentFunction(String name, PropertyMetamodel<?> argument) {
            BuilderSupport.this.buf.appendSql(name);
            BuilderSupport.this.buf.appendSql("(");
            argument.accept(this);
            BuilderSupport.this.buf.appendSql(")");
        }
    }

    private class CriterionVisitor
    implements Criterion.Visitor {
        private final int index;

        public CriterionVisitor(int index) {
            this.index = index;
        }

        @Override
        public void visit(Criterion.Eq c) {
            this.comparison(c.left, c.right, "=");
        }

        @Override
        public void visit(Criterion.Ne c) {
            this.comparison(c.left, c.right, "<>");
        }

        @Override
        public void visit(Criterion.Gt c) {
            this.comparison(c.left, c.right, ">");
        }

        @Override
        public void visit(Criterion.Ge c) {
            this.comparison(c.left, c.right, ">=");
        }

        @Override
        public void visit(Criterion.Lt c) {
            this.comparison(c.left, c.right, "<");
        }

        @Override
        public void visit(Criterion.Le c) {
            this.comparison(c.left, c.right, "<=");
        }

        @Override
        public void visit(Criterion.IsNull c) {
            this.isNull(c.prop);
        }

        @Override
        public void visit(Criterion.IsNotNull c) {
            this.isNotNull(c.prop);
        }

        @Override
        public void visit(Criterion.Like c) {
            this.like(c.left, c.right, c.option, false);
        }

        @Override
        public void visit(Criterion.NotLike c) {
            this.like(c.left, c.right, c.option, true);
        }

        @Override
        public void visit(Criterion.Between c) {
            this.between(c.prop, c.start, c.end);
        }

        @Override
        public void visit(Criterion.In c) {
            this.inSingle(c.left, c.right, false);
        }

        @Override
        public void visit(Criterion.NotIn c) {
            this.inSingle(c.left, c.right, true);
        }

        @Override
        public void visit(Criterion.InSubQuery c) {
            this.inSingleSubQuery(c.left, c.right, false);
        }

        @Override
        public void visit(Criterion.NotInSubQuery c) {
            this.inSingleSubQuery(c.left, c.right, true);
        }

        @Override
        public void visit(Criterion.InTuple2 c) {
            this.inPair(c.left, c.right, false);
        }

        @Override
        public void visit(Criterion.NotInTuple2 c) {
            this.inPair(c.left, c.right, true);
        }

        @Override
        public void visit(Criterion.InTuple2SubQuery c) {
            this.inPairSubQuery(c.left, c.right, false);
        }

        @Override
        public void visit(Criterion.NotInTuple2SubQuery c) {
            this.inPairSubQuery(c.left, c.right, true);
        }

        @Override
        public void visit(Criterion.Exists c) {
            this.exists(c.context, false);
        }

        @Override
        public void visit(Criterion.NotExists c) {
            this.exists(c.context, true);
        }

        @Override
        public void visit(Criterion.And criterion) {
            this.and(criterion.criterionList, this.index);
        }

        @Override
        public void visit(Criterion.Or criterion) {
            this.or(criterion.criterionList, this.index);
        }

        @Override
        public void visit(Criterion.Not criterion) {
            this.not(criterion.criterionList);
        }

        private void comparison(Operand.Prop left, Operand right, String op) {
            BuilderSupport.this.column(left);
            BuilderSupport.this.buf.appendSql(" " + op + " ");
            right.accept(BuilderSupport.this.operandVisitor);
        }

        private void isNull(Operand.Prop prop) {
            BuilderSupport.this.column(prop);
            BuilderSupport.this.buf.appendSql(" is null");
        }

        private void isNotNull(Operand.Prop prop) {
            BuilderSupport.this.column(prop);
            BuilderSupport.this.buf.appendSql(" is not null");
        }

        private void like(Operand.Prop left, CharSequence right, LikeOption option, boolean not) {
            BuilderSupport.this.column(left);
            if (not) {
                BuilderSupport.this.buf.appendSql(" not");
            }
            BuilderSupport.this.buf.appendSql(" like ");
            final String value = right == null ? null : right.toString();
            final ExpressionFunctions functions = BuilderSupport.this.config.getDialect().getExpressionFunctions();
            option.accept(new LikeOption.Visitor(){

                @Override
                public void visit(LikeOption.None none) {
                    this.addParam(value);
                }

                @Override
                public void visit(LikeOption.Escape escape) {
                    this.appendNewValue(functions::escape, escape.escapeChar);
                }

                @Override
                public void visit(LikeOption.Prefix prefix) {
                    this.appendNewValue(functions::prefix, prefix.escapeChar);
                }

                @Override
                public void visit(LikeOption.Infix infix) {
                    this.appendNewValue(functions::infix, infix.escapeChar);
                }

                @Override
                public void visit(LikeOption.Suffix suffix) {
                    this.appendNewValue(functions::suffix, suffix.escapeChar);
                }

                private void appendNewValue(BiFunction<String, Character, String> function, char escapeChar) {
                    String newValue = function.apply(value, Character.valueOf(escapeChar));
                    this.addParam(newValue);
                    BuilderSupport.this.buf.appendSql(" escape '" + escapeChar + "'");
                }

                private void addParam(String value2) {
                    BuilderSupport.this.param(new BasicInParameter(() -> new StringWrapper(value2)));
                }
            });
        }

        private void between(Operand.Prop prop, Operand.Param begin, Operand.Param end) {
            BuilderSupport.this.column(prop);
            BuilderSupport.this.buf.appendSql(" between ");
            BuilderSupport.this.param(begin);
            BuilderSupport.this.buf.appendSql(" and ");
            BuilderSupport.this.param(end);
        }

        private void inSingle(Operand.Prop left, List<Operand.Param> right, boolean not) {
            BuilderSupport.this.column(left);
            if (not) {
                BuilderSupport.this.buf.appendSql(" not");
            }
            BuilderSupport.this.buf.appendSql(" in (");
            if (right.isEmpty()) {
                BuilderSupport.this.buf.appendSql("null");
            } else {
                for (Operand.Param p : right) {
                    BuilderSupport.this.param(p);
                    BuilderSupport.this.buf.appendSql(", ");
                }
                BuilderSupport.this.buf.cutBackSql(2);
            }
            BuilderSupport.this.buf.appendSql(")");
        }

        public void inSingleSubQuery(Operand.Prop left, SelectContext right, boolean not) {
            BuilderSupport.this.column(left);
            if (not) {
                BuilderSupport.this.buf.appendSql(" not");
            }
            BuilderSupport.this.buf.appendSql(" in (");
            AliasManager child = new AliasManager(right, BuilderSupport.this.aliasManager);
            SelectBuilder builder = new SelectBuilder(BuilderSupport.this.config, right, BuilderSupport.this.commenter, BuilderSupport.this.buf, child);
            builder.interpret();
            BuilderSupport.this.buf.appendSql(")");
        }

        private void inPair(Tuple2<Operand.Prop, Operand.Prop> left, List<Tuple2<Operand.Param, Operand.Param>> right, boolean not) {
            BuilderSupport.this.buf.appendSql("(");
            BuilderSupport.this.column(left.getItem1());
            BuilderSupport.this.buf.appendSql(", ");
            BuilderSupport.this.column(left.getItem2());
            BuilderSupport.this.buf.appendSql(")");
            if (not) {
                BuilderSupport.this.buf.appendSql(" not");
            }
            BuilderSupport.this.buf.appendSql(" in (");
            if (right.isEmpty()) {
                BuilderSupport.this.buf.appendSql("null, null");
            } else {
                right.forEach(pair -> {
                    BuilderSupport.this.buf.appendSql("(");
                    BuilderSupport.this.param((Operand.Param)pair.getItem1());
                    BuilderSupport.this.buf.appendSql(", ");
                    BuilderSupport.this.param((Operand.Param)pair.getItem2());
                    BuilderSupport.this.buf.appendSql("), ");
                });
                BuilderSupport.this.buf.cutBackSql(2);
            }
            BuilderSupport.this.buf.appendSql(")");
        }

        private void inPairSubQuery(Tuple2<Operand.Prop, Operand.Prop> left, SelectContext right, boolean not) {
            BuilderSupport.this.buf.appendSql("(");
            BuilderSupport.this.column(left.getItem1());
            BuilderSupport.this.buf.appendSql(", ");
            BuilderSupport.this.column(left.getItem2());
            BuilderSupport.this.buf.appendSql(")");
            if (not) {
                BuilderSupport.this.buf.appendSql(" not");
            }
            BuilderSupport.this.buf.appendSql(" in (");
            AliasManager child = new AliasManager(right, BuilderSupport.this.aliasManager);
            SelectBuilder builder = new SelectBuilder(BuilderSupport.this.config, right, BuilderSupport.this.commenter, BuilderSupport.this.buf, child);
            builder.interpret();
            BuilderSupport.this.buf.appendSql(")");
        }

        public void exists(SelectContext context, boolean not) {
            if (not) {
                BuilderSupport.this.buf.appendSql("not ");
            }
            BuilderSupport.this.buf.appendSql("exists (");
            AliasManager child = new AliasManager(context, BuilderSupport.this.aliasManager);
            SelectBuilder builder = new SelectBuilder(BuilderSupport.this.config, context, BuilderSupport.this.commenter, BuilderSupport.this.buf, child);
            builder.interpret();
            BuilderSupport.this.buf.appendSql(")");
        }

        private void and(List<Criterion> criterionList, int index) {
            this.binaryLogicalOperator(criterionList, index, "and");
        }

        private void or(List<Criterion> criterionList, int index) {
            this.binaryLogicalOperator(criterionList, index, "or");
        }

        private void binaryLogicalOperator(List<Criterion> criterionList, int index, String operator) {
            if (!criterionList.isEmpty()) {
                if (index > 0) {
                    BuilderSupport.this.buf.cutBackSql(5);
                }
                if (index != 0) {
                    BuilderSupport.this.buf.appendSql(" " + operator + " ");
                }
                BuilderSupport.this.buf.appendSql("(");
                int i = 0;
                for (Criterion c : criterionList) {
                    BuilderSupport.this.visitCriterion(i++, c);
                    BuilderSupport.this.buf.appendSql(" and ");
                }
                BuilderSupport.this.buf.cutBackSql(5);
                BuilderSupport.this.buf.appendSql(")");
            }
        }

        private void not(List<Criterion> criterionList) {
            if (!criterionList.isEmpty()) {
                BuilderSupport.this.buf.appendSql("not ");
                BuilderSupport.this.buf.appendSql("(");
                int index = 0;
                for (Criterion c : criterionList) {
                    BuilderSupport.this.visitCriterion(index++, c);
                    BuilderSupport.this.buf.appendSql(" and ");
                }
                BuilderSupport.this.buf.cutBackSql(5);
                BuilderSupport.this.buf.appendSql(")");
            }
        }
    }

    private class OperandVisitor
    implements Operand.Visitor<Void> {
        private OperandVisitor() {
        }

        @Override
        public Void visit(Operand.Param param) {
            BuilderSupport.this.param(param);
            return null;
        }

        @Override
        public Void visit(Operand.Prop prop) {
            BuilderSupport.this.column(prop);
            return null;
        }
    }
}

