/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.criteria.expression;

import java.util.Objects;
import org.seasar.doma.jdbc.criteria.expression.DoublePropertyType;
import org.seasar.doma.jdbc.criteria.expression.LongPropertyType;
import org.seasar.doma.jdbc.criteria.metamodel.PropertyMetamodel;
import org.seasar.doma.jdbc.entity.EntityPropertyType;

public interface AggregateFunction<PROPERTY>
extends PropertyMetamodel<PROPERTY> {
    public static final Asterisk Asterisk = new Asterisk();

    public PropertyMetamodel<?> argument();

    public static interface Visitor {
        public void visit(Avg<?> var1);

        public void visit(AvgAsDouble var1);

        public void visit(Count var1);

        public void visit(Max<?> var1);

        public void visit(Min<?> var1);

        public void visit(Sum<?> var1);

        public void visit(Asterisk var1);
    }

    public static class Asterisk
    implements PropertyMetamodel<Long> {
        private Asterisk() {
        }

        @Override
        public String getName() {
            return "*";
        }

        @Override
        public Class<?> asClass() {
            return Long.class;
        }

        @Override
        public EntityPropertyType<?, ?> asType() {
            return new LongPropertyType(null);
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class Sum<PROPERTY>
    extends AbstractFunction<PROPERTY> {
        public Sum(PropertyMetamodel<PROPERTY> argument) {
            super("sum", argument);
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class Min<PROPERTY>
    extends AbstractFunction<PROPERTY> {
        public Min(PropertyMetamodel<PROPERTY> argument) {
            super("min", argument);
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class Max<PROPERTY>
    extends AbstractFunction<PROPERTY> {
        public Max(PropertyMetamodel<PROPERTY> argument) {
            super("max", argument);
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class Count
    extends AbstractFunction<Long> {
        public final boolean distinct;

        public Count(PropertyMetamodel<?> argument) {
            this(argument, false);
        }

        public Count(PropertyMetamodel<?> argument, boolean distinct) {
            super("count", argument);
            this.distinct = distinct;
        }

        @Override
        public Class<?> asClass() {
            return Long.class;
        }

        @Override
        public EntityPropertyType<?, Long> asType() {
            return new LongPropertyType(null);
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class AvgAsDouble
    extends AbstractFunction<Double> {
        public AvgAsDouble(PropertyMetamodel<?> argument) {
            super("avg", argument);
        }

        @Override
        public Class<?> asClass() {
            return Double.class;
        }

        @Override
        public EntityPropertyType<?, Double> asType() {
            return new DoublePropertyType(null);
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static class Avg<PROPERTY>
    extends AbstractFunction<PROPERTY> {
        public Avg(PropertyMetamodel<PROPERTY> argument) {
            super("avg", argument);
        }

        @Override
        public void accept(PropertyMetamodel.Visitor visitor) {
            if (visitor instanceof Visitor) {
                Visitor v = (Visitor)((Object)visitor);
                v.visit(this);
            }
        }
    }

    public static abstract class AbstractFunction<PROPERTY>
    implements AggregateFunction<PROPERTY> {
        private final String name;
        private final PropertyMetamodel<?> argument;

        protected AbstractFunction(String name, PropertyMetamodel<?> argument) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(argument);
            this.name = name;
            this.argument = argument;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<?> asClass() {
            return this.argument.asClass();
        }

        @Override
        public EntityPropertyType<?, ?> asType() {
            return this.argument.asType();
        }

        @Override
        public PropertyMetamodel<?> argument() {
            return this.argument;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractFunction)) {
                return false;
            }
            AbstractFunction that = (AbstractFunction)o;
            return this.name.equals(that.name) && this.argument.equals(that.argument);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.argument);
        }
    }
}

