/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.scalar;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.Supplier;
import org.seasar.doma.internal.jdbc.scalar.BasicScalar;
import org.seasar.doma.internal.jdbc.scalar.Scalar;
import org.seasar.doma.wrapper.ArrayWrapper;
import org.seasar.doma.wrapper.BigDecimalWrapper;
import org.seasar.doma.wrapper.BigIntegerWrapper;
import org.seasar.doma.wrapper.BlobWrapper;
import org.seasar.doma.wrapper.BooleanWrapper;
import org.seasar.doma.wrapper.ByteWrapper;
import org.seasar.doma.wrapper.BytesWrapper;
import org.seasar.doma.wrapper.ClobWrapper;
import org.seasar.doma.wrapper.DateWrapper;
import org.seasar.doma.wrapper.DoubleWrapper;
import org.seasar.doma.wrapper.EnumWrapper;
import org.seasar.doma.wrapper.FloatWrapper;
import org.seasar.doma.wrapper.IntegerWrapper;
import org.seasar.doma.wrapper.LocalDateTimeWrapper;
import org.seasar.doma.wrapper.LocalDateWrapper;
import org.seasar.doma.wrapper.LocalTimeWrapper;
import org.seasar.doma.wrapper.LongWrapper;
import org.seasar.doma.wrapper.NClobWrapper;
import org.seasar.doma.wrapper.ObjectWrapper;
import org.seasar.doma.wrapper.PrimitiveBooleanWrapper;
import org.seasar.doma.wrapper.PrimitiveByteWrapper;
import org.seasar.doma.wrapper.PrimitiveDoubleWrapper;
import org.seasar.doma.wrapper.PrimitiveFloatWrapper;
import org.seasar.doma.wrapper.PrimitiveIntWrapper;
import org.seasar.doma.wrapper.PrimitiveLongWrapper;
import org.seasar.doma.wrapper.PrimitiveShortWrapper;
import org.seasar.doma.wrapper.SQLXMLWrapper;
import org.seasar.doma.wrapper.ShortWrapper;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.TimeWrapper;
import org.seasar.doma.wrapper.TimestampWrapper;
import org.seasar.doma.wrapper.UtilDateWrapper;

public final class BasicScalarSuppliers {
    public static Supplier<Scalar<Array, Array>> ofArray() {
        return () -> new BasicScalar<Array>(new ArrayWrapper());
    }

    public static Supplier<Scalar<BigDecimal, BigDecimal>> ofBigDecimal() {
        return () -> new BasicScalar<BigDecimal>(new BigDecimalWrapper());
    }

    public static Supplier<Scalar<BigInteger, BigInteger>> ofBigInteger() {
        return () -> new BasicScalar<BigInteger>(new BigIntegerWrapper());
    }

    public static Supplier<Scalar<Blob, Blob>> ofBlob() {
        return () -> new BasicScalar<Blob>(new BlobWrapper());
    }

    public static Supplier<Scalar<Boolean, Boolean>> ofBoolean() {
        return () -> new BasicScalar<Boolean>(new BooleanWrapper());
    }

    public static Supplier<Scalar<Byte, Byte>> ofByte() {
        return () -> new BasicScalar<Byte>(new ByteWrapper());
    }

    public static Supplier<Scalar<byte[], byte[]>> ofBytes() {
        return () -> new BasicScalar<byte[]>(new BytesWrapper());
    }

    public static Supplier<Scalar<Clob, Clob>> ofClob() {
        return () -> new BasicScalar<Clob>(new ClobWrapper());
    }

    public static Supplier<Scalar<Date, Date>> ofDate() {
        return () -> new BasicScalar<Date>(new DateWrapper());
    }

    public static Supplier<Scalar<Double, Double>> ofDouble() {
        return () -> new BasicScalar<Double>(new DoubleWrapper());
    }

    public static <E extends Enum<E>> Supplier<Scalar<E, E>> ofEnum(Class<E> enumClass) {
        return () -> new BasicScalar(new EnumWrapper(enumClass));
    }

    public static Supplier<Scalar<Float, Float>> ofFloat() {
        return () -> new BasicScalar<Float>(new FloatWrapper());
    }

    public static Supplier<Scalar<Integer, Integer>> ofInteger() {
        return () -> new BasicScalar<Integer>(new IntegerWrapper());
    }

    public static Supplier<Scalar<LocalDate, LocalDate>> ofLocalDate() {
        return () -> new BasicScalar<LocalDate>(new LocalDateWrapper());
    }

    public static Supplier<Scalar<LocalDateTime, LocalDateTime>> ofLocalDateTime() {
        return () -> new BasicScalar<LocalDateTime>(new LocalDateTimeWrapper());
    }

    public static Supplier<Scalar<LocalTime, LocalTime>> ofLocalTime() {
        return () -> new BasicScalar<LocalTime>(new LocalTimeWrapper());
    }

    public static Supplier<Scalar<Long, Long>> ofLong() {
        return () -> new BasicScalar<Long>(new LongWrapper());
    }

    public static Supplier<Scalar<NClob, NClob>> ofNClob() {
        return () -> new BasicScalar<NClob>(new NClobWrapper());
    }

    public static Supplier<Scalar<Object, Object>> ofObject() {
        return () -> new BasicScalar<Object>(new ObjectWrapper());
    }

    public static Supplier<Scalar<Boolean, Boolean>> ofPrimitiveBoolean() {
        return () -> new BasicScalar<Boolean>(new PrimitiveBooleanWrapper());
    }

    public static Supplier<Scalar<Byte, Byte>> ofPrimitiveByte() {
        return () -> new BasicScalar<Byte>(new PrimitiveByteWrapper());
    }

    public static Supplier<Scalar<Double, Double>> ofPrimitiveDouble() {
        return () -> new BasicScalar<Double>(new PrimitiveDoubleWrapper());
    }

    public static Supplier<Scalar<Float, Float>> ofPrimitiveFloat() {
        return () -> new BasicScalar<Float>(new PrimitiveFloatWrapper());
    }

    public static Supplier<Scalar<Integer, Integer>> ofPrimitiveInt() {
        return () -> new BasicScalar<Integer>(new PrimitiveIntWrapper());
    }

    public static Supplier<Scalar<Long, Long>> ofPrimitiveLong() {
        return () -> new BasicScalar<Long>(new PrimitiveLongWrapper());
    }

    public static Supplier<Scalar<Short, Short>> ofPrimitiveShort() {
        return () -> new BasicScalar<Short>(new PrimitiveShortWrapper());
    }

    public static Supplier<Scalar<Short, Short>> ofShort() {
        return () -> new BasicScalar<Short>(new ShortWrapper());
    }

    public static Supplier<Scalar<SQLXML, SQLXML>> ofSQLXML() {
        return () -> new BasicScalar<SQLXML>(new SQLXMLWrapper());
    }

    public static Supplier<Scalar<String, String>> ofString() {
        return () -> new BasicScalar<String>(new StringWrapper());
    }

    public static Supplier<Scalar<Time, Time>> ofTime() {
        return () -> new BasicScalar<Time>(new TimeWrapper());
    }

    public static Supplier<Scalar<Timestamp, Timestamp>> ofTimestamp() {
        return () -> new BasicScalar<Timestamp>(new TimestampWrapper());
    }

    public static Supplier<Scalar<java.util.Date, java.util.Date>> ofUtilDate() {
        return () -> new BasicScalar<java.util.Date>(new UtilDateWrapper());
    }
}

