/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.kdtree;

import java.util.Vector;
import jp.kitec.math.searches.kdtree.KdTreeBuilder;
import jp.kitec.math.searches.kdtree.KdTreeNode;
import jp.kitec.math.searches.kdtree.KdTreeRestrictNode;
import jp.kitec.math.searches.kdtree.TreeNodeBase;

public class KdTreeSearch {
    static final int EXCLUDE = 0;
    static final int OVERLAP = 1;
    static final int INCLUDE = 2;
    static final int ARRAY_NUMBER = 100;
    double[] dLeft = new double[100];
    double[] dLower = new double[100];
    double[] dRight = new double[100];
    double[] dUpper = new double[100];
    boolean[] bLeft = new boolean[100];
    boolean[] bLower = new boolean[100];
    boolean[] bRight = new boolean[100];
    boolean[] bUpper = new boolean[100];

    private void resetSearchRegion() {
        this.bUpper[0] = false;
        this.bRight[0] = false;
        this.bLower[0] = false;
        this.bLeft[0] = false;
    }

    public void search(Vector vector, TreeNodeBase treeNodeBase, double d, double d2, double d3, double d4) {
        this.resetSearchRegion();
        this.searchIncludePoints(vector, treeNodeBase, 0, d, d2, d3, d4);
    }

    private void searchIncludePoints(Vector vector, TreeNodeBase treeNodeBase, int n, double d, double d2, double d3, double d4) {
        if (treeNodeBase.isLeafNode()) {
            KdTreeNode kdTreeNode = (KdTreeNode)treeNodeBase;
            int n2 = KdTreeBuilder.equals(d, kdTreeNode.getX());
            if (n2 >= 0) {
                return;
            }
            n2 = KdTreeBuilder.equals(kdTreeNode.getX(), d3);
            if (n2 >= 0) {
                return;
            }
            n2 = KdTreeBuilder.equals(d2, kdTreeNode.getY());
            if (n2 >= 0) {
                return;
            }
            n2 = KdTreeBuilder.equals(kdTreeNode.getY(), d4);
            if (n2 >= 0) {
                return;
            }
            vector.add(kdTreeNode.getNode());
            return;
        }
        KdTreeRestrictNode kdTreeRestrictNode = (KdTreeRestrictNode)treeNodeBase;
        int n3 = this.judge(kdTreeRestrictNode, n, d, d2, d3, d4, true);
        if (n3 == 2) {
            this.putAllNodes(vector, kdTreeRestrictNode);
        } else if (n3 == 1) {
            this.searchIncludePoints(vector, kdTreeRestrictNode.getLeft(), n + 1, d, d2, d3, d4);
        }
        n3 = this.judge(kdTreeRestrictNode, n, d, d2, d3, d4, false);
        if (n3 == 2) {
            this.putAllNodes(vector, kdTreeRestrictNode);
        } else if (n3 == 1) {
            this.searchIncludePoints(vector, kdTreeRestrictNode.getRight(), n + 1, d, d2, d3, d4);
        }
    }

    int judge(KdTreeRestrictNode kdTreeRestrictNode, int n, double d, double d2, double d3, double d4, boolean bl) {
        if (n > 0) {
            this.dLeft[n] = this.dLeft[n - 1];
            this.dLower[n] = this.dLower[n - 1];
            this.dRight[n] = this.dRight[n - 1];
            this.dUpper[n] = this.dUpper[n - 1];
            this.bLeft[n] = this.bLeft[n - 1];
            this.bLower[n] = this.bLower[n - 1];
            this.bRight[n] = this.bRight[n - 1];
            this.bUpper[n] = this.bUpper[n - 1];
        }
        if (n % 2 == 0) {
            if (bl) {
                this.dRight[n] = kdTreeRestrictNode.getValue();
                this.bRight[n] = true;
            } else {
                this.dLeft[n] = kdTreeRestrictNode.getValue();
                this.bLeft[n] = true;
            }
        } else if (bl) {
            this.dUpper[n] = kdTreeRestrictNode.getValue();
            this.bUpper[n] = true;
        } else {
            this.dLower[n] = kdTreeRestrictNode.getValue();
            this.bLower[n] = true;
        }
        if (this.bLeft[n] && KdTreeBuilder.equals(d3, this.dLeft[n]) < 0 || this.bRight[n] && KdTreeBuilder.equals(this.dRight[n], d) < 0 || this.bLower[n] && KdTreeBuilder.equals(d4, this.dLower[n]) < 0 || this.bUpper[n] && KdTreeBuilder.equals(this.dUpper[n], d2) < 0) {
            return 0;
        }
        if (this.bLeft[n] && this.bRight[n] && this.bLower[n] && this.bUpper[n] && KdTreeBuilder.equals(d, this.dLeft[n]) <= 0 && KdTreeBuilder.equals(this.dRight[n], d3) <= 0 && KdTreeBuilder.equals(d2, this.dLower[n]) <= 0 && KdTreeBuilder.equals(this.dUpper[n], d4) <= 0) {
            return 2;
        }
        return 1;
    }

    void putAllNodes(Vector vector, TreeNodeBase treeNodeBase) {
        if (treeNodeBase.isLeafNode()) {
            KdTreeNode kdTreeNode = (KdTreeNode)treeNodeBase;
            vector.add(kdTreeNode.getNode());
            return;
        }
        KdTreeRestrictNode kdTreeRestrictNode = (KdTreeRestrictNode)treeNodeBase;
        if (kdTreeRestrictNode.getLeft() != null) {
            this.putAllNodes(vector, kdTreeRestrictNode.getLeft());
        }
        if (kdTreeRestrictNode.getRight() != null) {
            this.putAllNodes(vector, kdTreeRestrictNode.getRight());
        }
    }
}

