/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.logicaloperation;

import java.util.Vector;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.PolylineEditable;
import jp.kitec.math.geom.datapassing.ToolFigure2D;
import jp.kitec.math.geom.datapassing.ToolFigure2DArc;
import jp.kitec.math.geom.datapassing.ToolFigureType;
import jp.kitec.math.geom.datapassing.ToolGeomFigure2D;
import jp.kitec.math.geom.datapassing.ToolPolyline2D;
import jp.kitec.math.geom.datapassing.ToolPolyline2DCollection;
import jp.kitec.math.geom.datapassing.polylines.ToolGeomPolyline2D;
import jp.kitec.math.geom.logicaloperation.CrossPolylineGroup;
import jp.kitec.math.geom.logicaloperation.IntersectRegionSort;
import jp.kitec.math.geom.logicaloperation.PolylineManager;
import jp.kitec.math.searches.regiontree.RectangleSupplier;

public class LevelCollector {
    public static final double TOLERANCE_DISTANCE = 1.0E-8;
    public static final int FAIL = -1;
    public static final int INIT = 0;
    public static final int NOT_FOUND = 1;
    public static final int NEW_POLYLINE = 2;
    public static final int FIGURE = 3;
    public static final int JOINT = 4;
    public static final int PARENT_POLYGON = 5;
    public static final int CHILD_POLYGON = 6;
    public static final int LESS = 5;
    public static final int EQUAL = 6;
    public static final int GREATER = 7;
    public static final int LESS_EQUAL = 8;
    public static final int GREATER_EQUAL = 9;
    public static final int NOT_EQUAL = 10;
    public static final int OVERLAP_TOP = 11;
    public static final int NONE = 12;
    private ToolPolyline2DCollection collection1 = null;
    private ToolPolyline2DCollection collection2 = null;
    private short level1 = 0;
    private short level2 = 0;
    private int sign1 = 6;
    private int sign2 = 6;
    private double startX = 0.0;
    private double startY = 0.0;
    private int lastStatus = 0;
    private double search_x = 0.0;
    private double search_y = 0.0;
    private double search_xc = 0.0;
    private double search_yc = 0.0;
    private double search_radius = 0.0;
    private int search_type = 0;
    private int search_polygonAttr;
    private int search_fase = 0;
    private boolean markSecondCollection = true;
    private boolean getSurface = false;
    private double[] rect1 = new double[4];
    private double[] rect2 = new double[4];
    private ToolFigure2D search_figure = null;
    private ToolFigure2D search_currentFigure = null;
    private IntersectRegionSort search_intersectLast = null;
    private IntersectRegionSort search_intersectNext = null;
    private boolean search_goForth = true;
    private boolean search_independentPlane = false;
    private CrossPolylineGroup search_group = null;
    private ToolPolyline2DCollection search_collection = null;
    private int search_polyline = 0;
    ToolPolyline2D polylineTmp = null;
    private PolylineManager search_manager = null;
    private IntersectRegionSort search_intersect = null;
    private Vector search_vector = new Vector(10, 10);
    private boolean absLevel = false;

    boolean equalPoints(double d, double d2, double d3, double d4) {
        return Math.abs(d - d3) <= 1.0E-8 && Math.abs(d2 - d4) <= 1.0E-8;
    }

    boolean judgeLevel(int n, int n2, int n3) {
        switch (n3) {
            case 5: {
                return n < n2;
            }
            case 6: 
            case 11: {
                return n == n2;
            }
            case 7: {
                return n > n2;
            }
            case 8: {
                return n <= n2;
            }
            case 9: {
                return n >= n2;
            }
            case 10: {
                return n != n2;
            }
            case 12: {
                return false;
            }
        }
        return false;
    }

    public double getX() {
        return this.search_x;
    }

    public double getY() {
        return this.search_y;
    }

    public double getXC() {
        return this.search_xc;
    }

    public double getYC() {
        return this.search_yc;
    }

    public double getRadius() {
        return this.search_radius;
    }

    public int getType() {
        return this.search_type;
    }

    public byte getRegion() {
        ToolPolyline2D toolPolyline2D = this.search_figure.getParent();
        if (toolPolyline2D instanceof PolylineEditable) {
            byte by = toolPolyline2D.getRegion();
            switch (by) {
                case 0: {
                    return 0;
                }
                case 1: 
                case 3: 
                case 4: {
                    return this.search_goForth ? (byte)1 : 2;
                }
                case 2: {
                    return this.search_goForth ? (byte)2 : 1;
                }
            }
        }
        return 0;
    }

    public int getPolygonAttr() {
        return this.search_polygonAttr;
    }

    public int getOriginal(Object[] objectArray, boolean bl) {
        ToolFigure2D toolFigure2D;
        ToolFigure2D toolFigure2D2;
        if (this.search_currentFigure != null) {
            if (this.search_goForth) {
                if (bl) {
                    objectArray[0] = this.search_currentFigure.getPrev();
                    if (objectArray[0] == null) {
                        ToolFigure2D toolFigure2D3 = (ToolFigure2D)this.search_currentFigure.getParent().lastElement();
                        objectArray[0] = this.equalPoints(this.search_currentFigure.getX1(), this.search_currentFigure.getY1(), toolFigure2D3.getX2(), toolFigure2D3.getY2()) ? toolFigure2D3 : this.search_currentFigure.getParent();
                    }
                } else {
                    objectArray[0] = this.search_currentFigure;
                }
            } else if (bl) {
                objectArray[0] = this.search_currentFigure;
            } else {
                objectArray[0] = this.search_currentFigure.getPrev();
                if (objectArray[0] == null) {
                    ToolFigure2D toolFigure2D4 = (ToolFigure2D)this.search_currentFigure.getParent().lastElement();
                    objectArray[0] = this.equalPoints(this.search_currentFigure.getX1(), this.search_currentFigure.getY1(), toolFigure2D4.getX2(), toolFigure2D4.getY2()) ? toolFigure2D4 : this.search_currentFigure.getParent();
                }
            }
            return 1;
        }
        if (this.search_intersect == null) {
            return 0;
        }
        IntersectRegionSort intersectRegionSort = this.search_intersect.samePointsRoot;
        double d = intersectRegionSort.parameterOfFigure - Math.floor(intersectRegionSort.parameterOfFigure);
        int n = 0;
        if (d == 0.0) {
            toolFigure2D2 = intersectRegionSort.figure;
            toolFigure2D = toolFigure2D2;
            if (this.equalPoints(this.search_intersect.x, this.search_intersect.y, toolFigure2D.getX1(), toolFigure2D.getY1())) {
                toolFigure2D2 = (ToolFigure2D)toolFigure2D.getPrev();
            }
            Object object = objectArray[n++] = toolFigure2D2 != null ? toolFigure2D2 : toolFigure2D.getParent();
        }
        while (intersectRegionSort != null) {
            d = intersectRegionSort.pair.samePointsRoot.parameterOfFigure;
            if (d == Math.floor(d)) {
                toolFigure2D2 = intersectRegionSort.pair.samePointsRoot.figure;
                toolFigure2D = toolFigure2D2;
                if (this.equalPoints(this.search_intersect.x, this.search_intersect.y, toolFigure2D.getX1(), toolFigure2D.getY1())) {
                    toolFigure2D2 = (ToolFigure2D)toolFigure2D.getPrev();
                }
                objectArray[n++] = toolFigure2D2 != null ? toolFigure2D2 : toolFigure2D.getParent();
            }
            intersectRegionSort = intersectRegionSort.samePointsNext;
        }
        return n;
    }

    public void set(ToolPolyline2DCollection toolPolyline2DCollection, int n, short s, boolean bl) {
        this.collection1 = toolPolyline2DCollection;
        this.collection2 = null;
        this.level1 = s;
        this.level2 = (short)-1;
        this.sign1 = n;
        this.sign2 = 0;
        this.lastStatus = 0;
        this.search_polygonAttr = 0;
        this.getSurface = bl;
        this.search_fase = 1;
        this.search_independentPlane = false;
        this.search_collection = this.collection1;
        this.search_polyline = -1;
        this.search_manager = null;
        this.search_intersect = null;
    }

    public void set(ToolPolyline2DCollection toolPolyline2DCollection, ToolPolyline2DCollection toolPolyline2DCollection2, int n, int n2, short s, short s2, boolean bl, boolean bl2) {
        this.collection1 = toolPolyline2DCollection;
        this.collection2 = toolPolyline2DCollection2;
        this.sign1 = n;
        this.sign2 = n2;
        this.level1 = s;
        this.level2 = s2;
        this.lastStatus = 0;
        this.markSecondCollection = bl;
        this.search_polygonAttr = 0;
        this.getSurface = bl2;
        this.search_fase = 2;
        this.search_collection = toolPolyline2DCollection;
        this.search_polyline = -1;
        this.search_manager = null;
        this.search_intersect = null;
    }

    public void or(ToolPolyline2DCollection toolPolyline2DCollection) {
        this.set(toolPolyline2DCollection, 6, (short)0, false);
    }

    public void or(ToolPolyline2DCollection toolPolyline2DCollection, ToolPolyline2DCollection toolPolyline2DCollection2) {
        this.set(toolPolyline2DCollection, toolPolyline2DCollection2, 6, 6, (short)0, (short)0, true, false);
    }

    public void and(ToolPolyline2DCollection toolPolyline2DCollection) {
        this.set(toolPolyline2DCollection, 11, (short)0, false);
    }

    public void and(ToolPolyline2DCollection toolPolyline2DCollection, ToolPolyline2DCollection toolPolyline2DCollection2) {
        this.set(toolPolyline2DCollection, toolPolyline2DCollection2, 11, 11, (short)0, (short)0, true, false);
    }

    public void sub(ToolPolyline2DCollection toolPolyline2DCollection, ToolPolyline2DCollection toolPolyline2DCollection2) {
        this.set(toolPolyline2DCollection, toolPolyline2DCollection2, 6, 9, (short)0, (short)1, true, true);
    }

    public void cut(ToolPolyline2DCollection toolPolyline2DCollection, ToolPolyline2DCollection toolPolyline2DCollection2) {
        this.set(toolPolyline2DCollection, toolPolyline2DCollection2, 6, 9, (short)0, (short)1, false, true);
    }

    public int findNext() {
        return this.findNext(true, true);
    }

    private int findNext(boolean bl, boolean bl2) {
        if (this.lastStatus == 0 || this.lastStatus == -1) {
            if (bl2) {
                return this.search(bl);
            }
            return -1;
        }
        if (this.search_independentPlane) {
            if (this.search_figure == null) {
                this.search_independentPlane = false;
                this.search_manager = null;
                return this.search(bl);
            }
            this.search_x = this.search_figure.getX2();
            this.search_y = this.search_figure.getY2();
            this.search_type = this.search_figure.getType();
            if (this.search_type == 2 || this.search_type == 3) {
                ToolFigure2DArc toolFigure2DArc = (ToolFigure2DArc)this.search_figure;
                this.search_xc = toolFigure2DArc.getCX();
                this.search_yc = toolFigure2DArc.getCY();
                this.search_radius = toolFigure2DArc.getRadius();
            }
            this.lastStatus = 3;
            this.search_currentFigure = this.search_figure;
            this.search_figure = ToolGeomFigure2D.getNext(this.search_figure);
            return 3;
        }
        if (this.search_intersectNext != null && this.lastStatus == 2 && this.search_figure == this.search_intersectNext.figure && (this.search_intersectLast == null || this.search_goForth && this.search_intersectLast.parameterOfFigure < this.search_intersectNext.parameterOfFigure || !this.search_goForth && this.search_intersectLast.parameterOfFigure > this.search_intersectNext.parameterOfFigure)) {
            this.search_x = this.search_intersectNext.x;
            this.search_y = this.search_intersectNext.y;
            this.search_type = this.search_goForth ? this.search_figure.getType() : ToolFigureType.getReverseType(this.search_figure.getType());
            this.search_currentFigure = null;
            if (this.search_type == 2 || this.search_type == 3) {
                ToolFigure2DArc toolFigure2DArc = (ToolFigure2DArc)this.search_figure;
                this.search_xc = toolFigure2DArc.getCX();
                this.search_yc = toolFigure2DArc.getCY();
                this.search_radius = toolFigure2DArc.getRadius();
            }
            this.searchAtIntersect(bl);
            return 3;
        }
        if (this.search_intersectNext != null && (this.search_figure == this.search_intersectNext.figure && (this.search_intersectLast != null && this.search_intersectLast.figure != this.search_intersectNext.figure || this.search_goForth && (this.search_intersectLast == null || this.search_intersectLast.parameterOfFigure < this.search_intersectNext.parameterOfFigure) || this.search_goForth && this.equalPoints(this.search_x, this.search_y, this.search_figure.getX1(), this.search_figure.getY1()) || !this.search_goForth && (this.search_intersectLast == null || this.search_intersectLast.parameterOfFigure > this.search_intersectNext.parameterOfFigure) || !this.search_goForth && this.equalPoints(this.search_x, this.search_y, this.search_figure.getX2(), this.search_figure.getY2())) || this.search_goForth && this.equalPoints(this.search_figure.getX2(), this.search_figure.getY2(), this.search_intersectNext.x, this.search_intersectNext.y) || !this.search_goForth && this.equalPoints(this.search_figure.getX1(), this.search_figure.getY1(), this.search_intersectNext.x, this.search_intersectNext.y))) {
            this.search_x = this.search_intersectNext.x;
            this.search_y = this.search_intersectNext.y;
            this.search_type = this.search_goForth ? this.search_figure.getType() : ToolFigureType.getReverseType(this.search_figure.getType());
            this.search_currentFigure = null;
            if (this.search_type == 2 || this.search_type == 3) {
                ToolFigure2DArc toolFigure2DArc = (ToolFigure2DArc)this.search_figure;
                this.search_xc = toolFigure2DArc.getCX();
                this.search_yc = toolFigure2DArc.getCY();
                this.search_radius = toolFigure2DArc.getRadius();
            }
            this.searchAtIntersect(bl);
            return 3;
        }
        if (this.search_goForth) {
            this.search_x = this.search_figure.getX2();
            this.search_y = this.search_figure.getY2();
            this.search_type = this.search_figure.getType();
            if (this.search_type == 2 || this.search_type == 3) {
                ToolFigure2DArc toolFigure2DArc = (ToolFigure2DArc)this.search_figure;
                this.search_xc = toolFigure2DArc.getCX();
                this.search_yc = toolFigure2DArc.getCY();
                this.search_radius = toolFigure2DArc.getRadius();
            }
            this.search_currentFigure = this.search_figure;
            ToolPolyline2D toolPolyline2D = this.search_figure.getParent();
            ToolFigure2D toolFigure2D = ToolGeomFigure2D.getNext(this.search_figure);
            this.search_figure = ToolGeomPolyline2D.isClosed(toolPolyline2D) ? (toolFigure2D == null ? (ToolFigure2D)this.search_figure.getParent().firstElement() : ToolGeomFigure2D.getNext(this.search_figure)) : ToolGeomFigure2D.getNext(this.search_figure);
        } else {
            this.search_x = this.search_figure.getX1();
            this.search_y = this.search_figure.getY1();
            this.search_type = ToolFigureType.getReverseType(this.search_figure.getType());
            if (this.search_type == 2 || this.search_type == 3) {
                ToolFigure2DArc toolFigure2DArc = (ToolFigure2DArc)this.search_figure;
                this.search_xc = toolFigure2DArc.getCX();
                this.search_yc = toolFigure2DArc.getCY();
                this.search_radius = toolFigure2DArc.getRadius();
            }
            this.search_currentFigure = this.search_figure;
            ToolPolyline2D toolPolyline2D = this.search_figure.getParent();
            ToolFigure2D toolFigure2D = (ToolFigure2D)this.search_figure.getPrev();
            this.search_figure = ToolGeomPolyline2D.isClosed(toolPolyline2D) ? (toolFigure2D == null ? (ToolFigure2D)this.search_figure.getParent().lastElement() : (ToolFigure2D)this.search_figure.getPrev()) : (ToolFigure2D)this.search_figure.getPrev();
        }
        if (this.search_figure == null) {
            this.search_intersectNext = null;
            this.search_intersectLast = null;
            this.lastStatus = -1;
            return 3;
        }
        this.lastStatus = 3;
        return 3;
    }

    int search(boolean bl) {
        ToolPolyline2DCollection toolPolyline2DCollection = null;
        boolean bl2 = this.sign1 == 11 || this.sign2 == 11;
        boolean bl3 = false;
        while (this.search_fase > 0) {
            block1: while (true) {
                int n;
                if (this.search_intersect != null) {
                    if (this.search_intersect != null) {
                        toolPolyline2DCollection = this.search_intersect.figure.getParent().getParent();
                    }
                    IntersectRegionSort intersectRegionSort = IntersectRegionSort.getPrevNode(this.search_intersect, false);
                    if (!bl2) {
                        n = ToolGeomPolyline2D.isClosed(this.search_intersect.figure.getParent()) ? 1 : 0;
                        if (!this.search_intersect.flag && n == 1 && (this.getSurface || this.search_intersect.getSurfaceCount() == 0) && (this.collection1 == toolPolyline2DCollection && this.judgeLevel(this.search_intersect.getLevel(this.absLevel), this.level1, this.sign1) || this.collection2 == toolPolyline2DCollection && this.judgeLevel(this.search_intersect.getLevel(this.absLevel), this.level2, this.sign2))) {
                            this.search_polygonAttr = this.search_polygonAttr == 0 ? 5 : 6;
                            this.lastStatus = 2;
                            this.startX = this.search_x = this.search_intersect.x;
                            this.startY = this.search_y = this.search_intersect.y;
                            this.search_intersectLast = this.search_intersect;
                            if (this.search_collection == this.collection1 || this.markSecondCollection) {
                                this.search_intersect.flag = bl;
                            }
                            this.search_type = 6;
                            this.search_goForth = true;
                            this.search_currentFigure = null;
                            this.search_figure = this.search_intersect.figure;
                            this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersect, true);
                            return 2;
                        }
                        if (n == 0 && (this.getSurface || this.search_intersect.getSurfaceCount() == 0)) {
                            int n2 = 0;
                            int n3 = 0;
                            IntersectRegionSort intersectRegionSort2 = this.search_intersect.samePointsRoot;
                            while (intersectRegionSort2 != null) {
                                if (intersectRegionSort2.crossPrevStatus == 1 && intersectRegionSort2.crossStatus == 2) {
                                    ++n2;
                                } else if (intersectRegionSort2.crossPrevStatus == 2 && intersectRegionSort2.crossStatus == 1 || intersectRegionSort2.crossPrevStatus == 2 && intersectRegionSort2.crossStatus == 0) {
                                    --n2;
                                }
                                intersectRegionSort2 = intersectRegionSort2.samePointsNext;
                            }
                            if (intersectRegionSort != null) {
                                intersectRegionSort2 = intersectRegionSort.samePointsRoot;
                                while (intersectRegionSort2 != null) {
                                    if (intersectRegionSort2.crossPrevStatus == 1 && intersectRegionSort2.crossStatus == 2) {
                                        ++n3;
                                    } else if (intersectRegionSort2.crossPrevStatus == 2 && intersectRegionSort2.crossStatus == 1 || intersectRegionSort2.crossPrevStatus == 2 && intersectRegionSort2.crossStatus == 0) {
                                        --n3;
                                    }
                                    intersectRegionSort2 = intersectRegionSort2.samePointsNext;
                                }
                            }
                            if (!this.search_intersect.flag && (this.collection1 == toolPolyline2DCollection && this.judgeLevel(this.search_intersect.getLevel(this.absLevel), this.level1, this.sign1) || this.collection2 == toolPolyline2DCollection && this.judgeLevel(this.search_intersect.getLevel(this.absLevel), this.level2, this.sign2)) && (bl3 && this.search_intersect.crossPrevStatus == 0 || this.search_intersect.crossPrevStatus == 2 && this.search_intersect.crossStatus == 0 || !ToolGeom2D.equalPoints(this.search_intersect.x, this.search_intersect.y, this.search_intersect.figure.getX2(), this.search_intersect.figure.getY2()) || this.search_intersect.figure.getNext() != null)) {
                                this.search_polygonAttr = this.search_polygonAttr == 0 ? 5 : 6;
                                this.lastStatus = 2;
                                this.search_intersectLast = this.search_intersect;
                                if (this.search_collection == this.collection1 || this.markSecondCollection) {
                                    this.search_intersect.flag = bl;
                                }
                                this.search_type = 6;
                                this.search_goForth = true;
                                this.search_currentFigure = null;
                                if (bl3 && this.search_intersect.crossPrevStatus == 0 || this.search_intersect.crossPrevStatus == 2 && this.search_intersect.crossStatus == 0 || this.search_intersect.crossPrevStatus == 0 && this.search_intersect.crossStatus == 0) {
                                    this.search_figure = (ToolFigure2D)this.polylineTmp.firstElement();
                                    this.startX = this.search_x = this.search_figure.getX1();
                                    this.startY = this.search_y = this.search_figure.getY1();
                                } else {
                                    this.search_figure = this.search_intersect.figure;
                                    this.startX = this.search_x = this.search_intersect.x;
                                    this.startY = this.search_y = this.search_intersect.y;
                                }
                                this.search_intersectNext = this.search_intersect;
                                do {
                                    this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersectNext, false);
                                    if (this.search_intersectNext == null || this.search_collection != this.collection1 && !this.markSecondCollection) continue;
                                    this.search_intersectNext.flag = bl;
                                } while (this.search_intersectNext != null && this.search_intersectNext.crossPrevStatus == this.search_intersectNext.crossStatus);
                                if (this.search_intersectNext != null && (this.search_collection == this.collection1 || this.markSecondCollection)) {
                                    this.search_intersectNext.flag = bl;
                                }
                                return 2;
                            }
                            if (intersectRegionSort == null && !this.search_intersect.flag && (this.collection1 == toolPolyline2DCollection && this.judgeLevel(this.search_intersect.getLevel(this.absLevel) + n2, this.level1, this.sign1) || this.collection2 == toolPolyline2DCollection && this.judgeLevel(this.search_intersect.getLevel(this.absLevel) + n2, this.level2, this.sign2)) || intersectRegionSort != null && !intersectRegionSort.flag && (this.collection1 == toolPolyline2DCollection && this.judgeLevel(intersectRegionSort.getLevel(this.absLevel) + n3, this.level1, this.sign1) || this.collection2 == toolPolyline2DCollection && this.judgeLevel(intersectRegionSort.getLevel(this.absLevel) + n3, this.level2, this.sign2))) {
                                this.search_polygonAttr = this.search_polygonAttr == 0 ? 5 : 6;
                                this.lastStatus = 2;
                                this.search_intersectNext = this.search_intersect;
                                do {
                                    this.search_intersect = IntersectRegionSort.getPrevNode(this.search_intersect, false);
                                    if (this.search_intersect == null || this.search_collection != this.collection1 && !this.markSecondCollection) continue;
                                    this.search_intersect.flag = bl;
                                } while (this.search_intersect != null && this.search_intersect.crossPrevStatus == this.search_intersect.crossStatus);
                                if (this.search_intersect == null) {
                                    this.search_intersect = this.search_intersectNext;
                                    this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersect, false);
                                    this.startX = this.search_x = this.polylineTmp.getFirstX();
                                    this.startY = this.search_y = this.polylineTmp.getFirstY();
                                    this.search_figure = this.search_currentFigure = (ToolFigure2D)this.polylineTmp.firstElement();
                                } else {
                                    this.startX = this.search_x = this.search_intersect.x;
                                    this.startY = this.search_y = this.search_intersect.y;
                                    this.search_figure = this.search_intersect.figure;
                                }
                                this.search_intersectLast = this.search_intersect;
                                this.search_type = 6;
                                this.search_goForth = true;
                                if (this.search_intersect != null && (this.search_collection == this.collection1 || this.markSecondCollection)) {
                                    this.search_intersect.flag = bl;
                                }
                                return 2;
                            }
                        }
                    } else if (!this.search_intersect.flag && this.search_intersect.getLevel(this.absLevel) > 0 && (this.getSurface || this.search_intersect.getSurfaceCount() == 0)) {
                        if (!this.checkOpenPolyline(false)) {
                            this.checkOpenPolyline(true);
                        } else if (!this.doesIncludeOthers()) {
                            this.search_polygonAttr = this.search_polygonAttr == 0 ? 5 : 6;
                            this.level1 = this.level2 = this.search_intersect.getLevel(this.absLevel);
                            this.lastStatus = 2;
                            this.startX = this.search_x = this.search_intersect.x;
                            this.startY = this.search_y = this.search_intersect.y;
                            this.search_intersectLast = this.search_intersect;
                            if (this.search_collection == this.collection1 || this.markSecondCollection) {
                                this.search_intersect.flag = bl;
                            }
                            this.search_type = 6;
                            this.search_goForth = true;
                            this.search_currentFigure = null;
                            this.search_figure = this.search_intersect.figure;
                            this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersect, true);
                            return 2;
                        }
                    }
                    this.search_intersect = this.search_manager.getNext();
                    continue;
                }
                if (this.search_manager != null && this.search_manager.size() == 0 && (!bl2 || bl2 && !this.search_manager.checkIncludeInnerRegionPlane())) {
                    n = this.search_manager.getIncludedLevel();
                    if (!(this.search_manager.getPolyline().getRegion() != 3 && this.search_manager.getPolyline().getRegion() != 4 || this.search_manager.isRegionInside())) {
                        --n;
                    }
                    if (bl2 && n > 0 || !bl2 && (this.search_collection == this.collection1 && this.judgeLevel(n, this.level1, this.sign1) || this.search_collection == this.collection2 && this.judgeLevel(n, this.level2, this.sign2))) {
                        this.search_polygonAttr = this.search_polygonAttr == 0 ? 5 : 6;
                        this.search_independentPlane = true;
                        this.polylineTmp = this.search_collection.get(this.search_polyline);
                        this.search_currentFigure = this.search_figure = (ToolFigure2D)this.polylineTmp.firstElement();
                        this.startX = this.search_x = this.search_figure.getX1();
                        this.startY = this.search_y = this.search_figure.getY1();
                        this.search_type = 6;
                        this.lastStatus = 2;
                        return 2;
                    }
                }
                if (this.search_group != null) {
                    this.polylineTmp = this.search_group.next();
                    if (this.polylineTmp == null) {
                        this.search_group = null;
                    } else {
                        this.search_manager = (PolylineManager)this.polylineTmp.get(4096);
                        this.search_group = this.search_manager.getGroup();
                    }
                }
                if (this.search_group == null) {
                    do {
                        ++this.search_polyline;
                        if (this.search_polyline >= this.search_collection.size()) break block1;
                        this.polylineTmp = this.search_collection.get(this.search_polyline);
                        this.search_manager = (PolylineManager)this.polylineTmp.get(4096);
                        if (bl2 && this.search_group != this.search_manager.getGroup() && this.search_manager.getGroup() != null) {
                            this.getOverlapTop(this.search_manager.getGroup());
                        }
                        this.search_group = this.search_manager.getGroup();
                    } while (this.search_group != null && this.search_group.getFirst() != this.polylineTmp);
                    this.search_polygonAttr = 0;
                }
                if (!bl2 && this.search_group != null && this.search_group.getFirst() == this.polylineTmp) {
                    this.search_group.iterFirst();
                    this.search_intersect = this.search_group.outerMostPoint;
                    continue;
                }
                bl3 = true;
                this.search_intersect = this.search_manager.getFirst();
            }
            --this.search_fase;
            this.search_collection = this.collection2;
            this.search_polyline = -1;
            this.search_manager = null;
            this.search_intersect = null;
        }
        this.search_figure = null;
        this.search_intersectNext = null;
        this.search_intersectLast = null;
        this.lastStatus = -1;
        return -1;
    }

    void getOverlapTop(CrossPolylineGroup crossPolylineGroup) {
        ToolPolyline2D toolPolyline2D = crossPolylineGroup.iterFirst();
        while (toolPolyline2D != null) {
            PolylineManager polylineManager = (PolylineManager)toolPolyline2D.get(4096);
            IntersectRegionSort intersectRegionSort = polylineManager.getFirst();
            IntersectRegionSort intersectRegionSort2 = IntersectRegionSort.getPrevNode(intersectRegionSort, true);
            while (intersectRegionSort2 != intersectRegionSort && intersectRegionSort2.getLevel(this.absLevel) == intersectRegionSort.getLevel(this.absLevel)) {
                intersectRegionSort2 = IntersectRegionSort.getPrevNode(intersectRegionSort2, true);
            }
            IntersectRegionSort intersectRegionSort3 = IntersectRegionSort.getPrevNode(intersectRegionSort2, true);
            while (intersectRegionSort3 != intersectRegionSort && intersectRegionSort3.getLevel(this.absLevel) == intersectRegionSort2.getLevel(this.absLevel)) {
                intersectRegionSort3 = IntersectRegionSort.getPrevNode(intersectRegionSort3, true);
            }
            while (intersectRegionSort != null) {
                if (!(intersectRegionSort2.flag || !this.getSurface && intersectRegionSort2.getSurfaceCount() != 0 || intersectRegionSort2.getLevel(this.absLevel) != intersectRegionSort.getLevel(this.absLevel) && intersectRegionSort3.getLevel(this.absLevel) < intersectRegionSort2.getLevel(this.absLevel) && intersectRegionSort2.getLevel(this.absLevel) > intersectRegionSort.getLevel(this.absLevel))) {
                    IntersectRegionSort intersectRegionSort4 = intersectRegionSort2;
                    while (intersectRegionSort4 != intersectRegionSort) {
                        if (this.search_collection == this.collection1 || this.markSecondCollection) {
                            intersectRegionSort4.flag = true;
                        }
                        intersectRegionSort4 = IntersectRegionSort.getNextNode(intersectRegionSort4, true);
                    }
                }
                if (intersectRegionSort2.getLevel(this.absLevel) != intersectRegionSort.getLevel(this.absLevel)) {
                    intersectRegionSort3 = intersectRegionSort2;
                    intersectRegionSort2 = intersectRegionSort;
                }
                intersectRegionSort = polylineManager.getNext();
            }
            toolPolyline2D = crossPolylineGroup.next();
        }
    }

    boolean checkOpenPolyline(boolean bl) {
        IntersectRegionSort intersectRegionSort = this.search_intersect;
        double d = intersectRegionSort.x;
        double d2 = intersectRegionSort.y;
        double d3 = 0.0;
        double d4 = 0.0;
        this.search_intersectNext = this.search_intersect;
        this.search_goForth = true;
        if (bl) {
            intersectRegionSort.flag = bl;
        }
        this.level1 = this.level2 = intersectRegionSort.getLevel(this.absLevel);
        int n = 0;
        while (this.searchAtIntersect(bl) != -1) {
            if (this.equalPoints(d, d2, this.search_intersectNext.x, this.search_intersectNext.y)) {
                this.search_intersect = intersectRegionSort;
                return true;
            }
            ++n;
        }
        this.search_intersect = intersectRegionSort;
        return false;
    }

    boolean doesIncludeOthers() {
        this.lastStatus = 2;
        double d = this.search_x = this.search_intersect.x;
        this.startX = this.search_x;
        double d2 = this.search_y = this.search_intersect.y;
        this.startY = this.search_y;
        this.search_intersectLast = this.search_intersect;
        this.search_type = 6;
        this.search_goForth = true;
        this.search_currentFigure = null;
        this.search_figure = this.search_intersect.figure;
        this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersect, true);
        int n = 0;
        while (this.findNext(false, false) != -1) {
            if (ToolFigureType.isLine(this.getType())) {
                ToolGeom2D.getFitRectangle(this.rect2, d, d2, this.getX(), this.getY());
            } else if (ToolFigureType.isArc(this.getType())) {
                ToolGeom2D.getFitRectangle(this.rect2, d, d2, this.getX(), this.getY(), this.getXC(), this.getYC(), this.getRadius(), this.getType() == 2);
            }
            d = this.getX();
            d2 = this.getY();
            if (n == 0) {
                this.startX = d;
                this.startY = d2;
                this.rect1[0] = this.rect2[0];
                this.rect1[1] = this.rect2[1];
                this.rect1[2] = this.rect2[2];
                this.rect1[3] = this.rect2[3];
            } else {
                ToolGeom2D.getFitRectangleOr(this.rect1, this.rect1[0], this.rect1[1], this.rect1[2], this.rect1[3], this.rect2[0], this.rect2[1], this.rect2[2], this.rect2[3]);
            }
            if (this.equalPoints(this.startX, this.startY, d, d2)) break;
            ++n;
        }
        this.search_vector.clear();
        ToolGeomPolyline2D.search(this.search_vector, this.collection1, this.rect1[0], this.rect1[1], this.rect1[2], this.rect1[3]);
        for (int i = 0; i < this.search_vector.size(); ++i) {
            double d3;
            double d4;
            int n2;
            RectangleSupplier rectangleSupplier;
            CrossPolylineGroup crossPolylineGroup;
            ToolPolyline2D toolPolyline2D = (ToolPolyline2D)this.search_vector.get(i);
            PolylineManager polylineManager = (PolylineManager)toolPolyline2D.get(4096);
            if (this.search_manager == polylineManager || (crossPolylineGroup = polylineManager.getGroup()) != null && crossPolylineGroup.getFirst() != toolPolyline2D) continue;
            if (crossPolylineGroup != null && crossPolylineGroup.regionInside) {
                return false;
            }
            RectangleSupplier rectangleSupplier2 = rectangleSupplier = toolPolyline2D instanceof RectangleSupplier ? (RectangleSupplier)((Object)toolPolyline2D) : null;
            if (rectangleSupplier != null && (ToolGeom2D.compareDistance(rectangleSupplier.getLeft(), this.rect1[0]) < 0 || ToolGeom2D.compareDistance(rectangleSupplier.getLower(), this.rect1[1]) < 0 || ToolGeom2D.compareDistance(rectangleSupplier.getRight(), this.rect1[2]) > 0 || ToolGeom2D.compareDistance(rectangleSupplier.getUpper(), this.rect1[3]) > 0) || (n2 = this.determinatePoint(d4 = crossPolylineGroup != null ? crossPolylineGroup.x : ((ToolFigure2D)toolPolyline2D.firstElement()).getX1(), d3 = crossPolylineGroup != null ? crossPolylineGroup.y : ((ToolFigure2D)toolPolyline2D.firstElement()).getY1())) != 3) continue;
            return true;
        }
        return false;
    }

    int determinatePoint(double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        this.lastStatus = 2;
        double d5 = this.search_x = this.search_intersect.x;
        this.startX = this.search_x;
        double d6 = this.search_y = this.search_intersect.y;
        this.startY = this.search_y;
        this.search_intersectLast = this.search_intersect;
        this.search_type = 6;
        this.search_goForth = true;
        this.search_currentFigure = null;
        this.search_figure = this.search_intersect.figure;
        this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersect, true);
        d5 = this.getX();
        d6 = this.getY();
        this.findNext(false, false);
        double d7 = Math.atan2(d6 - d2, d5 - d);
        int n = 0;
        while (this.findNext(false, false) != -1) {
            double d8;
            d4 = Math.atan2(this.getY() - d2, this.getX() - d);
            if (this.equalPoints(d5, d6, this.getX(), this.getY())) {
                return 5;
            }
            if (this.getType() == 1) {
                d8 = d4 - d7;
                if (d8 < -Math.PI) {
                    d8 += Math.PI * 2;
                } else if (d8 > Math.PI) {
                    d8 -= Math.PI * 2;
                }
                if (Math.abs(Math.abs(d8) - Math.PI) <= 1.0E-8) {
                    return 5;
                }
            } else if (this.getType() == 2 || this.getType() == 3) {
                double d9 = ToolGeom2D.getDistance(this.getXC(), this.getYC(), d, d2);
                if (d9 < this.getRadius()) {
                    d8 = this.getType() == 2 && d7 < d4 ? d4 - d7 - Math.PI * 2 : (this.getType() == 3 && d7 > d4 ? Math.PI * 2 - d7 - d4 : d4 - d7);
                } else {
                    d8 = d4 - d7;
                    if (d8 < -Math.PI) {
                        d8 += Math.PI * 2;
                    } else if (d8 > Math.PI) {
                        d8 -= Math.PI * 2;
                    }
                }
            } else {
                return 0;
            }
            d3 += d8;
            if (this.equalPoints(this.startX, this.startY, this.getX(), this.getY())) break;
            d5 = this.getX();
            d6 = this.getY();
            ++n;
            d7 = d4;
        }
        if (Math.abs(d3) > 5.654866776461628) {
            return 3;
        }
        if (Math.abs(d3) <= 0.01) {
            return 4;
        }
        return 0;
    }

    int searchAtIntersect(boolean bl) {
        IntersectRegionSort intersectRegionSort = this.search_intersectNext.samePointsRoot;
        ToolPolyline2DCollection toolPolyline2DCollection = intersectRegionSort.figure.getParent().getParent();
        this.search_currentFigure = null;
        if (this.equalPoints(this.startX, this.startY, intersectRegionSort.x, intersectRegionSort.y)) {
            intersectRegionSort = null;
        } else {
            if (!intersectRegionSort.flag && (this.getSurface || intersectRegionSort.getSurfaceCount() == 0) && intersectRegionSort != this.search_intersectLast && (toolPolyline2DCollection == this.collection1 && this.judgeLevel(intersectRegionSort.getLevel(this.absLevel), this.level1, this.sign1) || toolPolyline2DCollection == this.collection2 && this.judgeLevel(intersectRegionSort.getLevel(this.absLevel), this.level2, this.sign2))) {
                this.search_goForth = true;
                this.lastStatus = 3;
                this.search_figure = intersectRegionSort.figure;
                this.search_intersectLast = intersectRegionSort;
                if (toolPolyline2DCollection == this.collection1 || this.markSecondCollection) {
                    this.search_intersectLast.flag = bl;
                }
                this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersectLast, true);
                return 3;
            }
            IntersectRegionSort intersectRegionSort2 = IntersectRegionSort.getPrevNode(intersectRegionSort, true);
            if (!intersectRegionSort2.flag && (this.getSurface || intersectRegionSort2.getSurfaceCount() == 0) && intersectRegionSort2 != this.search_intersectLast && (toolPolyline2DCollection == this.collection1 && this.judgeLevel(intersectRegionSort2.getLevel(this.absLevel), this.level1, this.sign1) || toolPolyline2DCollection == this.collection2 && this.judgeLevel(intersectRegionSort2.getLevel(this.absLevel), this.level2, this.sign2))) {
                this.search_goForth = false;
                this.lastStatus = 3;
                this.search_figure = intersectRegionSort.figure;
                if (this.equalPoints(this.search_x, this.search_y, this.search_figure.getX1(), this.search_figure.getY1())) {
                    this.search_figure = this.search_figure.getPrev() == null ? (ToolFigure2D)this.search_figure.getParent().lastElement() : (ToolFigure2D)this.search_figure.getPrev();
                }
                this.search_intersectLast = intersectRegionSort;
                this.search_intersectNext = intersectRegionSort2;
                if (toolPolyline2DCollection == this.collection1 || this.markSecondCollection) {
                    this.search_intersectNext.flag = bl;
                }
                return 3;
            }
        }
        while (intersectRegionSort != null) {
            IntersectRegionSort intersectRegionSort3 = intersectRegionSort.pair.samePointsRoot;
            toolPolyline2DCollection = intersectRegionSort3.figure.getParent().getParent();
            if (!intersectRegionSort3.flag && (this.getSurface || intersectRegionSort3.getSurfaceCount() == 0) && intersectRegionSort3 != this.search_intersectLast && intersectRegionSort3 != this.search_intersectNext && (toolPolyline2DCollection == this.collection1 && this.judgeLevel(intersectRegionSort3.getLevel(this.absLevel), this.level1, this.sign1) || toolPolyline2DCollection == this.collection2 && this.judgeLevel(intersectRegionSort3.getLevel(this.absLevel), this.level2, this.sign2))) {
                this.search_goForth = true;
                this.lastStatus = 3;
                this.search_figure = intersectRegionSort3.figure;
                if (this.equalPoints(this.search_x, this.search_y, this.search_figure.getX2(), this.search_figure.getY2())) {
                    this.search_figure = ToolGeomFigure2D.getNext(this.search_figure) == null ? (ToolFigure2D)this.search_figure.getParent().firstElement() : ToolGeomFigure2D.getNext(this.search_figure);
                }
                this.search_intersectLast = intersectRegionSort3;
                this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersectLast, true);
                if (toolPolyline2DCollection == this.collection1 || this.markSecondCollection) {
                    this.search_intersectLast.flag = bl;
                }
                return 3;
            }
            IntersectRegionSort intersectRegionSort4 = IntersectRegionSort.getPrevNode(intersectRegionSort3, true);
            if (!intersectRegionSort4.flag && (this.getSurface || intersectRegionSort4.getSurfaceCount() == 0) && intersectRegionSort4 != this.search_intersectLast && intersectRegionSort4 != this.search_intersectNext && (toolPolyline2DCollection == this.collection1 && this.judgeLevel(intersectRegionSort4.getLevel(this.absLevel), this.level1, this.sign1) || toolPolyline2DCollection == this.collection2 && this.judgeLevel(intersectRegionSort4.getLevel(this.absLevel), this.level2, this.sign2))) {
                this.search_goForth = false;
                this.lastStatus = 3;
                this.search_figure = intersectRegionSort3.figure;
                if (this.equalPoints(this.search_x, this.search_y, this.search_figure.getX1(), this.search_figure.getY1())) {
                    this.search_figure = this.search_figure.getPrev() == null ? (ToolFigure2D)this.search_figure.getParent().lastElement() : (ToolFigure2D)this.search_figure.getPrev();
                }
                this.search_intersectLast = intersectRegionSort3;
                this.search_intersectNext = intersectRegionSort4;
                if (toolPolyline2DCollection == this.collection1 || this.markSecondCollection) {
                    this.search_intersectNext.flag = bl;
                }
                return 3;
            }
            intersectRegionSort = intersectRegionSort.samePointsNext;
        }
        this.search_figure = null;
        this.search_intersectNext = null;
        this.search_intersectLast = null;
        this.lastStatus = -1;
        return -1;
    }
}

