/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.kwt;

import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.io.Serializable;
import java.util.StringTokenizer;

public class KLineType
implements Serializable {
    public static final String GEOMNAME = "LINETYPE";
    public static final short TYPE_DRAWING = 0;
    public static final short TYPE_DEVICE = 1;
    public String mName;
    public float[] mStroke;
    public float mWidth = 0.0f;
    public short mWidthType;

    public KLineType() {
    }

    public KLineType(String string, float[] fArray, float f) {
        this(string, fArray, f, 0);
    }

    public KLineType(String string, float[] fArray, float f, short s) {
        this.mName = string;
        this.mStroke = fArray;
        this.mWidth = f;
        this.mWidthType = s;
    }

    public void save(ObjectFolder objectFolder) {
        objectFolder.setName(GEOMNAME);
        if (this.mName != null) {
            objectFolder.addChild(new ObjectNode("name", this.mName));
        }
        if (this.mStroke != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.mStroke.length; ++i) {
                stringBuffer.append(Float.toString(this.mStroke[i]));
                if (i == this.mStroke.length - 1) continue;
                stringBuffer.append(",");
            }
            String string = stringBuffer.toString();
            if (string.length() > 0) {
                objectFolder.addChild(new ObjectNode("stroke", string));
            }
        }
        objectFolder.addChild(new ObjectNode("width", Float.toString(this.mWidth)));
    }

    public static void readData(ObjectFolder objectFolder, KLineType kLineType) {
        ObjectNode objectNode = objectFolder.getNode("name");
        if (objectNode != null) {
            kLineType.mName = (String)objectNode.getObject();
        }
        if ((objectNode = objectFolder.getNode("stroke")) != null) {
            String string = (String)objectNode.getObject();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            kLineType.mStroke = new float[stringTokenizer.countTokens()];
            for (int i = 0; i < kLineType.mStroke.length; ++i) {
                kLineType.mStroke[i] = Float.valueOf(stringTokenizer.nextToken()).floatValue();
            }
        }
        if ((objectNode = objectFolder.getNode("width")) != null) {
            kLineType.mWidth = Float.valueOf((String)objectNode.getObject()).floatValue();
        }
    }
}

