/*
 * Decompiled with CFR 0.152.
 */
package sandbox.gui.basic;

import gui.basic.DissolveFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import javax.swing.JComponent;

public class JImageIcon
extends JComponent {
    private Image eG;
    private Image eH;
    private boolean mIsEnabled = true;

    public JImageIcon(Image image) {
        this.setImage(image);
    }

    public static Image getImageChangedAlpha(Image image, int n, Component component) {
        if (image == null) {
            return null;
        }
        Image image2 = component.createImage(new FilteredImageSource(image.getSource(), (ImageFilter)new DissolveFilter(n)));
        JImageIcon.waitForImage(component, image2);
        return image2;
    }

    public static void waitForImage(Component component, Image image) {
        MediaTracker mediaTracker = new MediaTracker(component);
        try {
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public Image getImage() {
        return this.eG;
    }

    public Dimension getPreferredSize() {
        if (this.eG != null) {
            return new Dimension(this.eG.getWidth(null), this.eG.getHeight(null));
        }
        return super.getPreferredSize();
    }

    public synchronized boolean isEnabled() {
        return this.mIsEnabled;
    }

    public void setImage(Image image) {
        if (this.eG == image || image == null) {
            return;
        }
        this.eG = image;
        JImageIcon.waitForImage(this, this.eG);
        this.repaint();
    }

    public synchronized void setEnabled(boolean bl) {
        if (this.mIsEnabled == bl) {
            return;
        }
        this.mIsEnabled = bl;
        if (this.eG == null) {
            return;
        }
        if (!bl && this.eH == null) {
            this.eH = JImageIcon.getImageChangedAlpha(this.eG, 128, this);
        }
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        this.paintIcon(graphics, 0, 0);
    }

    public void paintIcon(Graphics graphics, int n, int n2) {
        if (this.isEnabled()) {
            if (this.eG != null) {
                graphics.drawImage(this.eG, n, n2, this);
            }
        } else if (this.eH != null) {
            graphics.drawImage(this.eH, n, n2, this);
        }
    }

    public void paintIcon(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.isEnabled()) {
            if (this.eG != null) {
                graphics.drawImage(this.eG, n, n2, n3, n4, this);
            }
        } else if (this.eH != null) {
            graphics.drawImage(this.eH, n, n2, n3, n4, this);
        }
    }
}

