/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;

public class RoundLinePanel
extends JPanel {
    protected Color mLineColor;
    protected Insets mInsets;
    protected int mRadius;
    protected int mLineWidth;
    protected boolean mDrawLine;
    protected boolean mFillPanel;

    public RoundLinePanel() {
        this.setInsets(7, 12, 7, 12);
        this.setLineWidth(1);
        this.setRadius(8);
        this.setLineColor(Color.gray);
        this.setFillPanel(true);
        this.setDrawLine(true);
    }

    public void setLineColor(Color color) {
        this.mLineColor = color;
    }

    public void setLineWidth(int n) {
        this.mLineWidth = n;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.mInsets = new Insets(n, n2, n3, n4);
    }

    public void setRadius(int n) {
        this.mRadius = n;
    }

    public void setDrawLine(boolean bl) {
        this.mDrawLine = bl;
    }

    public void setFillPanel(boolean bl) {
        this.mFillPanel = bl;
    }

    public Insets getInsets() {
        return this.mInsets;
    }

    public void paintComponent(Graphics graphics) {
        if (!this.isOpaque()) {
            return;
        }
        Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        Color color = graphics2D.getColor();
        Font font = graphics2D.getFont();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.mFillPanel) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRoundRect(this.mLineWidth - 1, this.mLineWidth - 1, dimension.width - this.mLineWidth * 2 + 2, dimension.height - this.mLineWidth * 2 + 2, this.mRadius - this.mLineWidth, this.mRadius - this.mLineWidth);
        }
        if (this.mDrawLine) {
            graphics2D.setColor(this.mLineColor);
            graphics2D.setStroke(new BasicStroke(this.mLineWidth));
            graphics2D.drawRoundRect(this.mLineWidth / 2, this.mLineWidth / 2, dimension.width - this.mLineWidth, dimension.height - this.mLineWidth, this.mRadius, this.mRadius);
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setClip(shape);
        graphics2D.setStroke(stroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

