/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import javax.swing.border.Border;

public class FlatBorder
implements Border {
    public static final Color DEF_DISABLED_COLOR = new Color(128, 128, 128);
    private Insets mInsets;
    private FontMetrics mFm;
    private Color mFillcolor;
    private Color mFontColor;
    private Color bP;
    private Color bQ;
    private String mTitle;
    private Font mFont;
    private int bR;
    private int bS;

    public FlatBorder(String string) {
        this(string, 14);
    }

    public FlatBorder(String string, int n) {
        this.mTitle = string;
        Font font = new Font("\uff2d\uff33\u3000\uff30\u30b4\u30b7\u30c3\u30af", 1, n);
        this.setFont(font);
        this.bR = 3;
        this.bS = 18;
        this.setInsets(0, 0, 0, 0);
        this.setFontColor(new Color(240, 245, 246));
        this.setTitleColor(new Color(131, 49, 50), new Color(175, 172, 171));
        this.setFillColor(Color.LIGHT_GRAY);
    }

    public void setFont(Font font) {
        this.mFont = font;
        this.mFm = null;
    }

    public void setFontColor(Color color) {
        this.mFontColor = color;
    }

    public void setFillColor(Color color) {
        this.mFillcolor = color;
    }

    public Color getFillColor() {
        return this.mFillcolor;
    }

    public void setTitleColor(Color color, Color color2) {
        this.bP = color;
        this.bQ = color2;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.mInsets = new Insets(this.bS + this.bR + 2 + n, n2, n3, n4);
    }

    public Insets getBorderInsets(Component component) {
        return this.mInsets;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Dimension dimension = new Dimension(n3, n4);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        Color color = graphics2D.getColor();
        Font font = graphics2D.getFont();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Stroke stroke = graphics2D.getStroke();
        if (this.mFm == null) {
            this.mFm = graphics.getFontMetrics(this.mFont);
        }
        int n5 = this.bS + this.bR;
        int n6 = dimension.width - 0;
        graphics2D.setColor(this.bP);
        graphics2D.fillRect(0, 0, n6, this.bR);
        graphics2D.setColor(this.bQ);
        graphics2D.fillRect(0, this.bR, n6, n5);
        graphics2D.setFont(this.mFont);
        graphics2D.setColor(this.mFontColor);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawString(this.mTitle, (float)((double)this.mFont.getSize() * 0.9), (float)n2 + (float)n5 * 0.85f);
        graphics2D.setTransform(affineTransform);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setClip(shape);
        graphics2D.setStroke(stroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

