/*
 * Decompiled with CFR 0.152.
 */
package option.gad.toex.client.service.estimate;

import com.kt.util.StringUtil;
import java.awt.Dimension;
import nethome.doc.Layer;
import option.gad.client.pdf.GdPdfUtil;
import option.gad.toex.client.service.estimate.GdAbstractEstimatePdfCommon;
import option.gad.toex.client.service.estimate.GdEstimatePdfUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GdAbstractEstimatePdfDrawing<T extends Layer>
extends GdAbstractEstimatePdfCommon<T> {
    public GdAbstractEstimatePdfDrawing(int n, int n2, String string) {
        super(n, n2, string);
    }

    @Override
    protected void setUp() {
        this.mPdfCommand.setUserCoordinateDirectionY(0);
    }

    @Override
    protected void tearDown() {
    }

    @Override
    protected void drawPage() {
        this.drawHeader();
        this.drawFooter();
        this.drawBody();
    }

    @Override
    protected void drawHeader() {
        this.mPdfGraphics.setFont(GdEstimatePdfUtil.getFont(1));
        this.mPdfGraphics.drawString(this.mCustomer.mEstimateNo, 231, 22);
        this.mPdfGraphics.drawString(String.valueOf(this.mPage), 282, 22);
        this.mPdfGraphics.setFont(GdEstimatePdfUtil.getFont(0));
        this.mPdfGraphics.drawString(this.mCustomer.mSubject, 45, 26);
        String string = StringUtil.emptyToZeroString((String)this.mCustomer.mEtCompany) + "\u3000" + StringUtil.emptyToZeroString((String)this.mCustomer.mEtChargeParson);
        this.mPdfGraphics.setFont(GdEstimatePdfUtil.getFont(1));
        GdPdfUtil.drawStringAsRightAlign(this.mPdfGraphics, string, 285, 29);
        super.drawSekisan();
        this.mPdfGraphics.drawItemString(this.mProductGroupName, this.mPdfFormatName, "PRODUCT_GROUP_NAME");
        this.mPdfGraphics.drawItemString(this.mCustomer.mCmCompany, this.mPdfFormatName, "CUSTOMER0");
        this.mPdfGraphics.drawItemString(this.mCustomer.mCmChargePerson, this.mPdfFormatName, "CUSTOMER1");
        this.mPdfGraphics.drawItemString(this.mCustomer.mCreateDate, this.mPdfFormatName, "DATE");
    }

    @Override
    protected void drawBody() {
        float[] fArray = this.getLayerBounds();
        this.changeDrawingSetting(fArray);
        this.mPdfGraphics.translate(-fArray[0], -fArray[1]);
        this.drawDrawing();
        this.mPdfGraphics.translate(fArray[0], fArray[1]);
        int n = this.getFrameNumber();
        for (int i = 0; i < n; ++i) {
            float[] fArray2 = this.getFrame(i);
            float[] fArray3 = this.getFrameBounds(i);
            this.changeDrawingSetting(fArray3, fArray2);
            this.mPdfGraphics.translate(-fArray3[0], -fArray3[1]);
            this.drawFrame(i);
            this.mPdfGraphics.translate(fArray3[0], fArray3[1]);
        }
    }

    @Override
    protected void drawFooter() {
    }

    protected void changeDrawingSetting(float[] fArray) {
        float f;
        float f2;
        float f3;
        float f4 = Math.abs(fArray[2] - fArray[0]);
        float f5 = f4 < (f3 = Math.abs(fArray[3] - fArray[1])) ? f3 : f4;
        Dimension dimension = this.mPdfCommand.getPageDimension();
        float f6 = dimension.height;
        float f7 = dimension.width;
        float f8 = f7 * 0.9f;
        float f9 = f6 * 0.6f;
        float f10 = f8 / f4;
        float f11 = f9 / f3;
        float f12 = f4;
        float f13 = f2 = f10 > f11 ? f11 : f10;
        for (f = f3; f12 > f8 && f > f9; f12 *= f2, f *= f2) {
            f2 = (float)((double)f2 - 0.01);
        }
        float f14 = f5 * f / (f3 * f6);
        float f15 = f14 * f6 / f7;
        float f16 = f15 * f4 / f5;
        float f17 = (float)Math.round((1.0f - f16) * 50.0f) / 100.0f;
        float f18 = f14 * f3 / f5;
        float f19 = 0.11f + (float)Math.round((0.6f - f18) * 50.0f) / 100.0f;
        float f20 = f17 + f15;
        float f21 = f19 + f14;
        this.mPdfCommand.setViewport(f17, f19, f20, f21);
        this.mPdfCommand.setUserCoordinateDirectionY(1);
        this.mPdfCommand.setUserCoordinate(0.0f, 0.0f, f5, f5);
    }

    protected void changeDrawingSetting(float[] fArray, float[] fArray2) {
        float f;
        float f2;
        float f3 = Math.abs(fArray[2] - fArray[0]);
        float f4 = f3 < (f2 = Math.abs(fArray[3] - fArray[1])) ? f2 : f3;
        Dimension dimension = this.mPdfCommand.getPageDimension();
        float f5 = dimension.height;
        float f6 = dimension.width;
        float f7 = Math.abs(fArray2[2] - fArray2[0]);
        float f8 = Math.abs(fArray2[3] - fArray2[1]);
        float f9 = f7 / f3;
        float f10 = f8 / f2;
        float f11 = f3;
        float f12 = f = f9 > f10 ? f10 : f9;
        for (float f13 = f2; f11 > f7 && f13 > f8; f11 *= f, f13 *= f) {
            f = (float)((double)f - 0.01);
        }
        float f14 = f8 / f5;
        float f15 = f7 / f6;
        float f16 = f15 * f3 / f4;
        float f17 = Math.min(fArray2[0], fArray2[2]) / f6 + (f15 - f16) / 2.0f;
        float f18 = f14 * f2 / f4;
        float f19 = Math.min(fArray2[1], fArray2[3]) / f5 + (f14 - f18) / 2.0f;
        float f20 = f17 + f15;
        float f21 = f19 + f14;
        this.mPdfCommand.setViewport(f17, f19, f20, f21);
        this.mPdfCommand.setUserCoordinateDirectionY(1);
        this.mPdfCommand.setUserCoordinate(0.0f, 0.0f, f4, f4);
    }

    protected abstract void drawDrawing();

    protected abstract float[] getLayerBounds();

    protected int getFrameNumber() {
        return 0;
    }

    protected void drawFrame(int n) {
        throw new IndexOutOfBoundsException();
    }

    protected float[] getFrameBounds(int n) {
        throw new IndexOutOfBoundsException();
    }

    protected float[] getFrame(int n) {
        throw new IndexOutOfBoundsException();
    }
}

