/*
 * Decompiled with CFR 0.152.
 */
package option.gad.toex.client.gui.estimate;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import option.misc.gui.AbstractBorderService;

public class GdRemarkComponent
extends JPanel {
    protected static final char DEF_CR = '\r';
    protected JTextArea mTxaRemark;
    protected AbstractBorderService mBorderService = null;
    protected int mColSize = 100;
    protected int mRowSize = 3;

    public GdRemarkComponent() {
        this.setLayout(new BorderLayout());
        this.initInterface();
    }

    protected void initInterface() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.mTxaRemark = new JTextArea(this.mRowSize, this.mColSize);
        if (this.mBorderService != null) {
            this.mTxaRemark.setBorder(this.mBorderService.createTitledBorder("\u5099\u8003"));
        }
        this.mTxaRemark.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                GdRemarkComponent.this.textValueChanged(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                GdRemarkComponent.this.textValueChanged(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                GdRemarkComponent.this.textValueChanged(documentEvent);
            }
        });
        jPanel.add((Component)this.mTxaRemark, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = this.createLabel(this.getNote());
        jLabel.setForeground(Color.BLACK);
        jPanel2.add((Component)jLabel, "West");
        JButton jButton = this.createButton("\u5165\u529b\u306e\u30af\u30ea\u30a2");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GdRemarkComponent.this.mTxaRemark.setText("");
            }
        });
        jPanel2.add((Component)jButton, "East");
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)jPanel, "Center");
    }

    protected void textValueChanged(DocumentEvent documentEvent) {
        String string = this.mTxaRemark.getText();
        int n = string.indexOf(9);
        if (n < 0) {
            return;
        }
        int n2 = this.mTxaRemark.getCaretPosition();
        while (n >= 0) {
            string = string.substring(0, n) + string.substring(n + 1, string.length());
            n = string.indexOf(9);
        }
        this.mTxaRemark.setText(string);
        this.mTxaRemark.setCaretPosition(n2 > 0 ? n2 - 1 : 0);
    }

    protected JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(this.getDefaultFont());
        return jLabel;
    }

    protected JButton createButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setFont(this.getDefaultFont());
        return jButton;
    }

    protected Font getDefaultFont() {
        return new Font("Monospaced", 0, 13);
    }

    public void setRemark(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.mTxaRemark.setText("");
            return;
        }
        int n = 1;
        String string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].length() > 0) {
                for (int j = 0; j < n; ++j) {
                    string = string + '\n';
                }
                string = string + stringArray[i];
                n = 1;
                continue;
            }
            ++n;
        }
        this.mTxaRemark.setText(string);
    }

    public String[] getRemark() {
        String string = this.getText();
        char[] cArray = string.toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\n') continue;
            if (n == i) {
                arrayList.add("");
            } else {
                arrayList.add(string.substring(n, i));
            }
            n = i + 1;
        }
        if (n < cArray.length) {
            arrayList.add(string.substring(n, string.length()));
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    protected String getText() {
        String string = this.mTxaRemark.getText();
        return string.replaceAll("(\r|[\r\n]+$)", "");
    }

    protected String getNote() {
        int n = this.mRowSize;
        int n2 = this.mColSize / 2;
        return "\u3000\u203b\u5099\u8003\u306f\u3001" + n + "\u884c\u00d7" + n2 + "\u6587\u5b57\uff08\u5168\u89d2\u3067\u8a08" + n * n2 + "\u6587\u5b57\uff09\u307e\u3067\u898b\u7a4d\u66f8\u306b\u53cd\u6620\u3055\u308c\u307e\u3059\u3002";
    }

    public void setColSize(int n) {
        this.mColSize = n;
    }

    public void setRowSize(int n) {
        this.mRowSize = n;
    }

    public void setBorderService(AbstractBorderService abstractBorderService) {
        this.mBorderService = abstractBorderService;
    }
}

