/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util.csv;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import option.gad.core.dxo.TypeConvertUtil;
import option.gad.core.io.FileIOUtil;
import option.gad.core.util.NameUtil;
import option.gad.core.util.ReflectUtil;
import option.gad.core.util.csv.Csv;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvBuilder {
    protected static final String DEFAULT_CHARCTER_ENCODING = "MS932";
    private static final Log b = LogFactory.getLog(CsvBuilder.class);

    public Csv build(String string, boolean bl) {
        return this.build(string, bl, DEFAULT_CHARCTER_ENCODING);
    }

    public Csv build(String string, boolean bl, String string2) {
        return this.build(new ByteArrayInputStream(string.getBytes()), bl, string2);
    }

    public Csv build(File file, boolean bl) {
        return this.build(file, bl, DEFAULT_CHARCTER_ENCODING);
    }

    public Csv build(File file, boolean bl, String string) {
        Csv csv = null;
        try {
            csv = this.build(FileIOUtil.openInReadingMode(file), bl, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            b.info((Object)"", (Throwable)fileNotFoundException);
        }
        return csv;
    }

    public Csv build(InputStream inputStream, boolean bl) {
        return this.build(inputStream, bl, DEFAULT_CHARCTER_ENCODING);
    }

    public Csv build(InputStream inputStream, boolean bl, String string) {
        return this.build(inputStream, bl, false, string);
    }

    public Csv build(InputStream inputStream, boolean bl, boolean bl2, String string) {
        Csv csv;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            csv = new Csv();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
            while ((string2 = bufferedReader.readLine()) != null) {
                Object object;
                if (string2.startsWith("#")) continue;
                String[] stringArray = string2.split(",", -1);
                if (bl) {
                    object = stringArray;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String string3 = object[i];
                        if (string3 != null) {
                            string3 = string3.trim();
                            if (bl2) {
                                string3 = NameUtil.convCamelCase(string3);
                            }
                        }
                        csv.mColNameList.add(string3);
                    }
                    bl = false;
                    continue;
                }
                if (csv.mColNameList.isEmpty()) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        csv.mColNameList.add(Integer.toString(i));
                    }
                }
                object = new ArrayList();
                for (String string4 : stringArray) {
                    if (string4 != null) {
                        string4 = string4.trim();
                    }
                    if (0 >= csv.mColNameList.size()) {
                        b.info((Object)(string2 + " : " + csv.mColNameList.size() + " != 0"));
                        continue;
                    }
                    object.add(string4);
                }
                csv.mRowList.add((List<String>)object);
            }
        }
        catch (IOException iOException) {
            try {
                b.info((Object)"", (Throwable)iOException);
                throw new RuntimeException(iOException);
            }
            catch (Throwable throwable) {
                FileIOUtil.close(bufferedReader);
                throw throwable;
            }
        }
        FileIOUtil.close(bufferedReader);
        return csv;
    }

    public Csv build(List<?> object) {
        if (object == null) {
            throw new IllegalArgumentException("The argument is empty");
        }
        Csv csv = new Csv();
        Collection<Field> collection = null;
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (csv.mRowList.isEmpty()) {
                collection = ReflectUtil.getFields(e);
                for (Field field : collection) {
                    Object object2 = NameUtil.removePrefix(field.getName());
                    csv.mColNameList.add((String)object2);
                }
            }
            ArrayList arrayList = new ArrayList();
            for (Object object2 : collection) {
                object2 = ReflectUtil.getFieldValue(e, (Field)object2);
                object2 = TypeConvertUtil.convertString(object2);
                arrayList.add(object2);
            }
            csv.mRowList.add(arrayList);
        }
        return csv;
    }
}

