/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    public static final int SECOND_OF_DAY = 86400;
    public static final String FORMAT_YYYYMM = "yyyyMM";
    public static final String FORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String FORMAT_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String FORMAT_YYYY_MM = "yyyy/MM";
    public static final String FORMAT_YYYY_MM_DD = "yyyy/MM/dd";
    public static final String FORMAT_YYYY_MM_DD_HH_MM_SS = "yyyy/MM/dd HH:mm:ss";
    public static final String FORMAT_LOG4J = "yyyy-MM-dd HH:mm:ss,SSS";

    protected DateUtil() {
    }

    public static String form(String object, Timestamp timestamp) {
        try {
            object = new SimpleDateFormat((String)object);
            object = ((DateFormat)object).format(timestamp);
        }
        catch (Exception exception) {
            object = null;
        }
        return object;
    }

    public static String formYMD(Timestamp timestamp) {
        return DateUtil.form(FORMAT_YYYYMMDD, timestamp);
    }

    public static String formYMDHMS(Timestamp timestamp) {
        return DateUtil.form(FORMAT_YYYYMMDDHHMMSS, timestamp);
    }

    public static String formUTC(Timestamp timestamp) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy (EEE) HH:mm", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        return simpleDateFormat.format(timestamp) + " UTC";
    }

    public static String formGMT(Timestamp timestamp) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("Etc/GMT"));
        return simpleDateFormat.format(timestamp) + " GMT";
    }
}

