/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.AbstractBuffer;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.spdy.ByteBufferPool;
import org.eclipse.jetty.spdy.Controller;
import org.eclipse.jetty.spdy.IdleListener;
import org.eclipse.jetty.spdy.StandardSession;
import org.eclipse.jetty.spdy.api.Handler;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.parser.Parser;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SPDYAsyncConnection
extends AbstractConnection
implements AsyncConnection,
Controller<StandardSession.FrameBytes>,
IdleListener {
    private static final Logger logger = Log.getLogger(SPDYAsyncConnection.class);
    private final ByteBufferPool bufferPool;
    private final Parser parser;
    private volatile Session session;
    private ByteBuffer writeBuffer;
    private Handler<StandardSession.FrameBytes> writeHandler;
    private StandardSession.FrameBytes writeContext;
    private volatile boolean writePending;

    public SPDYAsyncConnection(AsyncEndPoint endPoint, ByteBufferPool bufferPool, Parser parser) {
        super(endPoint);
        this.bufferPool = bufferPool;
        this.parser = parser;
        this.onIdle(true);
    }

    @Override
    public Connection handle() throws IOException {
        AsyncEndPoint endPoint = this.getEndPoint();
        boolean progress = true;
        while (endPoint.isOpen() && progress) {
            int filled = this.fill();
            progress = filled > 0;
            int flushed = this.flush();
            progress |= flushed > 0;
            endPoint.flush();
            if ((progress |= endPoint.hasProgressed()) || filled >= 0) continue;
            this.onInputShutdown();
            this.close(false);
        }
        return this;
    }

    public int fill() throws IOException {
        ByteBuffer buffer = this.bufferPool.acquire(8192, true);
        DirectNIOBuffer jettyBuffer = new DirectNIOBuffer(buffer, false);
        jettyBuffer.setPutIndex(jettyBuffer.getIndex());
        AsyncEndPoint endPoint = this.getEndPoint();
        int filled = endPoint.fill(jettyBuffer);
        logger.debug("Filled {} from {}", filled, endPoint);
        if (filled <= 0) {
            return filled;
        }
        buffer.limit(jettyBuffer.putIndex());
        buffer.position(jettyBuffer.getIndex());
        this.parser.parse(buffer);
        this.bufferPool.release(buffer);
        return filled;
    }

    public int flush() {
        int result = 0;
        if (this.writePending) {
            result = this.write(this.writeBuffer, this.writeHandler, this.writeContext);
        }
        logger.debug("Flushed {} to {}", result, this.getEndPoint());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer buffer, Handler<StandardSession.FrameBytes> handler, StandardSession.FrameBytes context) {
        int remaining = buffer.remaining();
        AbstractBuffer jettyBuffer = buffer.isDirect() ? new DirectNIOBuffer(buffer, false) : new IndirectNIOBuffer(buffer, false);
        AsyncEndPoint endPoint = this.getEndPoint();
        try {
            int written = endPoint.flush(jettyBuffer);
            logger.debug("Written {} bytes, {} remaining", written, jettyBuffer.length());
        }
        catch (Exception x) {
            this.close(false);
            handler.failed(context, x);
            int n = -1;
            return n;
        }
        finally {
            buffer.limit(jettyBuffer.putIndex());
            buffer.position(jettyBuffer.getIndex());
        }
        if (buffer.hasRemaining()) {
            this.writeBuffer = buffer;
            this.writeHandler = handler;
            this.writeContext = context;
            this.writePending = true;
            endPoint.scheduleWrite();
        } else {
            if (this.writePending) {
                this.writeBuffer = null;
                this.writeHandler = null;
                this.writeContext = null;
                this.writePending = false;
            }
            handler.completed(context);
        }
        return remaining - buffer.remaining();
    }

    @Override
    public void close(boolean onlyOutput) {
        try {
            AsyncEndPoint endPoint = this.getEndPoint();
            try {
                logger.debug("Shutting down output {}", endPoint);
                endPoint.shutdownOutput();
                if (!onlyOutput) {
                    logger.debug("Closing {}", endPoint);
                    endPoint.close();
                }
            }
            catch (IOException x) {
                endPoint.close();
            }
        }
        catch (IOException x) {
            logger.ignore(x);
        }
    }

    @Override
    public void onIdle(boolean idle) {
        this.getEndPoint().setCheckForIdle(idle);
    }

    @Override
    public AsyncEndPoint getEndPoint() {
        return (AsyncEndPoint)super.getEndPoint();
    }

    @Override
    public boolean isIdle() {
        return false;
    }

    @Override
    public boolean isSuspended() {
        return false;
    }

    @Override
    public void onClose() {
    }

    @Override
    public void onInputShutdown() throws IOException {
    }

    @Override
    public void onIdleExpired(long idleForMs) {
        logger.debug("Idle timeout expired for {}", this.getEndPoint());
        this.session.goAway();
    }

    protected Session getSession() {
        return this.session;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    @Override
    public String toString() {
        return String.format("%s@%x{endp=%s@%x}", this.getClass().getSimpleName(), this.hashCode(), this.getEndPoint().getClass().getSimpleName(), this.getEndPoint().hashCode());
    }
}

