/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom.primitive;

import com.kt.geom.K2DPathFigureArc;
import com.kt.util.RefList;
import com.kt.util.Vector2;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.awt.Color;
import java.io.Serializable;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.IRichGraphics;
import nethome.geom.AreaControl;
import nethome.geom.LocalAxis2Df;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.Geometory;
import nethome.geom.primitive.IFillableGeometory;
import nethome.geom.primitive.Primitive;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolPolygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCircle
extends Geometory
implements K2DPathFigureArc,
Primitive,
IFillableGeometory,
Serializable {
    private static final String GEOMNAME = "CIRCLE";
    protected GPoint2Df mCp;
    protected float _r;
    protected float _start;
    protected float _end;
    protected RefList<GPoint2Df> _maxPts;
    private GPoint2Df _tmpP = new GPoint2Df();
    public boolean mFill = false;
    private Color mFillColor;

    private GCircle() {
        this.setGeomName(GEOMNAME);
    }

    public GCircle(float f, float f2, float f3, float f4, float f5) {
        this();
        this.mGeomColor = Color.black;
        this.mCp = new GPoint2Df(f, f2);
        this._r = f3;
        this._start = f4;
        this._end = f5;
        this.areaControl = new AreaControl();
        this.updateMaxPoints();
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public boolean getSnapNode(float f, float f2, float f3, float f4, float[] fArray, float[] fArray2, float f5, short s) {
        return false;
    }

    @Override
    public void getCenter(GPoint2Df gPoint2Df) {
        gPoint2Df.x = this.mCp.x;
        gPoint2Df.y = this.mCp.y;
    }

    @Override
    public void getSnapLoop(Vector2<? super GPoint2Df> vector2) {
    }

    @Override
    public GPoint2Df getNearNode(GPoint2Df gPoint2Df, GPoint2Df gPoint2Df2, float f) {
        return null;
    }

    @Override
    public boolean getNearLine(float f, float f2, float f3, GPoint2Df[] gPoint2DfArray) {
        return false;
    }

    @Override
    public GPoint2Df getRotbasePoint() {
        return (GPoint2Df)this._maxPts.elementAt(0);
    }

    public static boolean isParallel(Geometory geometory, Geometory geometory2) {
        if (geometory == null || geometory2 == null) {
            return false;
        }
        if (!(geometory instanceof GCircle) || !(geometory2 instanceof GCircle)) {
            return false;
        }
        GCircle gCircle = (GCircle)geometory;
        GCircle gCircle2 = (GCircle)geometory2;
        return Math.abs(gCircle.getR() - gCircle2.getR()) < 0.001f && ToolMath.getLength2D(gCircle.getX(), gCircle.getY(), gCircle2.getX(), gCircle2.getY()) < (double)0.001f && (Math.abs(gCircle.getStart() - gCircle2.getEnd()) < 0.001f ? !ToolMath.isInnderAngl360(gCircle.getStart(), gCircle.getEnd(), gCircle2.getStart()) : Math.abs(gCircle.getEnd() - gCircle2.getStart()) < 0.001f && !ToolMath.isInnderAngl360(gCircle.getStart(), gCircle.getEnd(), gCircle2.getEnd()));
    }

    public static Geometory marge(Geometory geometory, Geometory geometory2) {
        if (GCircle.isParallel(geometory, geometory2)) {
            GCircle gCircle = (GCircle)geometory;
            GCircle gCircle2 = (GCircle)geometory2;
            if (Math.abs(gCircle.getStart() - gCircle2.getEnd()) < 0.001f) {
                if (!ToolMath.isInnderAngl360(gCircle.getStart(), gCircle.getEnd(), gCircle2.getStart())) {
                    return new GCircle(gCircle.getX(), gCircle.getY(), gCircle.getR(), gCircle2.getStart(), gCircle.getEnd());
                }
            } else if (Math.abs(gCircle.getEnd() - gCircle2.getStart()) < 0.001f && !ToolMath.isInnderAngl360(gCircle.getStart(), gCircle.getEnd(), gCircle2.getEnd())) {
                return new GCircle(gCircle.getX(), gCircle.getY(), gCircle.getR(), gCircle.getStart(), gCircle2.getEnd());
            }
        }
        return null;
    }

    public float getStart() {
        return this._start;
    }

    public void setStart(float f) {
        this._start = f;
    }

    public float getEnd() {
        return this._end;
    }

    public void setEnd(float f) {
        this._end = f;
    }

    public float getR() {
        return this._r;
    }

    public void setR(float f) {
        this._r = f;
    }

    public void setX(float f) {
        this.mCp.x = f;
    }

    public void setY(float f) {
        this.mCp.y = f;
    }

    public float getX() {
        return this.mCp.x;
    }

    public float getY() {
        return this.mCp.y;
    }

    @Override
    public Geometory getCopy() {
        return this.getCopy(new GCircle());
    }

    @Override
    protected Geometory getCopy(Geometory geometory) {
        if (geometory == null || !(geometory instanceof GCircle)) {
            return null;
        }
        GCircle gCircle = (GCircle)geometory;
        super.getCopy(gCircle);
        gCircle.mCp = new GPoint2Df(this.mCp.x, this.mCp.y);
        gCircle._r = this._r;
        gCircle._start = this._start;
        gCircle._end = this._end;
        gCircle.setFillMode(this.mFill);
        gCircle.setFillColor(this.mFillColor);
        gCircle.areaControl = new AreaControl();
        gCircle.updateMaxPoints();
        gCircle.area.maximize();
        gCircle.updateMinMax(gCircle.area);
        return gCircle;
    }

    @Override
    public void updateMinMax(Area area) {
        float f;
        float f2 = this._end;
        for (f = this._start; f > f2; f -= 360.0f) {
        }
        if (f <= 0.0f && f2 >= 0.0f) {
            area.maxX = Math.max(this.mCp.x + this._r, area.maxX);
        }
        if (f <= 90.0f && f2 >= 90.0f) {
            area.maxY = Math.max(this.mCp.y + this._r, area.maxY);
        }
        if (f <= 180.0f && f2 >= 180.0f) {
            area.minX = Math.min(this.mCp.x - this._r, area.minX);
        }
        if (f <= 270.0f && f2 >= 270.0f) {
            area.minY = Math.min(this.mCp.y - this._r, area.minY);
        }
        if (this._start == this._end) {
            area.updateMinMax(this.mCp.x + this._r, this.mCp.y + this._r);
            area.updateMinMax(this.mCp.x - this._r, this.mCp.y - this._r);
        } else {
            float f3 = this.mCp.x + (float)((double)this._r * Math.cos((double)this._start * Math.PI / 180.0));
            float f4 = this.mCp.y + (float)((double)this._r * Math.sin((double)this._start * Math.PI / 180.0));
            float f5 = this.mCp.x + (float)((double)this._r * Math.cos((double)this._end * Math.PI / 180.0));
            float f6 = this.mCp.y + (float)((double)this._r * Math.sin((double)this._end * Math.PI / 180.0));
            area.updateMinMax(f3, f4);
            area.updateMinMax(f5, f6);
        }
    }

    private void updateMaxPoints() {
        float f;
        float f2 = this._end;
        for (f = this._start; f > f2; f -= 360.0f) {
        }
        this._maxPts = new RefList();
        if (f < 0.0f && f2 > 0.0f || this._start == this._end) {
            this._maxPts.addElement((Object)new GPoint2Df(this.mCp.x + this._r, this.mCp.y));
        }
        if (f < 90.0f && f2 > 90.0f || this._start == this._end) {
            this._maxPts.addElement((Object)new GPoint2Df(this.mCp.x, this.mCp.y + this._r));
        }
        if (f < 180.0f && f2 > 180.0f || this._start == this._end) {
            this._maxPts.addElement((Object)new GPoint2Df(this.mCp.x - this._r, this.mCp.y));
        }
        if (f < 270.0f && f2 > 270.0f || this._start == this._end) {
            this._maxPts.addElement((Object)new GPoint2Df(this.mCp.x, this.mCp.y - this._r));
        }
        if (this._start != this._end) {
            GPoint2Df gPoint2Df = new GPoint2Df(this.mCp.x + (float)((double)this._r * Math.cos((double)this._start * Math.PI / 180.0)), this.mCp.y + (float)((double)this._r * Math.sin((double)this._start * Math.PI / 180.0)));
            GPoint2Df gPoint2Df2 = new GPoint2Df(this.mCp.x + (float)((double)this._r * Math.cos((double)this._end * Math.PI / 180.0)), this.mCp.y + (float)((double)this._r * Math.sin((double)this._end * Math.PI / 180.0)));
            this._maxPts.addElement((Object)gPoint2Df);
            this._maxPts.addElement((Object)gPoint2Df2);
        }
        this.areaControl.getPoints().removeAllElements();
        for (int i = 0; i < this._maxPts.size(); ++i) {
            this.areaControl.getPoints().addElement(this._maxPts.elementAt(i));
        }
    }

    @Override
    public GPoint2Df getNearNode(float f, float f2) {
        float f3;
        float f4;
        this._tmpP.x = this.mCp.x + (float)((double)this._r * Math.cos((double)this._start * Math.PI / 180.0));
        this._tmpP.y = this.mCp.y + (float)((double)this._r * Math.sin((double)this._start * Math.PI / 180.0));
        float f5 = (float)ToolMath.getLength2D(f, f2, this._tmpP.x, this._tmpP.y);
        if (f5 > (float)ToolMath.getLength2D(f, f2, f4 = this.mCp.x + (float)((double)this._r * Math.cos((double)this._end * Math.PI / 180.0)), f3 = this.mCp.y + (float)((double)this._r * Math.sin((double)this._end * Math.PI / 180.0)))) {
            this._tmpP.x = f4;
            this._tmpP.y = f3;
        }
        return this._tmpP;
    }

    @Override
    public float getDistanceToPoint(float f, float f2) {
        float f3 = (float)(ToolMath.getAngle2D(this.mCp.x, this.mCp.y, f, f2) * 180.0 / Math.PI);
        float f4 = this._start;
        float f5 = this._end;
        f5 -= f4;
        f3 -= f4;
        f4 = 0.0f;
        f5 = (float)ToolMath.getAngl360(f5);
        if ((f3 = (float)ToolMath.getAngl360(f3)) > f4 && f3 < f5 || f4 == f5) {
            return (float)Math.abs((double)this._r - ToolMath.getLength2D(this.mCp.x, this.mCp.y, f, f2));
        }
        float f6 = this.mCp.x + (float)((double)this._r * Math.cos((double)this._start * Math.PI / 180.0));
        float f7 = this.mCp.y + (float)((double)this._r * Math.sin((double)this._start * Math.PI / 180.0));
        float f8 = (float)ToolMath.getLength2D(f, f2, f6, f7);
        f6 = this.mCp.x + (float)((double)this._r * Math.cos((double)this._end * Math.PI / 180.0));
        f7 = this.mCp.y + (float)((double)this._r * Math.sin((double)this._end * Math.PI / 180.0));
        f8 = Math.min(f8, (float)ToolMath.getLength2D(f, f2, f6, f7));
        return f8;
    }

    @Override
    public void offset(float f, float f2) {
        if (f == 0.0f && f2 == 0.0f) {
            return;
        }
        this.mCp.x += f;
        this.mCp.y += f2;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    }

    @Override
    public void rotate(float f, float f2, float f3) {
        if (f3 == 0.0f) {
            return;
        }
        this.mCp.rotate(f, f2, f3);
        this._start += (float)((double)(f3 * 180.0f) / Math.PI);
        this._end += (float)((double)(f3 * 180.0f) / Math.PI);
        while (this._start >= 360.0f) {
            this._start -= 360.0f;
        }
        while (this._start < 0.0f) {
            this._start += 360.0f;
        }
        while (this._end >= 360.0f) {
            this._end -= 360.0f;
        }
        while (this._end < 0.0f) {
            this._end += 360.0f;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    }

    @Override
    public boolean isInner(float f, float f2, float f3, float f4) {
        for (int i = 0; i < this._maxPts.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this._maxPts.elementAt(i);
            if (!(gPoint2Df.x < f || gPoint2Df.x > f3 || gPoint2Df.y < f2) && !(gPoint2Df.y > f4)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInner(RefList<GPoint2Df> refList) {
        for (int i = 0; i < this._maxPts.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this._maxPts.elementAt(i);
            if (ToolPolygon.isInnerPolygon(refList, gPoint2Df.x, gPoint2Df.y)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void save(ObjectFolder objectFolder) {
        if (objectFolder == null) {
            return;
        }
        objectFolder.setName(GEOMNAME);
        super.save(objectFolder);
        objectFolder.addChild(new ObjectNode("cx", (Object)Float.toString(this.mCp.x)));
        objectFolder.addChild(new ObjectNode("cy", (Object)Float.toString(this.mCp.y)));
        objectFolder.addChild(new ObjectNode("r", (Object)Float.toString(this._r)));
        objectFolder.addChild(new ObjectNode("start", (Object)Float.toString(this._start)));
        objectFolder.addChild(new ObjectNode("end", (Object)Float.toString(this._end)));
        objectFolder.addChild(new ObjectNode("fill", (Object)(this.mFill ? "1" : "0")));
        if (this.mFillColor != null) {
            objectFolder.addChild(new ObjectNode("fillc", (Object)(this.mFillColor.getRed() + "," + this.mFillColor.getGreen() + "," + this.mFillColor.getBlue())));
        }
    }

    @Override
    public void drawGeom(IRichGraphics iRichGraphics) {
        this.drawGeom(iRichGraphics, this.mGeomColor, null);
    }

    @Override
    public void drawGeom(IRichGraphics iRichGraphics, Color color, Color color2) {
        if (color2 == null) {
            color2 = this.mFillColor;
        }
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, null);
    }

    @Override
    public void drawAlias(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        if (color2 == null) {
            color2 = this.mFillColor;
        }
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, localAxis2Df);
    }

    @Override
    public void drawAbstDevice(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        float f = this.mCp.x;
        float f2 = this.mCp.y;
        float f3 = this._start;
        float f4 = this._end;
        float f5 = this._r;
        if (localAxis2Df != null) {
            f = localAxis2Df.getGlobalX(this.mCp.x, this.mCp.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            f2 = localAxis2Df.getGlobalY(this.mCp.x, this.mCp.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            f4 = (float)((double)(localAxis2Df.getGlobalAngl((double)this._end * Math.PI / 180.0) * 180.0f) / Math.PI);
            f5 = localAxis2Df.getGlobalLength(this._r);
            for (f3 = (float)((double)(localAxis2Df.getGlobalAngl((double)this._start * Math.PI / 180.0) * 180.0f) / Math.PI); f3 >= 360.0f; f3 -= 360.0f) {
            }
            while (f3 < 0.0f) {
                f3 += 360.0f;
            }
            while (f4 >= 360.0f) {
                f4 -= 360.0f;
            }
            while (f4 < 0.0f) {
                f4 += 360.0f;
            }
        }
        if (this.mFill && color2 != null) {
            iRichGraphics.setColor(color2);
            iRichGraphics.drawFillCircle(f, f2, f5, f3, f4, null);
        }
        iRichGraphics.setColor(color);
        iRichGraphics.drawCircle(f, f2, f5, f3, f4, null);
    }

    @Override
    public void drawHighLight(IRichGraphics iRichGraphics, Color color, boolean bl) {
        int n;
        if (bl) {
            n = this.mFill;
            this.mFill = false;
            this.drawAbstDevice(iRichGraphics, color, color, null);
            this.mFill = n;
        }
        for (n = 0; n < this._maxPts.size(); ++n) {
            ((GPoint2Df)this._maxPts.elementAt(n)).drawHighLight(iRichGraphics, color, false);
        }
    }

    public void getLocalMinMax(Area area) {
        float f = (float)((double)this._start * Math.PI / 180.0);
        float f2 = f;
        float f3 = (float)((double)this._end * Math.PI / 180.0);
        float f4 = f2 > f3 ? (float)(Math.PI * 2 - (double)(f2 - f3)) : f3 - f2;
        while ((double)f >= Math.PI) {
            f = (float)((double)f - Math.PI * 2);
        }
        float f5 = Float.POSITIVE_INFINITY;
        float f6 = Float.POSITIVE_INFINITY;
        float f7 = Float.NEGATIVE_INFINITY;
        float f8 = Float.NEGATIVE_INFINITY;
        if (Math.abs(f2 - f3) < 0.001f) {
            f5 = this.mCp.x - this._r;
            f7 = this.mCp.x + this._r;
            f6 = this.mCp.y - this._r;
            f8 = this.mCp.y + this._r;
        } else {
            if (f2 <= 0.0f && f2 + f4 >= 0.0f) {
                f7 = this.mCp.x + this._r;
            }
            if ((double)f2 <= Math.PI * 2 && (double)(f2 + f4) >= Math.PI * 2) {
                f7 = this.mCp.x + this._r;
            }
            if ((double)f2 <= 1.5707963267948966 && (double)(f2 + f4) >= 1.5707963267948966) {
                f8 = this.mCp.y + this._r;
            }
            if ((double)f2 <= 7.853981633974483 && (double)(f2 + f4) >= 7.853981633974483) {
                f8 = this.mCp.y + this._r;
            }
            if ((double)f2 <= Math.PI && (double)(f2 + f4) >= Math.PI) {
                f5 = this.mCp.x - this._r;
            }
            if ((double)f2 <= Math.PI * 3 && (double)(f2 + f4) >= Math.PI * 3) {
                f5 = this.mCp.x - this._r;
            }
            if ((double)f2 <= 4.71238898038469 && (double)(f2 + f4) >= 4.71238898038469) {
                f6 = this.mCp.y - this._r;
            }
            if ((double)f2 <= 10.995574287564276 && (double)(f2 + f4) >= 10.995574287564276) {
                f6 = this.mCp.y - this._r;
            }
            f5 = Math.min(f5, this.mCp.x + (float)((double)this._r * Math.cos(f2)));
            f6 = Math.min(f6, this.mCp.y + (float)((double)this._r * Math.sin(f2)));
            f7 = Math.max(f7, this.mCp.x + (float)((double)this._r * Math.cos(f3)));
            f8 = Math.max(f8, this.mCp.y + (float)((double)this._r * Math.sin(f3)));
        }
        area.updateMinMax(f5, f6);
        area.updateMinMax(f7, f8);
    }

    @Override
    public Object getNearControlPoint(float f, float f2) {
        float f3 = Float.POSITIVE_INFINITY;
        GPoint2Df gPoint2Df = null;
        for (int i = 0; i < this._maxPts.size(); ++i) {
            GPoint2Df gPoint2Df2 = (GPoint2Df)this._maxPts.elementAt(i);
            float f4 = gPoint2Df2.getDistanceToPoint(f, f2);
            if (!(f4 < f3)) continue;
            f3 = f4;
            gPoint2Df = gPoint2Df2;
        }
        return gPoint2Df;
    }

    @Override
    public void moveControlPoint(Object object, float f, float f2) {
        float f3;
        this._r = f3 = (float)ToolMath.getLength2D(f, f2, this.mCp.x, this.mCp.y);
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    }

    @Override
    public void flipx(float f, float f2) {
        this.mCp.flipx(f, f2);
        this._start = (float)ToolMath.getAngl360(180.0f - this._start);
        this._end = (float)ToolMath.getAngl360(180.0f - this._end);
        float f3 = this._start;
        this._start = this._end;
        this._end = f3;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    }

    @Override
    public void flipy(float f, float f2) {
        this.mCp.flipy(f, f2);
        this._start = (float)ToolMath.getAngl360(-this._start);
        this._end = (float)ToolMath.getAngl360(-this._end);
        float f3 = this._start;
        this._start = this._end;
        this._end = f3;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    }

    @Override
    public void rot(float f, float f2, float f3, float f4) {
        this.mCp.rot(f, f2, f3, f4);
        this._start = (float)ToolMath.getAngl360(this._start + 90.0f);
        this._end = (float)ToolMath.getAngl360(this._end + 90.0f);
        if (Math.abs(this._start - this._end) < 0.001f) {
            this._end = 0.0f;
            this._start = 0.0f;
        }
        while (this._start >= 360.0f) {
            this._start -= 360.0f;
        }
        while (this._start < 0.0f) {
            this._start += 360.0f;
        }
        while (this._end >= 360.0f) {
            this._end -= 360.0f;
        }
        while (this._end < 0.0f) {
            this._end += 360.0f;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    }

    @Override
    public void setFillMode(boolean bl) {
        this.mFill = bl;
    }

    @Override
    public boolean isFillMode() {
        return this.mFill;
    }

    @Override
    public Color getFillColor() {
        return this.mFillColor;
    }

    @Override
    public void setFillColor(Color color) {
        this.mFillColor = color;
    }

    public double getCX() {
        return this.mCp.getX();
    }

    public double getCY() {
        return this.mCp.getY();
    }

    public double getRadius() {
        return this._r;
    }

    public boolean isCw() {
        return false;
    }

    public void setCw(boolean bl) {
    }

    public void setCX(double d) {
        this.mCp.setX(d);
    }

    public void setCY(double d) {
        this.mCp.setY(d);
    }

    public void setRadius(double d) {
        this._r = (float)d;
    }

    public double getX1() {
        return (double)this.mCp.x + (double)this._r * Math.cos(this._start * ((float)Math.PI / 180));
    }

    public double getX2() {
        return (double)this.mCp.x + (double)this._r * Math.cos(this._end * ((float)Math.PI / 180));
    }

    public double getY1() {
        return (double)this.mCp.y + (double)this._r * Math.sin(this._start * ((float)Math.PI / 180));
    }

    public double getY2() {
        return (double)this.mCp.y + (double)this._r * Math.sin(this._end * ((float)Math.PI / 180));
    }

    public void setX1(double d) {
    }

    public void setX2(double d) {
    }

    public void setY1(double d) {
    }

    public void setY2(double d) {
    }

    public int getType() {
        return 3;
    }
}

