/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom;

import com.kt.io.AbstFile;
import java.awt.Color;
import java.util.Vector;
import jp.kitec.kwt.IRichGraphics;
import nethome.NethomeResource;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.GText;
import nethome.geom.primitive.Geometory;
import nethome.geom.util.ToolMath;

public class GTextGroup
extends Geometory {
    private static final String GEOMNAME = "TEXTGROUP";
    public GPoint2Df mCp;
    public float mAngl;
    public float mSize;
    private Vector<GText> mTexts;
    private boolean mDir = true;
    private boolean mBackFill = false;
    private Color mFillColor;
    private String mScaleFont;

    public GTextGroup(GPoint2Df gPoint2Df, String string, float f, float f2) {
        this.setGeomName(GEOMNAME);
        this.mCp = new GPoint2Df(gPoint2Df.x, gPoint2Df.y);
        this.mAngl = f;
        this.mScaleFont = string;
        this.mTexts = new Vector();
        this.mSize = f2;
    }

    public void setDir(boolean bl) {
        this.mDir = bl;
    }

    public void setBackColor(boolean bl, Color color) {
        this.mBackFill = bl;
        this.mFillColor = color;
    }

    public int getTextSize() {
        return this.mTexts.size();
    }

    public void update() {
        int n;
        for (n = 0; n < this.mTexts.size(); ++n) {
            GText gText = this.mTexts.elementAt(n);
            gText.setFillMode(this.mBackFill, this.mFillColor);
        }
        if (this.mDir) {
            n = 0;
            for (int i = 0; i < this.mTexts.size(); ++i) {
                GText gText = this.mTexts.elementAt(i);
                gText.update();
                n = (int)((float)n + (gText.mMaxy - gText.mMiny));
            }
            float f = 0.0f;
            for (int i = 0; i < this.mTexts.size(); ++i) {
                GText gText = this.mTexts.elementAt(i);
                if (i == 0) {
                    f = this.mCp.y + (float)(n / 2);
                }
                gText.mAngl = this.mAngl;
                gText.mCp.x = this.mCp.x;
                gText.mCp.y = f - (gText.mMaxy - gText.mMiny) / 2.0f;
                f -= gText.mMaxy - gText.mMiny;
            }
        } else {
            n = 0;
            for (int i = 0; i < this.mTexts.size(); ++i) {
                GText gText = this.mTexts.elementAt(i);
                gText.setDir(this.mDir);
                gText.update();
                n = (int)((float)n + (gText.mMaxx - gText.mMinx));
            }
            float f = 0.0f;
            for (int i = 0; i < this.mTexts.size(); ++i) {
                GText gText = this.mTexts.elementAt(i);
                gText.mAngl = this.mAngl;
                gText.mCp.y = this.mCp.y;
                if (NethomeResource.TATEGAKI_DIR) {
                    if (i == 0) {
                        f = this.mCp.x - (float)(n / 2);
                    }
                    gText.mCp.x = f + (gText.mMaxx - gText.mMinx) / 2.0f;
                    f += gText.mMaxx - gText.mMinx;
                    continue;
                }
                if (i == 0) {
                    f = this.mCp.x + (float)(n / 2);
                }
                gText.mCp.x = f - (gText.mMaxx - gText.mMinx) / 2.0f;
                f -= gText.mMaxx - gText.mMinx;
            }
        }
    }

    public void addText(String string, float f, boolean bl) {
        if (string == null || string.length() == 0) {
            return;
        }
        GText gText = new GText(new GPoint2Df(), this.mScaleFont, string, 0.0f, f, bl);
        this.mTexts.addElement(gText);
        this.update();
    }

    public void removeAll() {
        this.mTexts.removeAllElements();
    }

    public float getDistanceToPoint(float f, float f2) {
        return (float)ToolMath.getLength2D(f, f2, this.mCp.x, this.mCp.y);
    }

    public void offset(float f, float f2) {
        this.mCp.x += f;
        this.mCp.y += f2;
    }

    public void flipx(float f, float f2) {
    }

    public void flipy(float f, float f2) {
    }

    public static Object readData(AbstFile abstFile, float f) throws Exception {
        return null;
    }

    public void drawGeom(IRichGraphics iRichGraphics) {
        this.drawGeom(iRichGraphics, Color.black, null);
    }

    public void drawGeom(IRichGraphics iRichGraphics, Color color, Color color2) {
        for (int i = 0; i < this.mTexts.size(); ++i) {
            GText gText = this.mTexts.elementAt(i);
            gText.drawGeom(iRichGraphics, color, color2);
        }
    }
}

