/*
 * Decompiled with CFR 0.152.
 */
package model.shape.primitive;

import model.shape.primitive.SVector3d;
import model.shape.primitive.Util;

public class SMatrix3d {
    public double e00;
    public double e01;
    public double e02;
    public double e10;
    public double e11;
    public double e12;
    public double e20;
    public double e21;
    public double e22;

    public void set(SMatrix3d sMatrix3d) {
        this.e00 = sMatrix3d.e00;
        this.e01 = sMatrix3d.e01;
        this.e02 = sMatrix3d.e02;
        this.e10 = sMatrix3d.e10;
        this.e11 = sMatrix3d.e11;
        this.e12 = sMatrix3d.e12;
        this.e20 = sMatrix3d.e20;
        this.e21 = sMatrix3d.e21;
        this.e22 = sMatrix3d.e22;
    }

    public void init() {
        this.e00 = 1.0;
        this.e01 = 0.0;
        this.e02 = 0.0;
        this.e10 = 0.0;
        this.e11 = 1.0;
        this.e12 = 0.0;
        this.e20 = 0.0;
        this.e21 = 0.0;
        this.e22 = 1.0;
    }

    public void translate(SVector3d sVector3d, double d, double d2, double d3) {
        sVector3d.x = this.e00 * d + this.e01 * d2 + this.e02 * d3;
        sVector3d.y = this.e10 * d + this.e11 * d2 + this.e12 * d3;
        sVector3d.z = this.e20 * d + this.e21 * d2 + this.e22 * d3;
    }

    public void multi(SMatrix3d sMatrix3d) {
        SMatrix3d sMatrix3d2 = this;
        double d = sMatrix3d2.e00 * sMatrix3d.e00 + sMatrix3d2.e01 * sMatrix3d.e10 + sMatrix3d2.e02 * sMatrix3d.e20;
        double d2 = sMatrix3d2.e00 * sMatrix3d.e01 + sMatrix3d2.e01 * sMatrix3d.e11 + sMatrix3d2.e02 * sMatrix3d.e21;
        double d3 = sMatrix3d2.e00 * sMatrix3d.e02 + sMatrix3d2.e01 * sMatrix3d.e12 + sMatrix3d2.e02 * sMatrix3d.e22;
        double d4 = sMatrix3d2.e10 * sMatrix3d.e00 + sMatrix3d2.e11 * sMatrix3d.e10 + sMatrix3d2.e12 * sMatrix3d.e20;
        double d5 = sMatrix3d2.e10 * sMatrix3d.e01 + sMatrix3d2.e11 * sMatrix3d.e11 + sMatrix3d2.e12 * sMatrix3d.e21;
        double d6 = sMatrix3d2.e10 * sMatrix3d.e02 + sMatrix3d2.e11 * sMatrix3d.e12 + sMatrix3d2.e12 * sMatrix3d.e22;
        double d7 = sMatrix3d2.e20 * sMatrix3d.e00 + sMatrix3d2.e21 * sMatrix3d.e10 + sMatrix3d2.e22 * sMatrix3d.e20;
        double d8 = sMatrix3d2.e20 * sMatrix3d.e01 + sMatrix3d2.e21 * sMatrix3d.e11 + sMatrix3d2.e22 * sMatrix3d.e21;
        double d9 = sMatrix3d2.e20 * sMatrix3d.e02 + sMatrix3d2.e21 * sMatrix3d.e12 + sMatrix3d2.e22 * sMatrix3d.e22;
        this.e00 = d;
        this.e01 = d2;
        this.e02 = d3;
        this.e10 = d4;
        this.e11 = d5;
        this.e12 = d6;
        this.e20 = d7;
        this.e21 = d8;
        this.e22 = d9;
    }

    public void multi(SMatrix3d sMatrix3d, SMatrix3d sMatrix3d2) {
        double d = sMatrix3d.e00 * sMatrix3d2.e00 + sMatrix3d.e01 * sMatrix3d2.e10 + sMatrix3d.e02 * sMatrix3d2.e20;
        double d2 = sMatrix3d.e00 * sMatrix3d2.e01 + sMatrix3d.e01 * sMatrix3d2.e11 + sMatrix3d.e02 * sMatrix3d2.e21;
        double d3 = sMatrix3d.e00 * sMatrix3d2.e02 + sMatrix3d.e01 * sMatrix3d2.e12 + sMatrix3d.e02 * sMatrix3d2.e22;
        double d4 = sMatrix3d.e10 * sMatrix3d2.e00 + sMatrix3d.e11 * sMatrix3d2.e10 + sMatrix3d.e12 * sMatrix3d2.e20;
        double d5 = sMatrix3d.e10 * sMatrix3d2.e01 + sMatrix3d.e11 * sMatrix3d2.e11 + sMatrix3d.e12 * sMatrix3d2.e21;
        double d6 = sMatrix3d.e10 * sMatrix3d2.e02 + sMatrix3d.e11 * sMatrix3d2.e12 + sMatrix3d.e12 * sMatrix3d2.e22;
        double d7 = sMatrix3d.e20 * sMatrix3d2.e00 + sMatrix3d.e21 * sMatrix3d2.e10 + sMatrix3d.e22 * sMatrix3d2.e20;
        double d8 = sMatrix3d.e20 * sMatrix3d2.e01 + sMatrix3d.e21 * sMatrix3d2.e11 + sMatrix3d.e22 * sMatrix3d2.e21;
        double d9 = sMatrix3d.e20 * sMatrix3d2.e02 + sMatrix3d.e21 * sMatrix3d2.e12 + sMatrix3d.e22 * sMatrix3d2.e22;
        this.e00 = d;
        this.e01 = d2;
        this.e02 = d3;
        this.e10 = d4;
        this.e11 = d5;
        this.e12 = d6;
        this.e20 = d7;
        this.e21 = d8;
        this.e22 = d9;
    }

    public void inverse(SMatrix3d sMatrix3d) {
        double[][] dArrayArray = new double[][]{{this.e00, this.e01, this.e02}, {this.e10, this.e11, this.e12}, {this.e20, this.e21, this.e22}};
        double[][] dArray = new double[3][3];
        if (!Util.invMatrix3d(dArrayArray, dArray)) {
            return;
        }
        sMatrix3d.e00 = dArray[0][0];
        sMatrix3d.e01 = dArray[0][1];
        sMatrix3d.e02 = dArray[0][2];
        sMatrix3d.e10 = dArray[1][0];
        sMatrix3d.e11 = dArray[1][1];
        sMatrix3d.e12 = dArray[1][2];
        sMatrix3d.e20 = dArray[2][0];
        sMatrix3d.e21 = dArray[2][1];
        sMatrix3d.e22 = dArray[2][2];
    }

    public double determinant() {
        double d = this.e00 * this.e11 * this.e22 + this.e01 * this.e12 * this.e20 + this.e02 * this.e21 * this.e10;
        return d -= this.e02 * this.e20 * this.e11 + this.e01 * this.e10 * this.e22 + this.e21 * this.e12 * this.e00;
    }

    public void inverseNew(SMatrix3d sMatrix3d) {
        double d = this.determinant();
        if (d == 0.0) {
            return;
        }
        double d2 = this.e00 * (this.e11 * this.e22 - this.e12 * this.e21) / d;
        double d3 = -this.e01 * (this.e10 * this.e22 - this.e12 * this.e20) / d;
        double d4 = this.e02 * (this.e10 * this.e21 - this.e11 * this.e20) / d;
        double d5 = -this.e10 * (this.e01 * this.e22 - this.e02 * this.e21) / d;
        double d6 = this.e11 * (this.e00 * this.e22 - this.e02 * this.e20) / d;
        double d7 = -this.e12 * (this.e00 * this.e21 - this.e01 * this.e20) / d;
        double d8 = this.e20 * (this.e01 * this.e12 - this.e02 * this.e11) / d;
        double d9 = -this.e21 * (this.e00 * this.e12 - this.e02 * this.e10) / d;
        double d10 = this.e22 * (this.e00 * this.e11 - this.e01 * this.e10) / d;
        System.out.println(d2 + d3 + d4);
        sMatrix3d.e00 = d2;
        sMatrix3d.e01 = d3;
        sMatrix3d.e02 = d4;
        sMatrix3d.e10 = d5;
        sMatrix3d.e11 = d6;
        sMatrix3d.e12 = d7;
        sMatrix3d.e20 = d8;
        sMatrix3d.e21 = d9;
        sMatrix3d.e22 = d10;
    }

    public void rotXY(double d) {
        this.init();
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.e00 = d2;
        this.e01 = -d3;
        this.e10 = d3;
        this.e11 = d2;
    }

    public void print() {
        System.out.println("->");
        System.out.println(String.valueOf(this.e00) + ", " + this.e01 + ", " + this.e02);
        System.out.println(String.valueOf(this.e10) + ", " + this.e11 + ", " + this.e12);
        System.out.println(String.valueOf(this.e20) + ", " + this.e21 + ", " + this.e22);
        System.out.println("<-\n");
    }
}

