/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.HashMap;
import java.util.Map;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.Value;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlFile;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.query.AbstractQuery;

public class SqlProcessorQuery
extends AbstractQuery {
    protected final Map<String, Value> parameters = new HashMap<String, Value>();
    protected String sqlFilePath;
    protected SqlFile sqlFile;
    protected PreparedSql sql;

    public void setSqlFilePath(String sqlFilePath) {
        this.sqlFilePath = sqlFilePath;
    }

    public void addParameter(String name, Class<?> type, Object value) {
        AssertionUtil.assertNotNull((Object)name, type);
        this.parameters.put(name, new Value(type, value));
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull(this.sqlFilePath);
        this.prepareSql();
    }

    protected void prepareSql() {
        this.sqlFile = this.config.getSqlFileRepository().getSqlFile(this.method, this.sqlFilePath, this.config.getDialect());
        ExpressionEvaluator evaluator = new ExpressionEvaluator(this.parameters, this.config.getDialect().getExpressionFunctions(), this.config.getClassHelper());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder(this.config, SqlKind.SQL_PROCESSOR, this.sqlFilePath, evaluator, SqlLogType.FORMATTED);
        this.sql = sqlBuilder.build(this.sqlFile.getSqlNode(), this::comment);
    }

    public PreparedSql getSql() {
        return this.sql;
    }

    @Override
    public void complete() {
    }
}

