/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.Value;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlExecutionSkipCause;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.query.AbstractQuery;
import org.seasar.doma.jdbc.query.ModifyQuery;

public abstract class SqlModifyQuery
extends AbstractQuery
implements ModifyQuery {
    protected final SqlKind kind;
    protected SqlNode sqlNode;
    protected final Map<String, Value> parameters = new LinkedHashMap<String, Value>();
    protected PreparedSql sql;
    protected boolean optimisticLockCheckRequired;
    protected SqlLogType sqlLogType;

    protected SqlModifyQuery(SqlKind kind) {
        AssertionUtil.assertNotNull((Object)kind);
        this.kind = kind;
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull(this.sqlNode);
        this.prepareOptions();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void prepareOptions() {
        if (this.queryTimeout <= 0) {
            this.queryTimeout = this.config.getQueryTimeout();
        }
    }

    protected void prepareSql() {
        ExpressionEvaluator evaluator = new ExpressionEvaluator(this.parameters, this.config.getDialect().getExpressionFunctions(), this.config.getClassHelper());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder(this.config, this.kind, null, evaluator, this.sqlLogType);
        this.sql = sqlBuilder.build(this.sqlNode, this::comment);
    }

    @Override
    public void complete() {
    }

    public void setSqlNode(SqlNode sqlNode) {
        this.sqlNode = sqlNode;
    }

    public void addParameter(String name, Class<?> type, Object value) {
        AssertionUtil.assertNotNull((Object)name, type);
        this.parameters.put(name, new Value(type, value));
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public void setSqlLogType(SqlLogType sqlLogType) {
        this.sqlLogType = sqlLogType;
    }

    @Override
    public PreparedSql getSql() {
        return this.sql;
    }

    @Override
    public boolean isOptimisticLockCheckRequired() {
        return this.optimisticLockCheckRequired;
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public SqlExecutionSkipCause getSqlExecutionSkipCause() {
        return null;
    }

    @Override
    public boolean isAutoGeneratedKeysSupported() {
        return false;
    }

    @Override
    public SqlLogType getSqlLogType() {
        return this.sqlLogType;
    }

    public String toString() {
        return this.sql != null ? this.sql.toString() : null;
    }
}

