/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.lang.reflect.Method;
import java.util.ListIterator;
import org.seasar.doma.internal.jdbc.entity.AbstractPostDeleteContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreDeleteContext;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.query.AutoBatchModifyQuery;
import org.seasar.doma.jdbc.query.BatchDeleteQuery;

public class AutoBatchDeleteQuery<ENTITY>
extends AutoBatchModifyQuery<ENTITY>
implements BatchDeleteQuery {
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public AutoBatchDeleteQuery(EntityType<ENTITY> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull((Object)this.method, (Object)this.entities, (Object)this.sqls);
        int size = this.entities.size();
        if (size == 0) {
            return;
        }
        this.executable = true;
        this.executionSkipCause = null;
        this.currentEntity = this.entities.get(0);
        this.preDelete();
        this.prepareIdAndVersionPropertyTypes();
        this.validateIdExistent();
        this.prepareOptions();
        this.prepareOptimisticLock();
        this.prepareSql();
        this.entities.set(0, this.currentEntity);
        ListIterator<Object> it = this.entities.listIterator(1);
        while (it.hasNext()) {
            this.currentEntity = it.next();
            this.preDelete();
            this.prepareSql();
            it.set(this.currentEntity);
        }
        AssertionUtil.assertEquals(size, this.sqls.size());
    }

    protected void preDelete() {
        AutoBatchPreDeleteContext context = new AutoBatchPreDeleteContext(this.entityType, this.method, this.config);
        this.entityType.preDelete(this.currentEntity, context);
        if (context.getNewEntity() != null) {
            this.currentEntity = context.getNewEntity();
        }
    }

    protected void prepareOptimisticLock() {
        if (this.versionPropertyType != null && !this.versionIgnored && !this.optimisticLockExceptionSuppressed) {
            this.optimisticLockCheckRequired = true;
        }
    }

    protected void prepareSql() {
        Property property;
        Naming naming = this.config.getNaming();
        Dialect dialect = this.config.getDialect();
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.BATCH_DELETE, this.sqlLogType);
        builder.appendSql("delete from ");
        builder.appendSql(this.entityType.getQualifiedTableName(naming::apply, dialect::applyQuote));
        boolean whereClauseAppended = false;
        if (this.idPropertyTypes.size() > 0) {
            builder.appendSql(" where ");
            whereClauseAppended = true;
            for (EntityPropertyType propertyType : this.idPropertyTypes) {
                Property property2 = propertyType.createProperty();
                property2.load(this.currentEntity);
                builder.appendSql(propertyType.getColumnName(naming::apply, dialect::applyQuote));
                builder.appendSql(" = ");
                builder.appendParameter(property2.asInParameter());
                builder.appendSql(" and ");
            }
            builder.cutBackSql(5);
        }
        if (this.versionPropertyType != null && !this.versionIgnored) {
            if (whereClauseAppended) {
                builder.appendSql(" and ");
            } else {
                builder.appendSql(" where ");
                whereClauseAppended = true;
            }
            property = this.versionPropertyType.createProperty();
            property.load(this.currentEntity);
            builder.appendSql(this.versionPropertyType.getColumnName(naming::apply, dialect::applyQuote));
            builder.appendSql(" = ");
            builder.appendParameter(property.asInParameter());
        }
        if (this.tenantIdPropertyType != null) {
            if (whereClauseAppended) {
                builder.appendSql(" and ");
            } else {
                builder.appendSql(" where ");
                whereClauseAppended = true;
            }
            property = this.tenantIdPropertyType.createProperty();
            property.load(this.currentEntity);
            builder.appendSql(this.tenantIdPropertyType.getColumnName(naming::apply, dialect::applyQuote));
            builder.appendSql(" = ");
            builder.appendParameter(property.asInParameter());
        }
        PreparedSql sql = builder.build(this::comment);
        this.sqls.add(sql);
    }

    @Override
    public void complete() {
        ListIterator<Object> it = this.entities.listIterator();
        while (it.hasNext()) {
            this.currentEntity = it.next();
            this.postDelete();
            it.set(this.currentEntity);
        }
    }

    protected void postDelete() {
        AutoBatchPostDeleteContext context = new AutoBatchPostDeleteContext(this.entityType, this.method, this.config);
        this.entityType.postDelete(this.currentEntity, context);
        if (context.getNewEntity() != null) {
            this.currentEntity = context.getNewEntity();
        }
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored = versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class AutoBatchPostDeleteContext<E>
    extends AbstractPostDeleteContext<E> {
        public AutoBatchPostDeleteContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }

    protected static class AutoBatchPreDeleteContext<E>
    extends AbstractPreDeleteContext<E> {
        public AutoBatchPreDeleteContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }
}

