/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.id;

import javax.sql.DataSource;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.RequiresNewController;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.id.IdProvider;

public class IdGenerationConfig {
    protected final Config config;
    protected final EntityType<?> entityType;
    protected final IdProvider idProvider;

    public IdGenerationConfig(Config config, EntityType<?> entityType) {
        this(config, entityType, new UnavailableIdProvider());
    }

    public IdGenerationConfig(Config config, EntityType<?> entityType, IdProvider idProvider) {
        AssertionUtil.assertNotNull((Object)config, entityType, (Object)idProvider);
        this.config = config;
        this.entityType = entityType;
        this.idProvider = idProvider;
    }

    public DataSource getDataSource() {
        return this.config.getDataSource();
    }

    public String getDataSourceName() {
        return this.config.getDataSourceName();
    }

    public Dialect getDialect() {
        return this.config.getDialect();
    }

    public JdbcLogger getJdbcLogger() {
        return this.config.getJdbcLogger();
    }

    public RequiresNewController getRequiresNewController() {
        return this.config.getRequiresNewController();
    }

    public Naming getNaming() {
        return this.config.getNaming();
    }

    public int getFetchSize() {
        return this.config.getFetchSize();
    }

    public int getMaxRows() {
        return this.config.getMaxRows();
    }

    public int getQueryTimeout() {
        return this.config.getQueryTimeout();
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public IdProvider getIdProvider() {
        return this.idProvider;
    }

    protected static class UnavailableIdProvider
    implements IdProvider {
        protected UnavailableIdProvider() {
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public long get() {
            throw new UnsupportedOperationException();
        }
    }
}

