/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.entity;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.seasar.doma.internal.jdbc.util.DatabaseObjectUtil;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.NamingType;

public abstract class AbstractEntityType<ENTITY>
implements EntityType<ENTITY> {
    protected AbstractEntityType() {
    }

    @Override
    public String getQualifiedTableName() {
        return this.getQualifiedTableName(Function.identity());
    }

    @Override
    public String getQualifiedTableName(Function<String, String> quoteFunction) {
        return this.getQualifiedTableName((namingType, text) -> namingType.apply((String)text), quoteFunction);
    }

    @Override
    public String getQualifiedTableName(BiFunction<NamingType, String, String> namingFunction, Function<String, String> quoteFunction) {
        String catalogName = this.getCatalogName();
        String schemaName = this.getSchemaName();
        String tableName = this.getTableName(namingFunction);
        Function<String, String> mapper = this.isQuoteRequired() ? quoteFunction : Function.identity();
        return DatabaseObjectUtil.getQualifiedName(mapper, catalogName, schemaName, tableName);
    }
}

